package com.akamai.tvuisample;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.ui.tv.MediaControlBarManager;
import com.akamai.amp.ui.tv.MediaPlayerController;

public class MainActivity extends Activity implements
        MediaControlBarManager.OnRemoteControlActionsListener,
        VideoPlayerContainer.VideoPlayerContainerCallback {

    private final static String TAG = "AMPv6TV";
    private final static String VIDEO_URL = "https://media-demo-host.akamaized.net/test/video/kluge/hls/all.m3u8";
    //private static final String VIDEO_URL = "http://ibc2018atveu.akamaized.net/hls/live/691932/akamaitv1/master.m3u8";

    private VideoPlayerContainer mVideoPlayerContainer;
    private VideoPlayerView mVideoPlayerView;
    private ProgressBar mProgressBar;
    private MediaPlayerController mediaPlayerController;
    private MediaControlBarManager mediaControlBarManager;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        mediaPlayerController = (MediaPlayerController)
                getFragmentManager().findFragmentById(R.id.playback_controls_fragment);
        mProgressBar = (ProgressBar) findViewById(R.id.progressBar);
        mVideoPlayerContainer = (VideoPlayerContainer) findViewById(R.id.playerViewCtrl);
        mVideoPlayerContainer.addVideoPlayerContainerCallback(this);
        mVideoPlayerContainer.setApiKey("demo");
        mVideoPlayerContainer.prepareResource(VIDEO_URL);

    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        mVideoPlayerView = mVideoPlayerContainer.getVideoPlayer();
        mediaControlBarManager = new MediaControlBarManager(this, this, mediaPlayerController);
        mediaControlBarManager.CCActionEnabled(false, false);
        mediaControlBarManager.setVideoPlayerView(mVideoPlayerView);
        mVideoPlayerView.setProgressBarControl(mProgressBar);
        mVideoPlayerView.play(mediaResource);

    }


    @Override
    public boolean onRemoteActionReceived(MediaControlBarManager.RemoteControlAction action){
        switch (action) {
            case PLAY:
                return true;
            case PAUSE:
                return true;
            case FAST_FORWARD:
                return true;
            case REWIND:
                return true;
            case CAPTION_ON:
                return true;
            case CAPTION_OFF:
                return true;
            default:
                return false;
        }
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(TAG, "onResourceError()");
    }

    @Override
    protected void onResume() {
        Log.d(TAG, "onResume");
        if (mVideoPlayerView != null) {
            mVideoPlayerView.onResume();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.d(TAG, "onPause");
        if (mVideoPlayerView != null) {
            mVideoPlayerView.onPause();
        }
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        Log.d(TAG, "onDestroy");
        if(mVideoPlayerView != null){
            mVideoPlayerView.onDestroy();
        }
        super.onDestroy();
    }

    @Override
    public boolean onKeyUp(int keyCode, final KeyEvent event) {
        return super.onKeyUp(keyCode, event) ||
                (mediaControlBarManager != null && mediaControlBarManager.onKeyUp(keyCode));
    }

    @Override
    public boolean onKeyDown(final int keyCode, final KeyEvent event) {
        return super.onKeyDown(keyCode, event) ||
                (mediaControlBarManager != null && (keyCode != KeyEvent.KEYCODE_MEDIA_PLAY_PAUSE || event.getRepeatCount() == 0)
                        && mediaControlBarManager.onKeyDown(keyCode));
    }

}
