package com.akamai.amp.demo.helpers.analytics;


import com.akamai.amp.config.data.streamsense.StreamsenseAppData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.comscore.streaming.ContentMetadata;
import com.comscore.streaming.ContentType;

import java.util.HashMap;
import java.util.Map;

public class StreamsenseHelper {

    public static StreamsenseData buildData(VideoPlayerView videoPlayerView) {
        StreamsenseData data = new StreamsenseData(videoPlayerView);
        data.setAppData(buildAppData());
        //data.setPlaylistLabels(buildPlaylistLabels());
        //data.setVideoLabels(buildVideoLabels());
        //data.setAdLabels(buildAdLabels());
        data.setPersistentLabels(buildPersistentLabels());
        return data;
    }

    public static StreamsenseAppData buildAppData() {
        StreamsenseAppData app = new StreamsenseAppData();
        app.setAppName(AMPLibraryInfo.NAME);
        app.setAppVersion(AMPLibraryInfo.VERSION);
        app.setPublisherId("1234567");
        return app;
    }

    private static Map<String, String> buildPersistentLabels() {
        Map<String, String> labels = new HashMap<>();
        labels.put("sample", "persistentLabel");
        return labels;
    }

    private static Map<String, String> buildCustomLabels() {
        Map<String, String> labels = new HashMap<>();
        labels.put("customLabel", "customValue");
        return labels;
    }

    public static ContentMetadata buildContentMetadata() {
        ContentMetadata cm = new ContentMetadata.Builder()
                .mediaType(ContentType.LONG_FORM_ON_DEMAND)
                .uniqueId("13784")
                .length(1418000) // 23m58s in milliseconds
                .dictionaryClassificationC3("*null")
                .dictionaryClassificationC4("*null")
                .dictionaryClassificationC6("*null")
                .stationTitle("Hulu")
                .publisherName("ABC")
                .programTitle("Modern Family")
                .genreName("Comedy")
                .classifyAsCompleteEpisode(true)
                .customLabels(buildCustomLabels())
                //.classifyAsAudioStream(boolean)
                //.classifyAsCompleteEpisode(boolean)
                //.carryTvAdvertisementLoad(boolean)
                //.uniqueId(string)
                //.length(long)
                //.totalSegments(int)
                //.publisherName(string)
                //.programTitle(string)
                //.episodeTitle(string)
                //.episodeSeasonNumber(string)
                //.episodeNumber(string)
                //.genreName(string)
                //.genreId(string)
                //.dateOfProduction(int, int, int)
                //.timeOfProduction(int, int)
                //.dateOfDigitalAiring(int, int, int)
                //.timeOfDigitalAiring(int, int)
                //.dateOfTvAiring(int, int, int)
                //.timeOfTvAiring(int, int)
                //.stationTitle(string)
                //.stationCode(string)
                //.programId(string)
                //.episodeId(string)
                //.networkAffiliate(string)
                //.fee(int)
                //.clipUrl(string)
                //.playlistTitle(string)
                //.feedType(int)
                //.videoDimensions(int, int)
                //.dictionaryClassificationC3(string)
                //.dictionaryClassificationC4(string)
                //.dictionaryClassificationC6(string)
                //.deliveryMode(int)
                //.deliverySubscriptionType(int)
                //.deliveryComposition(int)
                //.deliveryAdvertisementCapability(int)
                //.distributionModel(int)
                //.mediaFormat(int)
                .build();
        return cm;
    }
}
