package com.akamai.amp.demo.helpers.analytics;

import com.akamai.amp.config.data.NielsenAdData;
import com.akamai.amp.config.data.NielsenAppData;
import com.akamai.amp.config.data.NielsenContentData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.media.elements.AMPLibraryInfo;

import java.util.HashMap;
import java.util.Map;


public class NielsenHelper {

    private static final String NIELSEN_DATA_APP_ID = "T9C30276D-DB8E-42D6-9768-893BD504623D";
    private static final String NIELSEN_DATA_APP_VERSION = AMPLibraryInfo.VERSION;
    private static final String NIELSEN_DATA_APP_NAME = AMPLibraryInfo.NAME;
    private static final String NIELSEN_DATA_SF_CODE = "cert";


    public static NielsenData buildData() {
        NielsenAppData appData = buildAppData();
        NielsenContentData contentData = buildContentData();
        NielsenAdData adData = buildAdData();
        NielsenData data = new NielsenData(appData, contentData, adData);
        return data;
    }

    private static NielsenAppData buildAppData() {
        Map<String, String> data = new HashMap<>();
        data.put("appid", NIELSEN_DATA_APP_ID);
        data.put("appversion", NIELSEN_DATA_APP_VERSION);
        data.put("appname", NIELSEN_DATA_APP_NAME);
        data.put("sfcode", NIELSEN_DATA_SF_CODE);

        NielsenAppData appData = new NielsenAppData(data);
        return appData;
    }

    private static NielsenContentData buildContentData() {
        Map<String, String> data = new HashMap<>();
        data.put("clientid", "Nielsen");
        data.put("Nielsen", "Nielsen");
        data.put("type", "content");
        data.put("program", "MySampleProgram");
        data.put("title", "MySampleTitle");
        data.put("assetid", "MySampleAssetId");
        data.put("isfullepisode", "Y");
        data.put("segB", "MySampleSegB");
        data.put("airdate", "20161013 20:00:00");
        data.put("hasAds", "1");
        data.put("progen", "CV");
        data.put("adModel", "2");
        NielsenContentData contentData = new NielsenContentData(data);
        return contentData;
    }

    private static NielsenAdData buildAdData() {
        Map<String, String> data = new HashMap<>();
        data.put("type", "preroll");
        data.put("assetid", "myAdAssetId");
        NielsenAdData appData = new NielsenAdData(data);
        return appData;
    }

}
