package com.akamai.amp.demo.helpers.analytics;

import com.akamai.amp.analytics.adobeheartbeat.AdobeHeartbeat;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.config.data.heartbeat.HeartbeatData;

import java.util.HashMap;
import java.util.Map;

//import com.akamai.amp.analytics.adobeheartbeat.AmpAdobeHeartbeatAnalyticsTracker;


public class HeartbeatHelper {

    private static final String HEARTBEAT_TRACKING_SERVER = "http://obumobile1.hb.omtrdc.net";
    private static final String HEARTBEAT_PUBLISHER = "TEST";
    private static final String HEARTBEAT_CHANNEL = "test-channel";
    private static final String HEARTBEAT_OVP = "test-ovp";
    private static final String AUDIENCE_MANAGER_DPID = "67312378756723456";
    private static final String AUDIENCE_MANAGER_DPUUID = "550e8400-e29b-41d4-a716-446655440000";
    private static final String ADOBE_USER_ID = "test-vid";


    private static final String TEST_VIDEO_ID = "TestID123";
    private static final String TEST_CONTENT_TITLE = "AmpContentTitle";


    public static HeartbeatData buildData() {
        HeartbeatData data = new HeartbeatData(buildHeartbeatConfigurationData());
        data.setStandardVideoMetadata(getStandardVideoMetadata());
        return data;
    }

    private static Map<String, String> getStandardVideoMetadata() {
        Map<String, String> values = new HashMap<>();
        values.put(AdobeHeartbeat.KEY_MEDIA_ID, TEST_VIDEO_ID);
        values.put(AdobeHeartbeat.KEY_MEDIA_FRIENDLY_NAME, TEST_CONTENT_TITLE);
        values.put("testKey", "testValue");
        return values;
    }

    private static HeartbeatConfigurationData buildHeartbeatConfigurationData() {
        HeartbeatConfigurationData data = new HeartbeatConfigurationData();
        data.setTrackingServer(HEARTBEAT_TRACKING_SERVER);
        data.setPublisher(HEARTBEAT_PUBLISHER);
        data.setChannel(HEARTBEAT_CHANNEL);
        data.setOvp(HEARTBEAT_OVP);
        data.setAudienceManagerDpid(AUDIENCE_MANAGER_DPID);
        data.setAudienceManagerDpuuid(AUDIENCE_MANAGER_DPUUID);
        data.setAdobeUserId(ADOBE_USER_ID);
        return data;
    }

}
