package com.akamai.ampdemo;

import android.app.AlertDialog;
import android.os.Handler;
import android.os.SystemClock;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.ampcustom.SntpClient;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class MainActivity extends AppCompatActivity implements LogManager.Logs, IPlayerEventsListener, View.OnClickListener, VideoPlayerContainer.VideoPlayerContainerCallback {

    private VideoPlayerView mVideoPlayerView;
    private boolean allowSeekJumps = true;
    private int maxBufferMs = 8000;
    private int targetBufferMs = 2800;
    private int bufferingEvents;
    private long now;
    public String streamSelected = "";

    public String dashLL = "https://akamaibroadcasteruseast.akamaized.net/cmaf/live/657078/akasource/out.mpd";
    public String LHLS = "https://akamaibroadcasteruseast.akamaized.net/cmaf/live/657078/akasource/master.m3u8";

    private String TAG;
    private VideoPlayerContainer mVideoPlayerContainer;
    private ProgressBar mProgressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;
    private ScrollView scrollView;
    private TextView logger;
    private TextView currentBitrate;
    private TextView frameDimensions;
    private TextView latency;
    private TextView bufferAvailable;
    private TextView bufferingCount;
    private TextView playbackRate;
    private TextView utcTime;
    private LinearLayout statsPanel;
    private Button statsButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setContentView(R.layout.activity_main);

        TAG = getString(R.string.app_name);
        mVideoPlayerContainer = findViewById(R.id.video_player_container);
        mProgressBar = findViewById(R.id.progress_bar);
        mPlayerControlsOverlay = findViewById(R.id.playerControls);
        scrollView = findViewById(R.id.scroll_view);
        logger = findViewById(R.id.logger);
        currentBitrate = findViewById(R.id.current_bitrate);
        frameDimensions = findViewById(R.id.frame_dimensions);
        latency = findViewById(R.id.latency);
        bufferAvailable = findViewById(R.id.buffer_available);
        bufferingCount = findViewById(R.id.buffering_count);
        playbackRate = findViewById(R.id.playback_rate);
        utcTime = findViewById(R.id.utc);
        statsPanel = findViewById(R.id.video_panel_info);
        statsButton = findViewById(R.id.stats_button);
        statsButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (statsPanel.getVisibility() == View.VISIBLE) {
                    statsButton.setText("See Stats");
                    statsPanel.setVisibility(View.GONE);
                } else {
                    statsButton.setText("Hide Stats");
                    statsPanel.setVisibility(View.VISIBLE);
                }
            }
        });

        trustEveryone();
        mVideoPlayerContainer.addVideoPlayerContainerCallback(this);
        streamSelected = "https://akamaibroadcasteruseast.akamaized.net/cmaf/live/657078/akasource/out.mpd";
        initPlaybackSequence();
    }

    private void updateValues() {
        final int millisecondRate = 1;
        final Handler mHandler = new Handler();
        Runnable mRunnable = new Runnable() {
            @Override
            public void run() {
                if (mVideoPlayerView != null) {
                    long bitrate = mVideoPlayerView.getCurrentBitrate() / 1000;
                    String bitrateMsg = "Current Bitrate: " + bitrate + " Kbps";
                    String frameDimensionsText = "Dimensions: " + mVideoPlayerView.getVideoWidth() +
                            "x" + mVideoPlayerView.getVideoHeight();
                    String bufferCount = "Buffering Events: " + bufferingEvents;
                    String latencyText = "Target latency: " + (float) targetBufferMs/1000 + " secs";
                    float bufferInSecs = (float) mVideoPlayerView.getBufferAvailable()/1000;
                    String bufferAvailableText = "Buffer Available: " + bufferInSecs + " secs";
                    String playbackRateText = "Playback rate: " + mVideoPlayerView.getPlaybackRate() + " x";

                    latency.setText(latencyText);
                    bufferAvailable.setText(bufferAvailableText);
                    playbackRate.setText(playbackRateText);
                    currentBitrate.setText(bitrateMsg);
                    frameDimensions.setText(frameDimensionsText);
                    bufferingCount.setText(bufferCount);

                }
                updateNow();
                String currentUTC = "UTC Time: " + Utils.toDateString(now, "HH:mm:ss.SSS");
                utcTime.setText(currentUTC);

                mHandler.postDelayed(this, millisecondRate);
            }
        };
        mHandler.post(mRunnable);
    }

    private void updateNow(){
        SntpClient sntpClient = AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().getSntpClient();
        now = sntpClient.getNtpTime() + SystemClock.elapsedRealtime() - sntpClient.getNtpTimeReference();
    }

    private void initPlaybackSequence(){
        if(mVideoPlayerView != null)
            mVideoPlayerView.stop();
        AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().startSntpClient();
        updateValues();
        setupUI();
        mVideoPlayerContainer.turnOnLowLatency(allowSeekJumps, targetBufferMs, maxBufferMs);
        mVideoPlayerContainer.setApiKey("demo");
        mVideoPlayerContainer.prepareResource(streamSelected);
    }

    private void setupUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.androidsdk_mediaplayercontroller);
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.mipmap.play,
                R.mipmap.pause);
        mPlayerControlsOverlay.manageQualityLevels(R.id.renditions_button);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageVideoDuration(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
        mPlayerControlsOverlay.getCurrentOverlayState().enableAutoHide(this, false);
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG, "onVideoPlayerCreated()");
        mVideoPlayerView = mVideoPlayerContainer.getVideoPlayer();
        addLogEntry(AMPLibraryInfo.NAME);
        addLogEntry("AMP Version: " + AMPLibraryInfo.VERSION);
        mVideoPlayerView.setReactToAudioFocusInTheBackground(false);
        mPlayerControlsOverlay.setVideoPlayerContainer(mVideoPlayerContainer);
        mVideoPlayerView.setLogEnabled(true);
        mVideoPlayerView.setLogger(this);
        mVideoPlayerView.enableDVRfeatures(true);
        mVideoPlayerView.addEventsListener(this);
        mVideoPlayerView.setProgressBarControl(mProgressBar);
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        mVideoPlayerView.play(mediaResource);
        Log.i(TAG, "AMP v" + AMPLibraryInfo.VERSION);
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        addLogEntry(exception.getMessage());
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mVideoPlayerView != null) {
            mVideoPlayerView.onResume();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mVideoPlayerView != null)
            mVideoPlayerView.onPause();
    }


    @Override
    protected void onDestroy() {
        if (mVideoPlayerView != null) {
            mVideoPlayerView.onDestroy();
        }
        super.onDestroy();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_new:
                displaySimpleDialog();
                break;
            default:
                break;
        }
        return true;
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void log(String logEntry) {
        addLogEntry(logEntry);
    }

    protected void addLogEntry(String logEntry) {
        String logAppend = logger.getText().toString();
        if (logAppend.isEmpty()) {
            logAppend = logEntry;
        } else {
            logAppend += "\n" + logEntry;
        }
        logger.setText(logAppend);
        if (scrollView != null) {
            scrollView.post(() -> scrollView.fullScroll(View.FOCUS_DOWN));
        }
    }

    //Player events
    @Override
    public boolean onPlayerEvent(int eventId) {
        if(eventId == PLAYER_EVENT_TYPE_END_REBUFFERING)
            bufferingEvents++;
        String logEntry = getEventName(eventId);
        if (!logEntry.isEmpty()) {
            addLogEntry("Video Event: " + logEntry);
        }
        return true;
    }



    private void displaySimpleDialog() {

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        LayoutInflater inflater = this.getLayoutInflater();
        View containerView = inflater.inflate(R.layout.dialog_layout, null);
        String[] types = { "DASH-LL", "LHLS"};

        EditText streamURL = containerView.findViewById(R.id.stream_input);
        Spinner typeSpinner = containerView.findViewById(R.id.typeSpinner);

        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, R.layout.spinner_item,types);

        typeSpinner.setAdapter(adapter);
        streamURL.setText(streamSelected);
        TextView targetBufferText = containerView.findViewById(R.id.target_buffer_text);
        SeekBar targetBufferSeekbar = containerView.findViewById(R.id.target_buffer_seekBar);
        targetBufferText.setText(String.valueOf((float) targetBufferMs/1000));
        targetBufferSeekbar.setProgress((targetBufferMs/100) - 10);
        typeSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                if(i == 0)
                    streamSelected = dashLL;
                else
                    streamSelected = LHLS;
                streamURL.setText(streamSelected);
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
        targetBufferSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                targetBufferMs = (progress + 10) * 100;
                targetBufferText.setText(String.valueOf((float) targetBufferMs/1000));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
        Button dialogAction = containerView.findViewById(R.id.action_button);

        builder.setView(containerView);

        final AlertDialog dialog = builder.create();
        dialogAction.setOnClickListener(v -> {
            streamSelected = streamURL.getText().toString();
            initPlaybackSequence();
            dialog.dismiss();
        });

        dialog.show();
    }


    @Override
    public boolean onPlayerExtendedEvent(int var1, int var2, int var3) {
        return true;
    }


    private String getEventName(int eventId) {
        switch (eventId) {
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_START_PLAYING: return "Playback started!!";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_START_REBUFFERING: return "Start buffering";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_END_REBUFFERING: return "End buffering";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_FINISHED: return "Playback finished!!";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_SIZE_CHANGE: return "Frame size changed";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_PAUSE_REQUESTED: return "Playback paused";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_RESUME_REQUESTED: return "Playback resumed";
            case IPlayerEventsListener.PLAYER_EXTENDED_EVENT_SEEKING_STARTED: return "Finish scrubbing!";
            case IPlayerEventsListener.PLAYER_EVENT_TYPE_SWITCH_REQUESTED: return "Adaptive playback, requesting new bitrate ...";
            default: return "";
        }
    }


    private void trustEveryone() {
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[] {
                    new X509TrustManager() {
                        public void checkClientTrusted(X509Certificate[] chain,
                                                       String authType) throws CertificateException {}
                        public void checkServerTrusted(X509Certificate[] chain,
                                                       String authType) throws CertificateException {}
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }
            }, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(
                    context.getSocketFactory());
        } catch (Exception e) { // should never happen
            e.printStackTrace();
        }
    }

    @Override
    public void onClick(View view) {

    }
}