package com.akamai.ampaudiodemo;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v7.app.ActionBarActivity;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import java.util.Stack;


public class MainActivity extends ActionBarActivity {

    public Stack<AudioData> streams;
    private Button btnSwitch;
    private AudioService audioService;
    boolean mBound = false;
    private final static String TAG = MainActivity.class.getSimpleName();


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        streams = initStreams();
        btnSwitch = (Button) findViewById(R.id.btnSwitch);

        btnSwitch.setOnClickListener((View v) -> {
                if (streams.size() == 0) {
                    Toast.makeText(MainActivity.this, "Reloading streams!", Toast.LENGTH_SHORT).show();
                    streams = initStreams();
                }
                AudioData stream = streams.pop();
                startPlayback(stream);
        });
    }


    private Stack<AudioData> initStreams() {
        Stack<AudioData> audioDataStack = new Stack<>();
        audioDataStack.push(
                new AudioData(
                        "https://nrkradio-f.akamaihd.net/i/p3_0@4275/master.m3u8",
                        "https://i.pinimg.com/736x/c6/fd/e5/c6fde5c2f09f0d30867cd9f3e68fd416--music-painting-art-music.jpg"));
        audioDataStack.push(
                new AudioData(
                        "https://nrkradio-f.akamaihd.net/i/p2_0@4274/master.m3u8",
                        "https://static.pixlee.com/photos/109250094/medium/331b9c7c110103c65cbf.jpg"));
        return audioDataStack;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return false;
    }

    @Override
    public void onDestroy(){
        super.onDestroy();
       stopPlayback();
    }

    @Override
    protected void onStart() {
        super.onStart();
        Intent intent = new Intent(this, AudioService.class);
        bindService(intent,mConnection, Context.BIND_AUTO_CREATE);
    }

    private void stopPlayback(){
        unbindService(mConnection);
        Intent intent = new Intent(this, AudioService.class);
        stopService(intent);
    }

    private void startPlayback(AudioData data){
        Intent intent = new Intent(this, AudioService.class);
        intent.putExtra("URL", data.getUrl());
        intent.putExtra("IMG", data.getPoster());
        startService(intent);
    }


    /** Defines callbacks for service binding, passed to bindService() */
    private ServiceConnection mConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            AudioService.LocalBinder binder = (AudioService.LocalBinder) iBinder;
            audioService = binder.getService();
            audioService.setActivity(MainActivity.this);
            mBound = true;
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            mBound = false;
        }
    };

}
