package com.akamai.ampdemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.analytics.nielsenanalytics.AmpNielsenDcrAnalyticsTracker;
import com.akamai.amp.analytics.nielsenanalytics.NielsenDcr;
import com.akamai.amp.config.data.NielsenAdData;
import com.akamai.amp.config.data.NielsenAppData;
import com.akamai.amp.config.data.NielsenContentData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.nielsen.app.sdk.AppSdk;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class PlayerActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback, IAdsComponentListener {

    private static final String LOG_TAG = PlayerActivity.class.getSimpleName();

    private static final String NIELSEN_DATA_APP_ID = "T9C30276D-DB8E-42D6-9768-893BD504623D";
    private static final String NIELSEN_DATA_APP_VERSION = AMPLibraryInfo.VERSION;
    private static final String NIELSEN_DATA_APP_NAME = AMPLibraryInfo.NAME;
    private static final String NIELSEN_DATA_SF_CODE = "cert";

    //DAR
    private static final String DAR_TEST_TAG = "http://secure-cert.imrworldwide.com/cgi-bin/m?ci=nlsnci535&am=3&at=view&rt=banner&st=image&ca=nlsn13134&cr=crtve&pc=CUSTOMER_plc001&ce=CUSTOMER&r="; //needs to append a timestamp in the end
    private static final String DAR_TEST_TAG_FROM_DOCS = "http://secure-us.imrworldwide.com/cgi-bin/m?ci=ent30986&am=22&ep=1&at=view&rt=banner&st=image&ca=cmp97144&cr=1186239&pc=3739659&r=2011370876";
    private static final DateFormat DAR_TIMESTAMP_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");


    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar progressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private AmpIMAManager ads;
    private AmpNielsenDcrAnalyticsTracker analytics;

    private Video videoSelected;

    private Button buttonOptOut;
    private String optOutPage = null;
    private String optOutRequest = "";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_player);

        Intent intent = getIntent();
        videoSelected = (Video) intent.getSerializableExtra("videoSelected");

        progressBar = findViewById(R.id.progressBar);
        videoPlayerContainer = findViewById(R.id.playerViewCtrl);
        mPlayerControlsOverlay = (PlayerControlsOverlay) findViewById(R.id.playerControls);
        setInlineUI();
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        videoPlayerContainer.setApiKey("demo");
        videoPlayerContainer.prepareResource(videoSelected.videoURL);

        //videoPlayerContainer.enableAutoRecovery();

        buttonOptOut = findViewById(R.id.btnOptOut);
        configButton();
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

    private NielsenData buildNielsenData() {
        NielsenAppData appData = buildAppData();
        NielsenContentData contentData = buildContentData();
        NielsenAdData adData = buildAdData();
        NielsenData data = new NielsenData(appData, contentData, adData);
        return data;
    }

    private NielsenAppData buildAppData() {
        Map<String, String> data = new HashMap<>();
        data.put("appid", NIELSEN_DATA_APP_ID);
        data.put("appversion", NIELSEN_DATA_APP_VERSION);
        data.put("appname", NIELSEN_DATA_APP_NAME);
        data.put("sfcode", NIELSEN_DATA_SF_CODE);
        data.put("clientid", "AppSampleClientId");
        data.put("prod", "vc,iag");
        data.put("category", "AppSampleCategory");
        data.put("tfid", "AppSampleTfid");
        data.put("vcid", "AppSampleVcId");
        data.put("sid", "AppSampleSid");
        data.put("pd", "AppSamplePd");
        data.put("nol_devDebug", "DEBUG");
        data.put("nol_url_override", "");

        if (videoPlayerView != null) {
            data.put("containerid", videoPlayerView.getId() + "");
        }

        NielsenAppData appData = new NielsenAppData(data);
        return appData;
    }


    private NielsenContentData buildContentData() {
        Map<String, String> data = new HashMap<>();
        data.put("clientid", "Nielsen");
        data.put("Nielsen", "Nielsen");
        data.put("type", "content");
        data.put("program", "MySampleProgram");
        data.put("title", "MySampleTitle");
        data.put("assetid", "MySampleAssetId");
        data.put("isfullepisode", "Y");
        data.put("segB", "MySampleSegB");
        data.put("airdate", "20161013 20:00:00");
        data.put("hasAds", "1");
        data.put("adModel", "2");
        data.put("progen", "DD");
        NielsenContentData contentData = new NielsenContentData(data);
        return contentData;
    }

    private NielsenAdData buildAdData() {
        Map<String, String> data = new HashMap<>();
        data.put("type", "preroll");
        data.put("assetid", "myAdAssetId");
        data.put("title", "myTitle");
        NielsenAdData appData = new NielsenAdData(data);
        return appData;
    }

    private void initGoogleAds() {
        String adsUrl = videoSelected.adsUrl;
        if (adsUrl == null) return;

        ads = IMA.create(PlayerActivity.this)
        .buildClientSideManager();
        ads.setVideoPlayerContainer(videoPlayerContainer);
        ads.setVideoPlayerView(videoPlayerView);
        ads.addEventsListener(this);
        ads.addEventsListener(analytics.getiAdsComponentListener());
        ads.setAdsUrl(adsUrl);
        ads.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());
    }

    private View.OnClickListener onOptOutClick() {
        return new View.OnClickListener() {
            public void onClick(View v) {
                if (analytics == null) return;

                optOutPage = analytics.getOptOutUrl();

                if ((optOutPage == null) || (optOutPage.isEmpty())) {
                    onNoOptOutUrl();
                } else {
                    onOptOutUrl();
                }
            }
        };
    }

    private void onOptOutUrl() {
        Intent i = new Intent(PlayerActivity.this, OptOutActivity.class);
        final Bundle pars = new Bundle();
        if (i != null && pars != null) {
            pars.putString(Global.keyWebUrl, optOutPage);
            i.putExtras(pars);
            PlayerActivity.this.startActivityForResult(i, Global.OPTOUT_REQUEST);
        }
    }

    private void onNoOptOutUrl() {
        final AlertDialog.Builder builder = new AlertDialog.Builder(PlayerActivity.this);
        builder.setMessage("No Opt-Out Url is available.").setTitle("Launch Opt-Out page").setCancelable(false)
                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.cancel();
                    }
                });
        builder.show();
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.d(LOG_TAG, "onResourceError()");
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setLogEnabled(true);
        videoPlayerView.setKeepScreenOn(true);
        videoPlayerView.setProgressBarControl(progressBar);

        analytics = NielsenDcr.create(videoPlayerView, buildNielsenData());
        initGoogleAds();
        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);


        videoPlayerView.play(mediaResource);

        Log.i(LOG_TAG, "AMP v: " + AMPLibraryInfo.VERSION + " with Nielsen DCR v" + AppSdk.getMeterVersion());
    }

    private void configButton()
    {
        if (buttonOptOut == null) return;

        buttonOptOut.setVisibility(View.VISIBLE);
        buttonOptOut.setOnClickListener(onOptOutClick());
    }

    //It's mandatory to let the SDK know when the app goes and comes to the backgrond

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (videoPlayerView != null) videoPlayerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (videoPlayerView != null) videoPlayerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) videoPlayerView.onDestroy();
        super.onDestroy();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        return false;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if ((requestCode == Global.OPTOUT_REQUEST) && (data != null)) {
            String result = data.getStringExtra(Global.keyOptResult);
            if (result != null) {
                if (result.indexOf("nielsenappsdk") == 0) {
                    optOutRequest = result; // result.substring(result.length()-1);
                    Log.d(LOG_TAG, "OPT-OUT " + optOutRequest);
                } else if (result.equals("closeAll")) {
                    Log.d(LOG_TAG, "close " + result);
                }

                analytics.userOptOut(result);
            }
        }
    }

    @Override
    public void onAdsError(String s) {
            Log.d(LOG_TAG, "onAdsError " + s);
    }

    @Override
    public void onPauseContentRequested() {

    }

    @Override
    public void onResumeContentRequested() {
        Log.d(LOG_TAG, "onResumeContentRequested");
    }

    @Override
    public void onListenerRegistered() {
        Log.d(LOG_TAG, "onListenerRegistered");
    }

    @Override
    public void onAdsInitialized() {
        Log.d(LOG_TAG, "onAdsInitialized");
    }

    @Override
    public void onAdRequest() {
        Log.d(LOG_TAG, "onAdRequest");
    }

    @Override
    public void onAdsLoaded(AdsCount adsCount) {
        Log.d(LOG_TAG, "onAdsLoaded " + adsCount);
    }

    @Override
    public void onAdsStarted(AdsInfo ads) {
        Log.i(LOG_TAG, "onAdsStarted");
    }

    private void testDar(AmpNielsenDcrAnalyticsTracker nielsen) {
        //String dcrTag = getTagWithTimestamp();
        String dcrTag = DAR_TEST_TAG_FROM_DOCS;
        nielsen.loadDarTag(dcrTag);
        Log.d(LOG_TAG, "Nielsen DAR Test: " + dcrTag);
    }

    private String getTagWithTimestamp()
    {
        String result = DAR_TEST_TAG + getTimestamp();
        return result;
    }

    private String getTimestamp() {
        Date date = new Date();
        return DAR_TIMESTAMP_DATE_FORMAT.format(date);
    }

    @Override
    public void onAdsPaused() {
        Log.d(LOG_TAG, "onAdsPaused");
    }

    @Override
    public void onAdsResumed() {
        Log.d(LOG_TAG, "onAdsResumed");
    }

    @Override
    public void onAdBreakStarted() {
        Log.d(LOG_TAG, "onAdBreakStarted");
    }

    @Override
    public void onAdBreakEnded() {
        Log.d(LOG_TAG, "onAdBreakEnded");
    }

    @Override
    public void onAdsEnded() {
        Log.d(LOG_TAG, "onAdsEnded");
    }

    @Override
    public void onAllPostrollsEnded() {
        Log.d(LOG_TAG, "onAllPostrollsEnded");
    }

    @Override
    public void onAdsTrackProgress(int i) {
        Log.d(LOG_TAG, "onAdsTrackProgress " + i);
    }

    @Override
    public void onAdsPlayheadUpdate(int i) {
        Log.d(LOG_TAG, "onAdsPlayheadUpdate " + i);
    }

    @Override
    public void onAdEvent() {
        Log.d(LOG_TAG, "onAdEvent");
    }

    @Override
    public void onAdBufferingStarted() {
        Log.d(LOG_TAG, "onAdBufferingStarted");
    }

    @Override
    public void onAdBufferingEnded() {
        Log.d(LOG_TAG, "onAdBufferingEnded");
    }

    @Override
    public void onAdsTapped() {
        Log.d(LOG_TAG, "onAdsTapped");
    }

    @Override
    public void onAdSkipped() {
        Log.d(LOG_TAG, "onAdSkipped");
    }

}
