package com.akamai.ampdemo;

import com.akamai.amp.analytics.mux.MuxData;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.mux.stats.sdk.core.model.CustomerPlayerData;
import com.mux.stats.sdk.core.model.CustomerVideoData;
import com.mux.stats.sdk.core.model.CustomerViewData;

class MuxHelper {

    private static final String MUX_ENVIRONMENT_KEY = "YOUR_ENVIRONMENT_KEY";
    private static final String MUX_SESSION_ID = "yourSessionID12345";

    private static final String MUX_DATA_CDN = "AKAMAI";

    static MuxData createMuxData(Video video)
    {
        CustomerPlayerData customerPlayerData = new CustomerPlayerData();
        customerPlayerData.setEnvironmentKey(MUX_ENVIRONMENT_KEY);
        customerPlayerData.setPlayerName(AMPLibraryInfo.NAME);
        customerPlayerData.setPlayerVersion(AMPLibraryInfo.VERSION);

        CustomerVideoData customerVideoData = new CustomerVideoData();
        customerVideoData.setVideoSourceUrl(video.videoURL);
        customerVideoData.setVideoTitle(video.title);
        customerVideoData.setVideoContentType(video.type);
        customerVideoData.setVideoCdn(MUX_DATA_CDN);

        CustomerViewData customerViewData = new CustomerViewData();
        customerViewData.setViewSessionId(MUX_SESSION_ID);

        MuxData muxData = new MuxData(customerPlayerData, customerVideoData, customerViewData, true);
        return muxData;
    }

}
