package com.akamai.analytics.firebase;

import android.app.Activity;
import android.os.Bundle;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.analytics.firebase.AmpFirebaseAnalyticsTracker;
import com.akamai.amp.analytics.firebase.AmpFirebaseCustomParams;
import com.akamai.amp.analytics.firebase.AmpFirebaseEvent;
import com.akamai.amp.analytics.firebase.FireBase;
import com.akamai.amp.analytics.firebase.FirebaseTrackerData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;


public class MainActivity extends Activity {

    private VideoPlayerContainer playerContainer;
    private VideoPlayerView playerView;
    private ProgressBar progressBar;
    private AmpIMAManager ima;
    private AmpFirebaseAnalyticsTracker analytics;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        progressBar = findViewById(R.id.progressBar);
        playerContainer = findViewById(R.id.playerViewCtrl);
        playerContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onResourceReady(MediaResource mediaResource) {
                playerView.play(mediaResource);
            }

            @Override
            public void onVideoPlayerCreated() {
                playerView = playerContainer.getVideoPlayer();
                ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
                ima = IMA.create(MainActivity.this)
                        .withImaSdkSettings(settings)
                        .buildClientSideManager();
                ima.setVideoPlayerContainer(playerContainer);
                ima.setAdsUrl("https://pubads.g.doubleclick.net/gampad/ads?iu=/21775744923/external/single_ad_samples&sz=640x480&cust_params=sample_ct%3Dlinear&ciu_szs=300x250%2C728x90&gdfp_req=1&output=vast&unviewed_position_start=1&env=vp&impl=s&correlator=");
                ima.setVideoPlayerView(playerView);

                playerView.setProgressBarControl(progressBar);
                playerView.setLogEnabled(true);
                FirebaseTrackerData data = new FirebaseTrackerData();
                AmpFirebaseCustomParams ampFirebaseCustomParams = new AmpFirebaseCustomParams();

                data.setCustomParams(ampFirebaseCustomParams);

                data.setTrackEvents(AmpFirebaseEvent.PLAYBACK, AmpFirebaseEvent.ADS, AmpFirebaseEvent.CAPTIONS);
                analytics = FireBase.create(playerView, data);

                if (ima != null){
                    IAdsComponentListener adsComponentListener = analytics.getiAdsComponentListener();
                    ima.addEventsListener(adsComponentListener);
                }
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception) {
            }
        });
        playerContainer.setApiKey("demo");
        playerContainer.prepareResource("http://devimages.apple.com/iphone/samples/bipbop/bipbopall.m3u8");
    }

    @Override
    protected void onPause() {
        if (playerView != null) playerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        if (playerView != null) playerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        if (playerView != null) playerView.onDestroy();
        super.onDestroy();
    }

}
