package com.akamai.ampdemo;

import com.akamai.amp.config.data.streamsense.StreamsenseAppData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.comscore.streaming.ContentMetadata;
import com.comscore.streaming.ContentType;

import java.util.HashMap;
import java.util.Map;

class StreamsenseHelper {

    private static final String APP_NAME = AMPLibraryInfo.NAME + " Comscore Streamsense Sample";
    private static final String APP_VERSION = AMPLibraryInfo.VERSION;
    private static final String PUBLISHER_ID = "1234567";
    private static final String PUBLISHER_SECRET = "7b94840eb66b17e61c3d2f909c3a1163";

    public static StreamsenseData buildStreamsenseData(VideoPlayerView videoPlayerView) {
        StreamsenseData data = new StreamsenseData(videoPlayerView);
        data.setAppData(buildStreamsenseAppData());
        data.setPersistentLabels(buildPersistentLabels());
        return data;
    }

    public static StreamsenseAppData buildStreamsenseAppData() {
        StreamsenseAppData streamsenseAppData = new StreamsenseAppData();
        streamsenseAppData.setAppName(APP_NAME);
        streamsenseAppData.setAppVersion(APP_VERSION);
        streamsenseAppData.setPublisherId(PUBLISHER_ID);
        streamsenseAppData.setPublisherSecret(PUBLISHER_SECRET);

        return streamsenseAppData;
    }

    private static Map<String, String> buildPersistentLabels() {
        Map<String, String> labels = new HashMap<>();
        labels.put("sample", "persistentLabel");
        return labels;
    }

    private static Map<String, String> buildCustomLabels() {
        Map<String, String> labels = new HashMap<>();
        labels.put("customLabel", "customValue");
        return labels;
    }

    static ContentMetadata buildContentMetadata() {
        ContentMetadata cm = new ContentMetadata.Builder()
                .mediaType(ContentType.SHORT_FORM_ON_DEMAND)
                .uniqueId("13784")
                .length(1418000) // 23m58s in milliseconds
                .dictionaryClassificationC3("*null")
                .dictionaryClassificationC4("*null")
                .dictionaryClassificationC6("*null")
                .stationTitle("Hulu")
                .publisherName("ABC")
                .programTitle("Modern Family")
                .genreName("Comedy")
                .classifyAsCompleteEpisode(true)
                .customLabels(buildCustomLabels())
                //.classifyAsAudioStream(boolean)
                //.classifyAsCompleteEpisode(boolean)
                //.carryTvAdvertisementLoad(boolean)
                //.uniqueId(string)
                //.length(long)
                //.totalSegments(int)
                //.publisherName(string)
                //.programTitle(string)
                //.episodeTitle(string)
                //.episodeSeasonNumber(string)
                //.episodeNumber(string)
                //.genreName(string)
                //.genreId(string)
                //.dateOfProduction(int, int, int)
                //.timeOfProduction(int, int)
                //.dateOfDigitalAiring(int, int, int)
                //.timeOfDigitalAiring(int, int)
                //.dateOfTvAiring(int, int, int)
                //.timeOfTvAiring(int, int)
                //.stationTitle(string)
                //.stationCode(string)
                //.programId(string)
                //.episodeId(string)
                //.networkAffiliate(string)
                //.fee(int)
                //.clipUrl(string)
                //.playlistTitle(string)
                //.feedType(int)
                //.videoDimensions(int, int)
                //.dictionaryClassificationC3(string)
                //.dictionaryClassificationC4(string)
                //.dictionaryClassificationC6(string)
                //.deliveryMode(int)
                //.deliverySubscriptionType(int)
                //.deliveryComposition(int)
                //.deliveryAdvertisementCapability(int)
                //.distributionModel(int)
                //.mediaFormat(int)
                .build();
        return cm;
    }

}
