package com.akamai.ampdemo;


import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;

import com.akamai.amp.analytics.comscorestreamsense.ComscoreStreamsense;
import com.akamai.amp.analytics.comscorestreamsense.UserConsent;
import com.akamai.amp.config.data.streamsense.StreamsenseAppData;

public class StreamsenseApplication extends Application {

    public static final String PREFERENCES_NAME = StreamsenseApplication.class.getName() + ".PREFERENCE_FILE_KEY";
    public static String USER_CONSENT_KEY;

    @Override
    public void onCreate() {
        super.onCreate();

        // Notice that Comscore mandates to send the first beacon on the Application's onCreate()
        // Your app should implement some sort of mechanism to check if the User Consent
        // was already given or denied, on a previous run of the app.
        StreamsenseAppData streamsenseAppData = StreamsenseHelper.buildStreamsenseAppData();
        Boolean persistedUserConsent = findPersistedUserConsent();
        UserConsent userConsent = convert(persistedUserConsent);
        ComscoreStreamsense.onApplicationCreate(streamsenseAppData, this, userConsent);
    }

    private Boolean findPersistedUserConsent() {
        USER_CONSENT_KEY = getApplicationContext().getPackageName() + ".USER_CONSENT";
        SharedPreferences sharedPreferences = getSharedPreferences(PREFERENCES_NAME, Context.MODE_PRIVATE);
        boolean alreadyPersisted = sharedPreferences.contains(USER_CONSENT_KEY);
        if (alreadyPersisted)
        {
            boolean userConsent = sharedPreferences.getBoolean(USER_CONSENT_KEY, false);
            return userConsent;
        }
        else
        {
            return null;
        }
    }

    private UserConsent convert(Boolean persistedUserConsent) {
        if (persistedUserConsent == null) return UserConsent.NO_ACTION;
        if (persistedUserConsent) return UserConsent.CONSENT;
        return UserConsent.NO_CONSENT;
    }

}
