package com.akamai.heartbeatsample;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.analytics.adobeheartbeat.AdobeHeartbeat;
import com.akamai.amp.analytics.adobeheartbeat.AmpAdobeHeartbeatAnalyticsTracker;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.config.data.heartbeat.HeartbeatData;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.akamai.amp.utils.LogManager;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;


public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private static final String LOG_TAG = "AMP + Adobe Heartbeat";
    private static final String VIDEO_URL_VOD = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";
    //private static final String VIDEO_URL_LIVE = "http://multiformatlive-f.akamaihd.net/i/demostream_1@2131/master.m3u8";
    private static final java.util.TimeZone TIME_ZONE = TimeZone.getTimeZone("America/New_York");

    private static final String HEARTBEAT_TRACKING_SERVER = "https://obumobile1.hb.omtrdc.net";
    private static final String HEARTBEAT_PUBLISHER       = "TEST";
    private static final String HEARTBEAT_CHANNEL         = "test-channel";
    private static final String HEARTBEAT_OVP             = "test-ovp";
    private static final String AUDIENCE_MANAGER_DPID     = "67312378756723456";
    private static final String AUDIENCE_MANAGER_DPUUID   = "550e8400-e29b-41d4-a716-446655440000";
    private static final String ADOBE_USER_ID             = "test-vid";

    private static final String SAMPLE_MEDIA_ID = "TestID123";
    private static final String SAMPLE_MEDIA_FRIENDLY_NAME = "TestContentTitle";



    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar progressBar;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private AmpAdobeHeartbeatAnalyticsTracker analytics;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        progressBar = findViewById(R.id.progressBar);
        mPlayerControlsOverlay = (PlayerControlsOverlay) findViewById(R.id.playerControls);
        setInlineUI();
        videoPlayerContainer = findViewById(R.id.playerViewCtrl);
        videoPlayerContainer.addVideoPlayerContainerCallback(this);
        videoPlayerContainer.setApiKey("demo");
        videoPlayerContainer.prepareResource(VIDEO_URL_VOD);
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setProgressBarControl(progressBar);
        videoPlayerView.setFullScreen(true);
        videoPlayerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO);
        videoPlayerView.setLogEnabled(true);

        mPlayerControlsOverlay.setVideoPlayerContainer(videoPlayerContainer);

        analytics = AdobeHeartbeat.create(videoPlayerView, buildHeartbeatData());
        AdobeHeartbeat.setTimeZone(TIME_ZONE);
        LogManager.log(LOG_TAG, "Using AMP version " + AMPLibraryInfo.VERSION + " with the 3rd party Adobe Heartbeat version " + analytics.getExternalLibVersion());

        videoPlayerView.play(mediaResource);
    }

    private HeartbeatData buildHeartbeatData() {
        HeartbeatData data = new HeartbeatData(buildHeartbeatConfigurationData());
        data.setStandardVideoMetadata(getStandardVideoMetadata());
        return data;
    }

    private HeartbeatConfigurationData buildHeartbeatConfigurationData() {
        HeartbeatConfigurationData data = new HeartbeatConfigurationData();
        data.setTrackingServer(HEARTBEAT_TRACKING_SERVER);
        data.setPublisher(HEARTBEAT_PUBLISHER);
        data.setChannel(HEARTBEAT_CHANNEL);
        data.setOvp(HEARTBEAT_OVP);
        data.setAudienceManagerDpid(AUDIENCE_MANAGER_DPID);
        data.setAudienceManagerDpuuid(AUDIENCE_MANAGER_DPUUID);
        data.setAdobeUserId(ADOBE_USER_ID);
        return data;
    }

    private Map<String, String> getStandardVideoMetadata() {
        Map<String, String> values = new HashMap<>();
        values.put(AdobeHeartbeat.KEY_MEDIA_ID, SAMPLE_MEDIA_ID);
        values.put(AdobeHeartbeat.KEY_MEDIA_FRIENDLY_NAME, SAMPLE_MEDIA_FRIENDLY_NAME);
        values.put("testKey", "testValue");
        return values;
    }

    @Override
    public void onVideoPlayerCreated() {
        LogManager.log(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        LogManager.error(LOG_TAG, "onResourceError() " + exception);
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }


    //It's mandatory to let the SDK know when the app goes and comes to the background

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (videoPlayerView != null) videoPlayerView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (videoPlayerView != null) videoPlayerView.onResume();
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) videoPlayerView.onDestroy();
        super.onDestroy();
    }

}
