package com.akamai.ampdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;


public class MasterActivity extends Activity
{
	public static boolean isPlaying = false;
	public static boolean subViewActive = false;
	public static boolean mainViewInFore = false;
	public static boolean appInBackground = false;
	private PlayerActivity mActivity;

	private static String currentActivityName = "";
	private static String mainActivityName = "";
	private static String TAG = "masterActivity";

	@Override
	public void onResume()
	{
		super.onResume();
		mActivity = new PlayerActivity();

		Intent i = getIntent();
		String activityName = i.getComponent().toString();
		String logMsg;

		currentActivityName = activityName;
		appInBackground = false;

		if (mainActivityName.equals(""))
		{
			mainActivityName = activityName;
			mainViewInFore = true;
			logMsg = "Launched";
		}
		else if (activityName.equals(mainActivityName))
		{
			mainViewInFore = true;

			if (mActivity != null)
			{
				//mActivity.initAnalyticsTracker();
			}
			logMsg = "MainActivity on Foreground";
		}
		else
		{
			logMsg = "Reinstated an Activity";
		}

		Log.i(TAG, "onResume Application: " + logMsg + " activityName=" + activityName);
	}

	@Override
	public void onPause()
	{
		super.onPause();

		Intent i = getIntent();
		final String activityName = i.getComponent().toString();
		String logMsg;

		mainViewInFore = false;

		if (activityName.equals(currentActivityName))
		{
			logMsg = "Suspend or not?";
			new Handler().postDelayed(new Runnable()
			{
				@Override
				public void run()
				{
					if (activityName.equals(currentActivityName))
					{
						appInBackground = true;
					}
					else
					{
						appInBackground = false;
					}
				}
			}, 350);

		}
		else
		{
			logMsg = "Launching another view";
		}

		Log.i(TAG, "onPause Application: " + logMsg + " activityName=" + activityName);
	}

	@Override
	public void onStop()
	{
		super.onStop();

		Intent i = getIntent();
		final String activityName = i.getComponent().toString();

		Log.i(TAG, "onStop Application:  activityName=" + activityName);
	}

	@Override
	public void onDestroy()
	{
		super.onDestroy();

		Log.i(TAG, "onDestroy Application: currentActivityName=" + currentActivityName);
	}
}
