package com.akamai.ampyospacesample;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.yospace.AmpYospaceManager;
import com.akamai.amp.ads.yospace.Yospace;
import com.akamai.amp.ads.yospace.YospaceAdsInfo;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.AMPLibraryInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private static final String TAG = "AMP-UI-Sample";
    private static final String MEDIA_ASSET_URL = "http://csm-e.cds1.yospace.com/csm/extlive/yospace02,sampledroid.m3u8?yo.br=false&yo.ac=true";
    private VideoPlayerContainer mVideoPlayerContainer;
    private VideoPlayerView mVideoPlayerView;
    private ProgressBar mProgressBar;

    private boolean mFullScreenMode;
    private AmpYospaceManager ampYospaceManager;
    private PlayerControlsOverlay mPlayerControlsOverlay;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setContentView(R.layout.activity_main);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.POST_NOTIFICATIONS)
                    != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this,
                        new String[]{Manifest.permission.POST_NOTIFICATIONS}, 1001);
            }
        }

        mPlayerControlsOverlay = findViewById(R.id.playerControls);
        setInlineUI();

        if (savedInstanceState != null) {
            mFullScreenMode = savedInstanceState.getBoolean("FULLSCREEN");
         } else {
            mFullScreenMode = false;
        }

        mProgressBar = findViewById(R.id.progressBar);
        mVideoPlayerContainer = findViewById(R.id.playerViewCtrl);
        mVideoPlayerContainer.addVideoPlayerContainerCallback(this);
        mVideoPlayerContainer.setApiKey("demo");


        ampYospaceManager = Yospace.create(this,MEDIA_ASSET_URL);
        ampYospaceManager.setVideoPlayerContainer(mVideoPlayerContainer);
        ampYospaceManager.addEventsListener(adEventsListener);
        mVideoPlayerContainer.enableAutoRecovery(ampYospaceManager.getConnectionSwitchCallback());
        ampYospaceManager.doProxyInit();
    }

    private IAdsComponentListener<YospaceAdsInfo> adEventsListener = new IAdsComponentListener<YospaceAdsInfo>() {
        @Override public void onListenerRegistered() {}
        @Override public void onAdsInitialized() {}
        @Override public void onAdRequest() {}
        @Override public void onAdsLoaded(AdsCount adsCount) {}
        @Override public void onAdsStarted(YospaceAdsInfo adsInfo) {}
        @Override public void onAdsEnded() {}
        @Override public void onAllPostrollsEnded() {}
        @Override public void onAdsPaused() {}
        @Override public void onAdsResumed() {}
        @Override public void onAdBreakStarted() {}
        @Override public void onAdBreakEnded() {}
        @Override public void onAdsTrackProgress(int i) {}
        @Override public void onAdsPlayheadUpdate(int i) {}
        @Override public void onAdsError(String s) {}
        @Override public void onPauseContentRequested() {}
        @Override public void onResumeContentRequested() {}
        @Override public void onAdsTapped() {}
        @Override public void onAdEvent() {}
        @Override public void onAdBufferingStarted() {}
        @Override public void onAdBufferingEnded() {}
        @Override public void onAdSkipped() {}
    };


    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        mVideoPlayerView = mVideoPlayerContainer.getVideoPlayer();
        mPlayerControlsOverlay.setVideoPlayerContainer(mVideoPlayerContainer);
        mVideoPlayerView.setLogEnabled(true);
        ampYospaceManager.setVideoPlayerView(mVideoPlayerView);

        mVideoPlayerView.enableDVRfeatures(false);

        mVideoPlayerView.setProgressBarControl(mProgressBar);
        mVideoPlayerView.play(mediaResource);

        Log.i(TAG, "AMP v" + AMPLibraryInfo.VERSION);
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(TAG, "onResourceError()");
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.mipmap.play,
                R.mipmap.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(mVideoPlayerView != null) {
            mVideoPlayerView.onResume();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if(mVideoPlayerView != null)
            mVideoPlayerView.onPause();
    }

    @Override
    protected void onDestroy() {
        if (mVideoPlayerView != null) {
            mVideoPlayerView.onDestroy();
            ampYospaceManager.onStop();
        }
        super.onDestroy();
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putBoolean("FULLSCREEN", mFullScreenMode);
        // Always call the superclass so it can save the view hierarchy state
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        return false;
    }

}