package com.akamai.androidmdt.androidsdkdemo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.InputType;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsHelper;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.ima.AmpDAIManager;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.GoogleAdsInfo;
import com.akamai.amp.ads.ima.IMA;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.uimobile.generic.media.PlayerControlsOverlay;
import com.akamai.amp.utils.LogManager;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.BaseManager;
import com.google.ads.interactivemedia.v3.api.FriendlyObstruction;
import com.google.ads.interactivemedia.v3.api.FriendlyObstructionPurpose;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;

import java.util.HashMap;
import java.util.Map;


public class MainActivity extends AppCompatActivity
        implements IAdsComponentListener<GoogleAdsInfo>,
        VideoPlayerContainer.VideoPlayerContainerCallback, LogManager.Logs {


    private static final String TAG = MainActivity.class.getName();

    private String ADS_URL =
            //"https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/single_ad_samples&ciu_szs=300x250&impl=s&gdfp_req=1&env=vp&output=vast&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ct%3Dredirecterror&correlator=";
            "https://pubads.g.doubleclick.net/gampad/ads?iu=/21775744923/external/single_ad_samples&sz=640x480&cust_params=sample_ct%3Dlinear&ciu_szs=300x250%2C728x90&gdfp_req=1&output=vast&unviewed_position_start=1&env=vp&impl=s&correlator=\n";
    private VideoPlayerContainer mVideoContainer;
    private VideoPlayerView mVideoView;
    private AmpIMAManager csaiManager;
    private AmpDAIManager daiManager;
    private PlayerControlsOverlay mPlayerControlsOverlay;

    private ScrollView scrollView;
    private TextView logger;
    private TextView lastEventLog;
    private MediaResource mediaResource;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mPlayerControlsOverlay = findViewById(R.id.playerControls);
        setInlineUI();

        //mPlayerControlsOverlay.setControlsVisibility(View.VISIBLE);

        mVideoContainer = findViewById(R.id.playerViewCtrl);
        logger = findViewById(R.id.logger);
        lastEventLog = findViewById(R.id.last_event_log);
        scrollView = findViewById(R.id.scrollView);
        mVideoContainer.addVideoPlayerContainerCallback(this);
        mVideoContainer.setApiKey("demo");
    }

    @Override
    public void log(String logEntry) {
        // this condition is to avoid Ad progress log pollution in the sample under test
        if (!logEntry.contains("Ad progress") ){
            lastEventLog.setText(logEntry);
        }

        String logAppend = logger.getText().toString();
        if ("".equals(logger.getText().toString())) {
            logAppend = logEntry;
        } else {
            logAppend += "\n" + logEntry;
        }

        if (scrollView != null) {
            scrollView.post(new Runnable() {
                @Override
                public void run() {
                    scrollView.fullScroll(View.FOCUS_DOWN);
                }
            });
        }
    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(TAG, "onVideoPlayerCreated");
    }

    @Override
    public void onResourceReady(MediaResource resource) {
        Log.i(TAG, "onResourceReady " + resource.getRedirectedUrl());
        mediaResource = resource;
        configVideoView();
        if (csaiManager != null)
            csaiManager.setVideoPlayerView(mVideoView);
        if (daiManager != null)
            daiManager.setVideoPlayerView(mVideoView);
        mVideoView.play(mediaResource);
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(TAG, "onResourceError");
    }

    private void configVideoView() {
        mVideoView = mVideoContainer.getVideoPlayer();
        mPlayerControlsOverlay.setVideoPlayerContainer(mVideoContainer);
        mVideoView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO);
        mVideoView.setKeepScreenOn(true);
        mVideoView.enableDVRfeatures(true);
        mVideoView.useContentTimeline(true);


        if (csaiManager != null) {
            csaiManager.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());
            mVideoView.setTimelineListener(csaiManager);
        }
        if (daiManager != null) {
            daiManager.addEventsListener(mPlayerControlsOverlay.getAdsComponentListener());
            mVideoView.setTimelineListener(daiManager);
        }
    }

    @Override
    public void onPause() {
        pausePlayer();
        super.onPause();
    }

    private void pausePlayer() {
        if (csaiManager != null)
            csaiManager.onPause();
        if (daiManager != null)
            daiManager.onPause();

    }

    @Override
    public void onResume() {
        resumePlayer();
        super.onResume();
    }

    private void resumePlayer() {
        if (csaiManager != null)
            csaiManager.onResume(true);
        if (daiManager != null)
            daiManager.onResume(true);
    }

    @Override
    public void onDestroy() {
        destroyPlayer();
        mVideoView = null;
        super.onDestroy();
    }

    private void destroyPlayer() {
        if (mVideoView != null) mVideoView.onDestroy();
        mPlayerControlsOverlay.removeVideoPlayerViewReference();
        csaiManager = null;
        daiManager = null;
    }

    /*ADS RELATED AMP EVENTS*/

    @Override
    public void onListenerRegistered() {

    }

    @Override
    public void onAdsError(String s) {
        Log.e(TAG, "onAdsError " + s);
    }

    @Override
    public void onPauseContentRequested() {
        Log.i(TAG, "onPauseContentRequested");
    }

    @Override
    public void onResumeContentRequested() {
        Log.i(TAG, "onResumeContentRequested");
    }

    @Override
    public void onAdsTapped() {
        Log.i(TAG, "onAdsTapped");
    }

    @Override
    public void onAdsInitialized() {
        Log.i(TAG, "onAdsInitialized");

        BaseManager adsManager = getBaseManager();
        if (adsManager == null) return;

        adsManager.addAdEventListener(adEvent -> Log.i("IMA-Events-Test", adEvent.toString()));
    }

    @Override
    public void onAdRequest() {
        Log.i(TAG, "onAdRequest");
    }

    private BaseManager getBaseManager() {
        BaseManager adsManager = null;
        if (csaiManager != null) {
            adsManager = csaiManager.getManager();
        } else if (daiManager != null) {
            adsManager = daiManager.getManager();
        }
        return adsManager;
    }

    @Override
    public void onAdsLoaded(AdsCount adsCount) {
        Log.i(TAG, "onAdsLoaded " + adsCount);
    }

    @Override
    public void onAdsStarted(GoogleAdsInfo adsInfo) {
        Log.i(TAG, "onAdsStarted " + adsInfo);
    }

    @Override
    public void onAdsPaused() {
        Log.i(TAG, "onAdsPaused");
    }

    @Override
    public void onAdsResumed() {
        Log.i(TAG, "onAdsResumed");
    }

    @Override
    public void onAdBreakStarted() {
        Log.i(TAG, "onAdBreakStarted");
    }

    @Override
    public void onAdBreakEnded() {
        Log.i(TAG, "onAdBreakEnded");
    }

    @Override
    public void onAdsEnded() {
        Log.i(TAG, "onAdsEnded");
    }

    @Override
    public void onAdEvent() {
        Log.i(TAG, "onAdsEvent");
    }

    @Override
    public void onAdBufferingStarted() {
        Log.i(TAG, "onAdBufferingStarted");
    }

    @Override
    public void onAdBufferingEnded() {
        Log.i(TAG, "onAdBufferingEnded");
    }

    @Override
    public void onAllPostrollsEnded() {
        Log.i(TAG, "onAllPostrollsEnded");
    }

    @Override
    public void onAdsTrackProgress(int i) {
        Log.i(TAG, "onAdsTrackProgress " + AdsHelper.translateProgressCode(i) + "%");
    }

    @Override
    public void onAdSkipped(){
        Log.i(TAG, "onAdSkipped");
    }

    @Override
    public void onAdsPlayheadUpdate(int i) {
        Log.i(TAG, "onAdsPlayheadUpdate " + i);
    }


    /**
     * ACTION BAR MENU OPTIONS
     */
    @SuppressLint("NonConstantResourceId")
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.play_DAI_VOD) {
            pausePlayer();
            setupDAI();
            setInlineUI();
            log("AMP/IMA: Loading SERVER SIDE VOD ... ");
            daiManager.setAdTagParameters(getDaiParams());
            //daiManager.enableAdsUI();
            //daiManager.disableAdsUI();
            daiManager.playWithServerAds("19463", "tears-of-steel");
            return true;
        } else if (id == R.id.play_DAI_live) {
            pausePlayer();
            setupDAI();
            setInlineUI();
            log("AMP/IMA: Loading SERVER SIDE LIVE ... ");
            //daiManager.enableAdsUI();
            //daiManager.disableAdsUI();
            daiManager.playWithServerAds("sN_IYUG8STe1ZzhIIE_ksA");

            return true;
        } else if (id == R.id.play_CLIENT_VOD) {
            pausePlayer();
            setupCSAI();
            setInlineUI();
            log("AMP/IMA: Loading CLIENT SIDE VOD ... ");
            csaiManager.setAdsUrl(ADS_URL);
            //csaiManager.disableAdsUI();
            //csaiManager.enableAdsUI();
            mVideoContainer.prepareResource(getString(R.string.stream_url));

            AdDisplayContainer adDisplayContainer = csaiManager.getAdDisplayContainer();
                /*Important: The following line invokes a method that demonstrates the correct way to register
                friendly obstructions. It is used to fix issues with Ad impressions and analytics mostly,
                but you can ignore it unless you have custom views to display on top of the Ads like buttons or logos.

                This is NOT mandatory to play Ads, is it optional, include it only when the scenario above concerns you.
                 */
            registerFriendlyObstructions(adDisplayContainer);
            return true;
        } else if (id == R.id.play_CLIENT_VOD_Custom) {
            getIMAInputData();
            return true;
        } else if (id == R.id.play_DAI_live_Custom) {
            getDAILiveInputData();
            return true;
        } else if (id == R.id.play_DAI_VOD_Custom) {
            getDAIVODInputData();
            return true;
        } else {
            return super.onOptionsItemSelected(item);
        }
    }

    private void getIMAInputData(){
        final EditText txtUrl = new EditText(this);

        // Set the default text to a link of the Queen
        txtUrl.setHint("https://developers.google.com/interactive-media-ads/docs/sdks/html5/client-side/tags");

        // Create a ViewGroup to enter multiple text input data.
        Context context =  mVideoContainer.getContext();
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(LinearLayout.VERTICAL);

        // Add a TextView here for the "Title" label, as noted in the comments
        final EditText adTagUrlCustom = new EditText(context);
        adTagUrlCustom.setHint("Ad Tag URL");
        adTagUrlCustom.setEllipsize(TextUtils.TruncateAt.START);
        adTagUrlCustom.setInputType(InputType.TYPE_TEXT_VARIATION_URI);
        layout.addView(adTagUrlCustom); // Notice this is an add method

        // Add another TextView here for the "vastTimeout" parameter
        final EditText vastTimeoutValue = new EditText(context);
        vastTimeoutValue.setHint("Vast Timeout Value");
        layout.addView(vastTimeoutValue); // Another add method

        // Add another TextView here for the "loadVideoTimeout" parameter
        final EditText loadVideoTimeoutValue = new EditText(context);
        loadVideoTimeoutValue.setHint("Load Video Timeout Value");
        layout.addView(loadVideoTimeoutValue); // Another add method

        // Add another TextView here for the "ppid" parameter
        final EditText ppidValue = new EditText(context);
        ppidValue.setHint("PPID IMA Value");
        layout.addView(ppidValue); // Another add method

        //dialog.setView(layout); // Again this is a set method, not add

        new AlertDialog.Builder(this)
                .setTitle("CASI Ad Tag URL")
                .setMessage("Paste in the link of an escaped Ad URL ('&' must be escaped as '/&')")
                .setView(layout)

                // unique text input data
                //.setView(txtUrl)
                .setPositiveButton("Accept", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (adTagUrlCustom != null) {
                            String adTagUrlCustomStr = adTagUrlCustom.getText().toString();
                            if (!adTagUrlCustomStr.isEmpty()) {
                                Log.d(TAG, "play_CLIENT_VOD_Custom: " + adTagUrlCustomStr);
                                pausePlayer();
                                int vastTimeoutValueInt;
                                int loadVideoTimeoutValueInt;
                                if (!vastTimeoutValue.getText().toString().isEmpty()){
                                    vastTimeoutValueInt = Integer.parseInt(vastTimeoutValue.getText().toString());
                                } else {
                                    vastTimeoutValueInt = 0;
                                }
                                if (!loadVideoTimeoutValue.getText().toString().isEmpty()){
                                    loadVideoTimeoutValueInt = Integer.parseInt(loadVideoTimeoutValue.getText().toString());
                                } else {
                                    loadVideoTimeoutValueInt = 0;
                                }
                                String ppidStr = ppidValue.getText().toString();
                                setupCSAICustom(vastTimeoutValueInt, loadVideoTimeoutValueInt, ppidStr);
                                setInlineUI();
                                log("AMP/IMA: Loading CLIENT SIDE VOD ... ");
                                csaiManager.setAdsUrl(adTagUrlCustomStr);
                                mVideoContainer.prepareResource(getString(R.string.stream_url));

                                AdDisplayContainer adDisplayContainer = csaiManager.getAdDisplayContainer();
                                registerFriendlyObstructions(adDisplayContainer);
                            }
                        }
                    }
                })
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    }
                })
                .show();
    }

    private void getDAILiveInputData(){
        final EditText txtUrl = new EditText(this);

        // Set the default text to a link of the Queen
        txtUrl.setHint("https://developers.google.com/interactive-media-ads/docs/sdks/html5/dai/streams");

        // Create a ViewGroup to enter multiple text input data.
        Context context =  mVideoContainer.getContext();
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(LinearLayout.VERTICAL);

        // Add a TextView here for the "Title" label, as noted in the comments
        final EditText assetKey = new EditText(context);
        assetKey.setHint("DAI Live Asset Key");
        layout.addView(assetKey); // Notice this is an add method

        // ToDo Add another TextView here for the "ads MimeType" parameter

        // Add another TextView here for the "ppid" parameter
        final EditText ppidValue = new EditText(context);
        ppidValue.setHint("PPID DAI Value");
        layout.addView(ppidValue); // Another add method

        //dialog.setView(layout); // Again this is a set method, not add

        new AlertDialog.Builder(this)
                .setTitle("SSAI DAI Live Asset Key")
                .setMessage("Paste in the link of a DAI live asset Key")
                .setView(layout)

                // unique text input data
                //.setView(txtUrl)
                .setPositiveButton("Accept", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (assetKey != null) {
                            String assetKeyStr = assetKey.getText().toString();
                            if (!assetKeyStr.isEmpty()) {
                                Log.d(TAG, "play_DAI_live_Custom: " + assetKeyStr);
                                pausePlayer();

                                String ppidStr = ppidValue.getText().toString();

                                setupDAICustom(ppidStr);

                                setInlineUI();

                                log("AMP/IMA: Loading SERVER SIDE LIVE ... ");
                                //daiManager.enableAdsUI();
                                //daiManager.disableAdsUI();

                                daiManager.playWithServerAds(assetKeyStr);


                            }
                        }
                    }
                })
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    }
                })
                .show();
    }

    private void getDAIVODInputData(){
        final EditText txtUrl = new EditText(this);

        // Set the default text to a link of the Queen
        txtUrl.setHint("https://developers.google.com/interactive-media-ads/docs/sdks/html5/dai/streams");

        // Create a ViewGroup to enter multiple text input data.
        Context context =  mVideoContainer.getContext();
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(LinearLayout.VERTICAL);

        // Add a TextView here for the "Title" label, as noted in the comments
        final EditText cmsKey = new EditText(context);
        cmsKey.setHint("DAI VOD CMS Key");
        layout.addView(cmsKey); // Notice this is an add method

        // Add a TextView here for the "Title" label, as noted in the comments
        final EditText videoId = new EditText(context);
        videoId.setHint("DAI VOD Video ID");
        layout.addView(videoId); // Notice this is an add method

        // ToDo Add another TextView here for the "ads MimeType" parameter

        // Add another TextView here for the "ppid" parameter
        final EditText ppidValue = new EditText(context);
        ppidValue.setHint("PPID DAI Value");
        layout.addView(ppidValue); // Another add method

        //dialog.setView(layout); // Again this is a set method, not add

        new AlertDialog.Builder(this)
                .setTitle("SSAI DAI VOD CMS Key and Video ID")
                .setMessage("Paste in the link of a DAI vod cms key and video id")
                .setView(layout)

                // unique text input data
                //.setView(txtUrl)
                .setPositiveButton("Accept", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (cmsKey != null && videoId != null) {
                            String cmsKeyStr = cmsKey.getText().toString();
                            String videoIdStr = videoId.getText().toString();

                            if (!cmsKeyStr.isEmpty() && !videoIdStr.isEmpty()) {
                                Log.d(TAG, "play_DAI_VOD_Custom cmsKeyStr: " + cmsKeyStr);
                                Log.d(TAG, "play_DAI_VOD_Custom videoIdStr: " + videoIdStr);

                                pausePlayer();

                                String ppidStr = ppidValue.getText().toString();

                                setupDAICustom(ppidStr);

                                setInlineUI();

                                log("AMP/IMA: Loading SERVER SIDE VOD ... ");
                                //daiManager.enableAdsUI();
                                //daiManager.disableAdsUI();

                                daiManager.playWithServerAds(cmsKeyStr, videoIdStr);


                            }
                        }
                    }
                })
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    }
                })
                .show();
    }

    private Map<String, String> getDaiParams() {
        Map<String, String> imaParameters = new HashMap<>();
        //imaParameters.put("cust_params", "loc=homescreen"); //Providing this param, there will be no ads sent
        return imaParameters;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_main, menu);
        return true;
    }

    private void setInlineUI() {
        mPlayerControlsOverlay.overrideControlsLayout(R.layout.overlay_controls);
        mPlayerControlsOverlay.setShowControlsAtStart(false);
        setupInlinePlayerControls();
    }

    private void setupInlinePlayerControls() {
        mPlayerControlsOverlay.managePlayPause(R.id.androidsdk_playPauseCtrl,
                R.drawable.play,
                R.drawable.pause);
        mPlayerControlsOverlay.manageCurrentPosition(R.id.androidsdk_seekbarTextCtrl);
        mPlayerControlsOverlay.manageTimeRemaining(R.id.video_duration);
        mPlayerControlsOverlay.manageScrubbing(R.id.androidsdk_seekbarCtrl,
                R.id.androidsdk_seekToLiveAction);
    }

    private void setupCSAI() {
        destroyPlayer();
        ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
        csaiManager = IMA.create(this)
                .withImaSdkSettings(settings)
                .buildClientSideManager();
        //csaiManager.setVastTimeout(8000);
        csaiManager.setLog(this);
        csaiManager.setLoadVideoTimeout(20000);
        csaiManager.setVideoPlayerContainer(mVideoContainer);
        csaiManager.addEventsListener(this);
    }

    private void setupCSAICustom(int vastTimeout, int loadVideoTimeout, String ppid) {
        destroyPlayer();
        ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
        if (!ppid.isEmpty()){
            settings.setPpid(ppid);
        }
        csaiManager = IMA.create(this)
                .withImaSdkSettings(settings)
                .buildClientSideManager();
        if(vastTimeout > 0){
            csaiManager.setVastTimeout(vastTimeout);
        }
        csaiManager.setLog(this);
        if (loadVideoTimeout > 0){
            csaiManager.setLoadVideoTimeout(loadVideoTimeout);
        }
        csaiManager.setVideoPlayerContainer(mVideoContainer);
        csaiManager.addEventsListener(this);
    }

    private void setupDAI() {
        destroyPlayer();
        ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
        daiManager = IMA.create(this)
                .withImaSdkSettings(settings)
                .buildServerSideManager();
        daiManager.setLog(this);
        daiManager.setVideoPlayerContainer(mVideoContainer);
        daiManager.addEventsListener(this);

    }

    private void setupDAICustom(String ppid) {
        destroyPlayer();
        ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
        settings.setPpid(ppid);

        daiManager = IMA.create(this)
                .withImaSdkSettings(settings)
                .buildServerSideManager();
        daiManager.setLog(this);
        daiManager.setVideoPlayerContainer(mVideoContainer);
        daiManager.addEventsListener(this);

    }

    // See https://developers.google.com/interactive-media-ads/docs/sdks/android/client-side/omsdk
    // The addition of this code could lead to further issues: https://groups.google.com/g/ima-sdk/c/-0Sq2-n-_VA
    // Make sure that the messages used are less than 50 alphanumeric-only characters
    private void registerFriendlyObstructions(AdDisplayContainer adDisplayContainer) {
        if (adDisplayContainer == null) return;

        ImaSdkFactory sdkFactory = ImaSdkFactory.getInstance();
        FriendlyObstruction overlayObstruction = sdkFactory.createFriendlyObstruction(
                logger,
                FriendlyObstructionPurpose.NOT_VISIBLE,
                "This overlay is transparent"
        );
        FriendlyObstruction pauseButtonObstruction = sdkFactory.createFriendlyObstruction(
                mPlayerControlsOverlay,
                FriendlyObstructionPurpose.VIDEO_CONTROLS,
                "This is the video player controls"
        );

        adDisplayContainer.registerFriendlyObstruction(overlayObstruction);
        adDisplayContainer.registerFriendlyObstruction(pauseButtonObstruction);
    }

}
