/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.simple;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Logger;
import com.adobe.primetime.va.simple.IPredicate;
import com.adobe.primetime.va.simple.Predicate;
import com.adobe.primetime.va.simple.Rule;
import com.adobe.primetime.va.simple.RuleEngineContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleEngine {
    String LOG_TAG = "MediaHeartbeat-RuleEngine";
    private List<Rule> _rules;
    private Logger _logger;
    private ICallback _enterAction;
    private ICallback _exitAction;

    public RuleEngine(Logger logger) {
        if (logger == null) {
            throw new Error("Reference to the logger cannot be NULL.");
        }
        this._logger = logger;
        this._rules = new ArrayList<Rule>();
    }

    public static RuleEngineContext createContext() {
        return new RuleEngineContext();
    }

    public static Predicate createPredicate(IPredicate fn, boolean expectedValue, String msg) {
        return new Predicate(fn, expectedValue, msg);
    }

    public void registerRule(int name, String desc, List<Predicate> preconditions, List<ICallback> actions) {
        this._rules.add(new Rule(name, desc, preconditions, actions));
    }

    public void registerEnterExitAction(ICallback _enterAction, ICallback _exitAction) {
        this._enterAction = _enterAction;
        this._exitAction = _exitAction;
    }

    private void _handleFailure(Rule rule, Predicate precondition) {
        this._logger.error(this.LOG_TAG, rule.desc + " -  " + precondition.msg);
    }

    private Rule _getRule(int name) {
        int len = this._rules.size();
        for (int i = 0; i < len; ++i) {
            if (this._rules.get((int)i).name != name) continue;
            return this._rules.get(i);
        }
        return null;
    }

    public boolean processRule(int ruleName, RuleEngineContext reContext) {
        boolean retValue = true;
        Rule rule = this._getRule(ruleName);
        if (rule != null) {
            int i;
            if (reContext == null) {
                reContext = new RuleEngineContext();
            }
            reContext.setRuleName(ruleName);
            boolean checkFailed = false;
            for (i = 0; i < rule.preconditions.size(); ++i) {
                Predicate precondition = rule.preconditions.get(i);
                IPredicate handler = precondition.fn;
                boolean ret = handler.call(reContext);
                boolean bl = checkFailed = ret != precondition.expectedValue;
                if (!checkFailed) continue;
                this._handleFailure(rule, precondition);
                break;
            }
            if (!checkFailed) {
                reContext.startProcessingAction();
                if (this._enterAction != null) {
                    this._enterAction.call(reContext);
                }
                for (i = 0; i < rule.actions.size(); ++i) {
                    ICallback action = rule.actions.get(i);
                    if (!reContext.shouldProcessAction()) {
                        this._logger.info(this.LOG_TAG, "Stopping actions for " + rule.desc);
                        break;
                    }
                    action.call(reContext);
                }
                if (this._exitAction != null && reContext.shouldProcessAction()) {
                    this._exitAction.call(reContext);
                }
            } else {
                retValue = false;
            }
        } else {
            this._logger.warn(this.LOG_TAG, "No registered event found for ruleName " + ruleName);
            retValue = false;
        }
        return retValue;
    }
}

