/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.service.clock;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.plugin.BasePlugin;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.va.service.clock.TimerManager;
import java.util.ArrayList;
import java.util.HashMap;

public class ClockService
extends BasePlugin {
    private static final String NAME = "service.clock";
    private static final String CMD_CREATE = "create";
    private static final String CMD_PAUSE = "pause";
    private static final String CMD_RESUME = "resume";
    private static final String CMD_DESTROY = "destroy";
    private static final String KEY_NAME = "name";
    private static final String KEY_INTERVAL = "interval";
    private static final String KEY_REPEAT_COUNT = "repeat_count";
    private static final String KEY_TICK = "tick";
    private static final String KEY_RESET = "reset";
    private static final String REQ_IS_PAUSED = "is_paused";
    private static final int REPEAT_FOREVER = -1;
    private TimerManager _timerManager;
    private ICallback _cmdCreate = new ICallback(){

        public Object call(Object data) {
            int repeatCount = ((HashMap)data).containsKey(ClockService.KEY_REPEAT_COUNT) ? (Integer)((HashMap)data).get(ClockService.KEY_REPEAT_COUNT) : -1;
            ClockService.this._timerManager.createTimer((String)((HashMap)data).get(ClockService.KEY_NAME), (Double)((HashMap)data).get(ClockService.KEY_INTERVAL), repeatCount);
            return null;
        }
    };
    private ICallback _cmdPause = new ICallback(){

        public Object call(Object data) {
            ClockService.this._timerManager.pauseTimer((String)((HashMap)data).get(ClockService.KEY_NAME), ((HashMap)data).get(ClockService.KEY_RESET) != null);
            return null;
        }
    };
    private ICallback _cmdResume = new ICallback(){

        public Object call(Object data) {
            ClockService.this._timerManager.resumeTimer((String)((HashMap)data).get(ClockService.KEY_NAME), ((HashMap)data).get(ClockService.KEY_RESET) != null);
            return null;
        }
    };
    private ICallback _cmdDestroy = new ICallback(){

        public Object call(Object data) {
            ClockService.this._timerManager.destroyTimer((String)((HashMap)data).get(ClockService.KEY_NAME));
            return null;
        }
    };

    public ClockService(ILogger logger) {
        super(NAME);
        if (logger == null) {
            throw new Error("Reference to the logger cannot be NULL.");
        }
        this._logger = logger;
        this._timerManager = new TimerManager(this, this._logger);
        this._setupDataResolver();
    }

    public void bootstrap(PluginManager pluginManager) {
        super.bootstrap(pluginManager);
        this._pluginManager.comply(this, CMD_CREATE, this._cmdCreate);
        this._pluginManager.comply(this, CMD_RESUME, this._cmdResume);
        this._pluginManager.comply(this, CMD_PAUSE, this._cmdPause);
        this._pluginManager.comply(this, CMD_DESTROY, this._cmdDestroy);
    }

    protected void _teardown() {
        this._timerManager.destroy();
    }

    void onTick(String name, double interval, int tick) {
        name = name + ".tick";
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put(KEY_NAME, name);
        eventData.put(KEY_INTERVAL, interval);
        eventData.put(KEY_TICK, tick);
        this._trigger(name, eventData);
    }

    private void _setupDataResolver() {
        final HashMap<String, 5> fnMap = new HashMap<String, 5>();
        fnMap.put(REQ_IS_PAUSED, new ICallback(){

            public Object call(Object key) {
                return ClockService.this._timerManager.isTimerPaused((String)key);
            }
        });
        this._dataResolver = new ICallback(){

            public Object call(Object param) {
                ArrayList keys = (ArrayList)param;
                if (keys == null || keys.size() <= 0) {
                    return null;
                }
                HashMap<String, Object> _result = null;
                for (String key : keys) {
                    String[] tokens;
                    if (_result == null) {
                        _result = new HashMap<String, Object>();
                    }
                    if (!key.startsWith(ClockService.REQ_IS_PAUSED) || (tokens = key.split("is_paused.")).length <= 0) continue;
                    _result.put(key, ((ICallback)fnMap.get(ClockService.REQ_IS_PAUSED)).call(tokens[1]));
                }
                return _result;
            }
        };
    }
}

