/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.filter;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.core.radio.Command;
import com.adobe.primetime.core.radio.CommandQueue;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFilter {
    private String _logTag;
    private ILogger _logger;
    private Channel _channel;
    private boolean _isDestroyed;
    private boolean _isBufferingInProgress;
    private CommandQueue _workQueue;
    private Map<String, ArrayList<Report>> _reportBuffer;
    private Map<String, HashMap<String, Long>> _tsHistory;
    private static final String EVENT_CONTEXT_REPORT_AVAILABLE = "context:report_available";
    private static final String EVENT_FILTER_REPORT_AVAILABLE = "filter:data_available";
    private static final String EVENT_CLOCK_FLUSH_FILTER_TICK = "clock:flush_filter.tick";
    private static final String KEY_RESET = "reset";
    private static final String KEY_REPORT = "report";
    private static final String KEY_REPEAT_COUNT = "repeat_count";
    private static final String CMD_ENABLE_FLUSH_FILTER_TIMER = "clock:flush_filter.resume";
    private static final long PLAY_EVENT_DURATION_THRESHOLD = 250L;
    private static final long PAUSE_EVENT_DURATION_THRESHOLD = 250L;
    private static final String REQ_SESSION_ID = "session_id";
    private ICallback _bufferReport = new ICallback(){

        public Object call(Object param) {
            HashMap data = (HashMap)param;
            if (ReportFilter.this._isDestroyed) {
                return null;
            }
            Report report = (Report)data.get(ReportFilter.KEY_REPORT);
            if (report != null) {
                String sessionId = report.getSessionData().getSessionId();
                if (!ReportFilter.this._reportBuffer.containsKey(sessionId)) {
                    ReportFilter.this._reportBuffer.put(sessionId, new ArrayList());
                }
                ((ArrayList)ReportFilter.this._reportBuffer.get(sessionId)).add(report);
            }
            if (!ReportFilter.this._isBufferingInProgress) {
                ReportFilter.this._isBufferingInProgress = true;
                HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
                params.put(ReportFilter.KEY_RESET, Boolean.valueOf(true));
                params.put(ReportFilter.KEY_REPEAT_COUNT, Integer.valueOf(1));
                ReportFilter.this._channel.command(ReportFilter.CMD_ENABLE_FLUSH_FILTER_TIMER, params);
            }
            return null;
        }
    };
    private ICallback _flushBufferReport = new ICallback(){

        public Object call(Object param) {
            if (ReportFilter.this._isDestroyed) {
                return null;
            }
            for (String sessionId : ReportFilter.this._reportBuffer.keySet()) {
                ArrayList filteredReports = ReportFilter._filterPlayReports(ReportFilter._filterStartReports(ReportFilter._filterPauseReports((ArrayList)ReportFilter.this._reportBuffer.get(sessionId))));
                ReportFilter.this.computePrevTsValues(filteredReports);
                for (Report report : filteredReports) {
                    HashMap<String, Report> eventData = new HashMap<String, Report>();
                    eventData.put(ReportFilter.KEY_REPORT, report);
                    ReportFilter.this._channel.trigger(new Event(ReportFilter.EVENT_FILTER_REPORT_AVAILABLE, eventData));
                }
            }
            ReportFilter.this._reportBuffer.clear();
            String currentSession = (String)ReportFilter.this._channel.request(ReportFilter.REQ_SESSION_ID);
            HashMap currentSessionData = ReportFilter.this._tsHistory.containsKey(currentSession) ? (HashMap)ReportFilter.this._tsHistory.get(currentSession) : new HashMap();
            ReportFilter.this._tsHistory.clear();
            ReportFilter.this._tsHistory.put(currentSession, currentSessionData);
            ReportFilter.this._isBufferingInProgress = false;
            return null;
        }
    };
    private ICallback _onContextReportAvailable = new ICallback(){

        public Object call(Object param) {
            Event event = (Event)param;
            Object data = event.getData();
            ReportFilter.this._workQueue.addCommand(new Command(ReportFilter.this._bufferReport, data));
            return null;
        }
    };
    private ICallback _onClockFlushFilterTick = new ICallback(){

        public Object call(Object param) {
            ReportFilter.this.flush();
            return null;
        }
    };

    public ReportFilter(Channel channel, ILogger logger) {
        if (channel == null) {
            throw new Error("Reference to the channel object cannot be NULL.");
        }
        this._channel = channel;
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL.");
        }
        this._logTag = ReportFilter.class.getSimpleName();
        this._logger = logger;
        this._isDestroyed = false;
        this._isBufferingInProgress = false;
        this._reportBuffer = new HashMap<String, ArrayList<Report>>();
        this._tsHistory = new HashMap<String, HashMap<String, Long>>();
        this._workQueue = new CommandQueue();
        this._installEventListeners();
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._logger.debug(this._logTag, "#destroy()");
        this._uninstallEventListeners();
        this.clear();
        this._workQueue.destroy();
        this._reportBuffer = null;
        this._tsHistory = null;
    }

    public void clear() {
        this._logger.debug(this._logTag, "#_clear()");
        this._workQueue.cancelAllCommands();
        this._reportBuffer.clear();
        this._tsHistory.clear();
        this._isBufferingInProgress = false;
    }

    public void flush() {
        this._workQueue.addCommand(new Command(this._flushBufferReport, this));
    }

    private void computePrevTsValues(ArrayList<Report> reports) {
        for (Report report : reports) {
            String sessionId = report.getSessionData().getSessionId();
            if (!this._tsHistory.containsKey(sessionId)) {
                this._tsHistory.put(sessionId, new HashMap());
            }
            String key = report.getEventData().getType() + "." + (report.getAssetData().getType().equalsIgnoreCase("ad") ? report.getAssetData().getAdData().getAdId() : report.getAssetData().getVideoId());
            HashMap<String, Long> tsHistoryMap = this._tsHistory.get(sessionId);
            if (tsHistoryMap.containsKey(key)) {
                report.getEventData().setPrevTs(this._tsHistory.get(sessionId).get(key));
            }
            tsHistoryMap.put(key, report.getEventData().getTs());
        }
    }

    private void _installEventListeners() {
        this._channel.on(EVENT_CONTEXT_REPORT_AVAILABLE, this._onContextReportAvailable, this);
        this._channel.on(EVENT_CLOCK_FLUSH_FILTER_TICK, this._onClockFlushFilterTick, this);
    }

    private void _uninstallEventListeners() {
        this._channel.off(null, null, this);
    }

    private static ArrayList<Report> _filterPauseReports(ArrayList<Report> reports) {
        ArrayList<Report> result = new ArrayList<Report>();
        for (Report report : reports) {
            if (report.getEventData().getType() == "pause" || report.getEventData().getType() == "stall" || report.getEventData().getType() == "buffer") {
                if (report.getFilterReport().booleanValue() && report.getEventData().getDuration() <= 250L) continue;
                result.add(report);
                continue;
            }
            result.add(report);
        }
        return result;
    }

    private static ArrayList<Report> _filterStartReports(ArrayList<Report> reports) {
        int videoStartReportIdx = -1;
        int adStartReportIdx = -1;
        ArrayList<Report> result = new ArrayList<Report>();
        for (Report report : reports) {
            if (report.getEventData().getType() == "start") {
                if (report.getAssetData().getType() == "main") {
                    if (videoStartReportIdx == -1) {
                        result.add(report);
                        videoStartReportIdx = result.size() - 1;
                        continue;
                    }
                    report.getEventData().setPrevTs(-1L);
                    result.set(videoStartReportIdx, report);
                    continue;
                }
                if (adStartReportIdx == -1) {
                    result.add(report);
                    adStartReportIdx = result.size() - 1;
                    continue;
                }
                report.getEventData().setPrevTs(-1L);
                result.set(adStartReportIdx, report);
                continue;
            }
            result.add(report);
        }
        return result;
    }

    private static ArrayList<Report> _filterPlayReports(ArrayList<Report> reports) {
        ArrayList<Report> result = new ArrayList<Report>();
        for (Report report : reports) {
            if (report.getEventData().getType() == "play") {
                ArrayList<Report> inBandReports;
                if (report.getEventData().getDuration() > 250L) {
                    result.add(report);
                    continue;
                }
                if (report.getEventData().getDuration() != 0L || report.getAssetData().getType() != "main" || (inBandReports = ReportFilter._filterInBandReports(reports)).indexOf(report) != inBandReports.size() - 1) continue;
                result.add(report);
                continue;
            }
            result.add(report);
        }
        return result;
    }

    private static ArrayList<Report> _filterInBandReports(ArrayList<Report> reports) {
        ArrayList<Report> result = new ArrayList<Report>();
        for (Report report : reports) {
            if (report.getEventData().getType() != "play" && report.getEventData().getType() != "buffer" && report.getEventData().getType() != "start") continue;
            result.add(report);
        }
        return result;
    }
}

