/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.context;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.va.plugins.ah.engine.context.Context;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import com.adobe.primetime.va.plugins.ah.engine.model.report.TrackItem;

public class ReportFactory {
    private ILogger _logger;
    private String _logTag;
    private Context _context;

    public ReportFactory(Context context, ILogger logger) {
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL.");
        }
        this._logTag = ReportFactory.class.getSimpleName();
        this._logger = logger;
        if (context == null) {
            throw new Error("Reference to the context object cannot be NULL.");
        }
        this._context = context;
    }

    public Report createReportForItem(TrackItem item) {
        this._logger.debug(this._logTag, "Creating report for item: " + item.getEventDao().getType());
        Report report = new Report(this._context._adobeAnalyticsData, this._context._userData, this._context._aamData, this._context._serviceProviderData, this._context._sessionData, item);
        return report;
    }
}

