/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.BasePlugin;
import com.adobe.primetime.core.plugin.IPluginConfig;
import com.adobe.primetime.core.plugin.ParamMapping;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.core.radio.Command;
import com.adobe.primetime.core.radio.CommandQueue;
import com.adobe.primetime.core.radio.Radio;
import com.adobe.primetime.va.ErrorInfo;
import com.adobe.primetime.va.Version;
import com.adobe.primetime.va.plugins.ah.AdobeHeartbeatPluginConfig;
import com.adobe.primetime.va.plugins.ah.AdobeHeartbeatPluginDelegate;
import com.adobe.primetime.va.plugins.ah.engine.clock.Clock;
import com.adobe.primetime.va.plugins.ah.engine.context.Context;
import com.adobe.primetime.va.plugins.ah.engine.filter.ReportFilter;
import com.adobe.primetime.va.plugins.ah.engine.network.Network;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AdobeHeartbeatPlugin
extends BasePlugin {
    private static final String NAME = "adobe-heartbeat";
    private static final String ADOBE_HEARTBEAT_PLUGIN = "adobe-heartbeat";
    private static final String ADOBE_ANALYTICS_PLUGIN = "adobe-analytics";
    private static final String ADOBE_NIELSEN_PLUGIN = "adobe-nielsen";
    private static final String PLAYER_PLUGIN = "player";
    private static final String CLOCK_SERVICE = "service.clock";
    private static final String REQ_SESSION_ID = "session_id";
    private static final String RESET_SESSION_ID = "reset_session_id";
    private static final String HEARTBEAT_CHANNEL = "heartbeat-channel";
    private static final String ERROR = "error";
    private static final String AA_START = "aa_start";
    private static final String AA_AD_START = "sc_ad_start";
    private static final String VIDEO_LOAD = "video_load";
    private static final String VIDEO_UNLOAD = "video_unload";
    private static final String VIDEO_UNLOADED = "video_unloaded";
    private static final String VIDEO_START = "video_start";
    private static final String VIDEO_RESUME = "video_resume";
    private static final String VIDEO_COMPLETE = "video_complete";
    private static final String VIDEO_SKIP = "video_skip";
    private static final String VIDEO_SESSION_END = "video_session_end";
    private static final String PLAY = "play";
    private static final String PAUSE = "pause";
    private static final String CONTENT_START = "content_start";
    private static final String AD_START = "ad_start";
    private static final String AD_COMPLETE = "ad_complete";
    private static final String AD_SKIP = "ad_skip";
    private static final String ADBREAK_START = "adbreak_start";
    private static final String ADBREAK_COMPLETE = "adbreak_complete";
    private static final String BUFFER_START = "buffer_start";
    private static final String BUFFER_COMPLETE = "buffer_complete";
    private static final String SEEK_START = "seek_start";
    private static final String SEEK_COMPLETE = "seek_complete";
    private static final String CHAPTER_START = "chapter_start";
    private static final String CHAPTER_COMPLETE = "chapter_complete";
    private static final String CHAPTER_SKIP = "chapter_skip";
    private static final String BITRATE_CHANGE = "bitrate_change";
    private static final String TRACK_ERROR = "track_error";
    private static final String VIDEO_IDLE_START = "video_idle_start";
    private static final String VIDEO_IDLE_RESUME = "video_idle_resume";
    private static final String VIDEO_QUANTUM_CLOSE = "quantum_close";
    private static final String TIMER_REPORTING = "heartbeat.reporting";
    private static final String TIMER_REPORTING_TICK = "heartbeat.reporting.tick";
    private static final String TIMER_IDLE = "heartbeat.idle";
    private static final String TIMER_IDLE_TICK = "heartbeat.idle.tick";
    private static final String KEY_RESET = "reset";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_ERROR_ID = "error_id";
    private static final String KEY_TRACKING_SERVER = "tracking_server";
    private static final String KEY_CHECK_STATUS_SERVER = "check_status_server";
    private static final String KEY_PUBLISHER = "publisher";
    private static final String KEY_QUIET_MODE = "quiet_mode";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_CHECK_TRACKING_DISABLED = "tracking_disabled";
    private static String EVENT_API_AA_START = "api:aa_start";
    private static String EVENT_API_AA_AD_START = "api:aa_ad_start";
    private static String EVENT_API_CONFIG = "api:config";
    private static String EVENT_API_VIDEO_LOAD = "api:video_load";
    private static String EVENT_API_VIDEO_UNLOAD = "api:video_unload";
    private static String EVENT_API_VIDEO_START = "api:video_start";
    private static String EVENT_API_VIDEO_COMPLETE = "api:video_complete";
    private static String EVENT_API_VIDEO_SKIP = "api:video_skip";
    private static String EVENT_API_VIDEO_RESUME = "api:video_resume";
    private static String EVENT_API_VIDEO_SESSION_END = "api:video_session_end";
    private static String EVENT_API_AD_START = "api:ad_start";
    private static String EVENT_API_AD_COMPLETE = "api:ad_complete";
    private static String EVENT_API_AD_SKIP = "api:ad_skip";
    private static String EVENT_API_ADBREAK_START = "api:adbreak_start";
    private static String EVENT_API_ADBREAK_COMPLETE = "api:adbreak_complete";
    private static String EVENT_API_PLAY = "api:play";
    private static String EVENT_API_PAUSE = "api:pause";
    private static String EVENT_API_BUFFER_START = "api:buffer_start";
    private static String EVENT_API_SEEK_START = "api:seek_start";
    private static String EVENT_API_SEEK_COMPLETE = "api:seek_complete";
    private static String EVENT_API_CHAPTER_START = "api:chapter_start";
    private static String EVENT_API_CHAPTER_COMPLETE = "api:chapter_complete";
    private static String EVENT_API_CHAPTER_SKIP = "api:chapter_skip";
    private static String EVENT_API_TRACK_ERROR = "api:track_error";
    private static String EVENT_API_TRACK_INTERNAL_ERROR = "api:track_internal_error";
    private static String EVENT_API_BITRATE_CHANGE = "api:bitrate_change";
    private static String EVENT_API_QUANTUM_END = "api:quantum_end";
    private static final String ERROR_SOURCE_HEARTBEAT = "sourceErrorHeartbeat";
    private static String CMD_ENABLE_CHECK_STATUS_TIMER = "clock:check_status.resume";
    private static String CMD_ENABLE_REPORTING_TIMER = "clock:reporting.resume";
    private static String CMD_DISABLE_REPORTING_TIMER = "clock:reporting.pause";
    private static String CMD_ENABLE_FLUSH_FILTER_TIMER = "clock:flush_filter.resume";
    private static String CMD_DISABLE_FLUSH_FILTER_TIMER = "clock:flush_filter.pause";
    private static String CMD_ENABLE_IDLE_TIMER = "clock:idle.resume";
    private static String CMD_DISABLE_IDLE_TIMER = "clock:idle.pause";
    private static String EVENT_CLOCK_CHECK_STATUS_GET_SETTINGS = "clock:check_status.get_settings";
    private static String EVENT_NET_CHECK_STATUS_COMPLETE = "net:check_status_complete";
    private AdobeHeartbeatPluginDelegate _delegate;
    private ErrorInfo _errorInfo;
    private Radio _radio;
    private Channel _channel;
    private AdobeHeartbeatPluginConfig _config;
    private boolean _isConfigured = false;
    private boolean _isTrackingSessionActive = false;
    private boolean _isPaused;
    private boolean _isSeeking;
    private boolean _isBuffering;
    private boolean _isVideoIdle;
    private boolean _idleTimerRunning;
    private Clock _clock;
    private Context _context;
    private Network _network;
    private ReportFilter _filter;
    private CommandQueue _workQueue;
    private ICallback _cmdAnalyticsError = new ICallback(){

        public Object call(Object data) {
            if (AdobeHeartbeatPlugin.this._errorInfo != null) {
                return null;
            }
            AdobeHeartbeatPlugin.this._errorInfo = new ErrorInfo("Internal error", "AdobeHeartbeatPlugin is in ERROR state.");
            AdobeHeartbeatPlugin.this._trigger(AdobeHeartbeatPlugin.ERROR, AdobeHeartbeatPlugin.this._errorInfo);
            if (AdobeHeartbeatPlugin.this._delegate != null) {
                AdobeHeartbeatPlugin.this._delegate.onError(AdobeHeartbeatPlugin.this._errorInfo);
            }
            return null;
        }
    };
    private ICallback _cmdAnalyticsStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_AA_START, data));
            return null;
        }
    };
    private ICallback _cmdAnalyticsAdStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_AA_AD_START, data));
            return null;
        }
    };
    private ICallback _cmdVideoLoad = new ICallback(){

        public Object call(Object data) {
            AdobeHeartbeatPlugin.this._errorInfo = null;
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            if (AdobeHeartbeatPlugin.this._isTrackingSessionActive) {
                AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_UNLOAD, data));
            }
            AdobeHeartbeatPlugin.this._isTrackingSessionActive = false;
            AdobeHeartbeatPlugin.this._isPaused = true;
            AdobeHeartbeatPlugin.this._isSeeking = false;
            AdobeHeartbeatPlugin.this._isBuffering = false;
            AdobeHeartbeatPlugin.this._isVideoIdle = false;
            AdobeHeartbeatPlugin.this._idleTimerRunning = false;
            HashMap map = (HashMap)data;
            if (map.containsKey("opt_out") && map.get("opt_out") != null) {
                AdobeHeartbeatPlugin.this._network.setOptOut((Boolean)map.get("opt_out"));
            }
            AdobeHeartbeatPlugin.this._filter.clear();
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_LOAD, data));
            AdobeHeartbeatPlugin.this._isTrackingSessionActive = true;
            return null;
        }
    };
    private ICallback _cmdVideoUnload = new ICallback(){

        public Object call(Object data) {
            AdobeHeartbeatPlugin.this._errorInfo = null;
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_UNLOAD, data));
            AdobeHeartbeatPlugin.this._filter.flush();
            AdobeHeartbeatPlugin.this._runReportingTimer(false);
            AdobeHeartbeatPlugin.this._runFlushFilterTimer(false);
            AdobeHeartbeatPlugin.this._runIdleTimer(false);
            AdobeHeartbeatPlugin.this._isTrackingSessionActive = false;
            return null;
        }
    };
    private ICallback _cmdVideoSessionEnd = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_SESSION_END, data));
            return null;
        }
    };
    private ICallback _cmdVideoStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_START, data));
            AdobeHeartbeatPlugin.this._filter.flush();
            return null;
        }
    };
    private ICallback _cmdVideoComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_COMPLETE, data));
            return null;
        }
    };
    private ICallback _cmdVideoSkip = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_SKIP, data));
            return null;
        }
    };
    private ICallback _cmdVideoResume = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_RESUME, data));
            return null;
        }
    };
    private ICallback _cmdPlay = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._isPaused = false;
            AdobeHeartbeatPlugin.this._resumePlaybackIfPossible(data);
            return null;
        }
    };
    private ICallback _cmdPause = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_PAUSE, data));
            AdobeHeartbeatPlugin.this._isPaused = true;
            AdobeHeartbeatPlugin.this._runIdleTimer(true);
            return null;
        }
    };
    private ICallback _cmdAdStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_AD_START, data));
            AdobeHeartbeatPlugin.this._resumePlaybackIfPossible(data);
            return null;
        }
    };
    private ICallback _cmdAdComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_AD_COMPLETE, data));
            return null;
        }
    };
    private ICallback _cmdAdSkip = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_AD_SKIP, data));
            return null;
        }
    };
    private ICallback _cmdAdBreakStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_ADBREAK_START, data));
            return null;
        }
    };
    private ICallback _cmdAdBreakComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_ADBREAK_COMPLETE, data));
            AdobeHeartbeatPlugin.this._resumePlaybackIfPossible(data);
            return null;
        }
    };
    private ICallback _cmdBufferStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_BUFFER_START, data));
            AdobeHeartbeatPlugin.this._isBuffering = true;
            AdobeHeartbeatPlugin.this._runIdleTimer(true);
            return null;
        }
    };
    private ICallback _cmdBufferComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._isBuffering = false;
            if (AdobeHeartbeatPlugin.this._isPaused) {
                AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_PAUSE, data));
            } else {
                AdobeHeartbeatPlugin.this._resumePlaybackIfPossible(data);
            }
            return null;
        }
    };
    private ICallback _cmdSeekStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_PAUSE, data));
            AdobeHeartbeatPlugin.this._isSeeking = true;
            AdobeHeartbeatPlugin.this._runIdleTimer(true);
            return null;
        }
    };
    private ICallback _cmdSeekComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._isSeeking = false;
            AdobeHeartbeatPlugin.this._resumePlaybackIfPossible(data);
            return null;
        }
    };
    private ICallback _cmdChapterStart = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_CHAPTER_START, data));
            return null;
        }
    };
    private ICallback _cmdChapterSkip = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_CHAPTER_SKIP, data));
            return null;
        }
    };
    private ICallback _cmdChapterComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_CHAPTER_COMPLETE, data));
            return null;
        }
    };
    private ICallback _cmdBitrateChange = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_BITRATE_CHANGE, data));
            return null;
        }
    };
    private ICallback _cmdTrackError = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_TRACK_ERROR, data));
            return null;
        }
    };
    private ICallback _cmdClockReportingTick = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            if (!AdobeHeartbeatPlugin.this._isVideoIdle) {
                AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_QUANTUM_END, data));
            }
            return null;
        }
    };
    private ICallback _onCheckStatusComplete = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._workQueue.addCommand(new Command(AdobeHeartbeatPlugin.this._handleMediaTrackingSwitch, data));
            return null;
        }
    };
    private ICallback _cmdIdleTick = new ICallback(){

        public Object call(Object data) {
            if (!AdobeHeartbeatPlugin.this._canProcess()) {
                return null;
            }
            AdobeHeartbeatPlugin.this._trigger(AdobeHeartbeatPlugin.VIDEO_QUANTUM_CLOSE, null);
            AdobeHeartbeatPlugin.this._isVideoIdle = true;
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_VIDEO_SESSION_END, data));
            AdobeHeartbeatPlugin.this._filter.flush();
            AdobeHeartbeatPlugin.this._runReportingTimer(false);
            AdobeHeartbeatPlugin.this._runFlushFilterTimer(false);
            AdobeHeartbeatPlugin.this._runIdleTimer(false);
            AdobeHeartbeatPlugin.this._trigger(AdobeHeartbeatPlugin.VIDEO_IDLE_START, null);
            return null;
        }
    };
    private ICallback _onError = new ICallback(){

        public Object call(Object param) {
            Event e = (Event)param;
            AdobeHeartbeatPlugin.this._errorInfo = (ErrorInfo)e.getData();
            HashMap<String, String> eventData = new HashMap<String, String>();
            eventData.put(AdobeHeartbeatPlugin.KEY_SOURCE, AdobeHeartbeatPlugin.ERROR_SOURCE_HEARTBEAT);
            eventData.put(AdobeHeartbeatPlugin.KEY_ERROR_ID, AdobeHeartbeatPlugin.this._errorInfo.getMessage() + "|" + AdobeHeartbeatPlugin.this._errorInfo.getDetails());
            AdobeHeartbeatPlugin.this._channel.trigger(new Event(EVENT_API_TRACK_INTERNAL_ERROR, eventData));
            AdobeHeartbeatPlugin.this._runReportingTimer(false);
            if (AdobeHeartbeatPlugin.this._delegate != null) {
                AdobeHeartbeatPlugin.this._delegate.onError(AdobeHeartbeatPlugin.this._errorInfo);
            }
            AdobeHeartbeatPlugin.this._workQueue.addCommand(new Command(AdobeHeartbeatPlugin.this._triggerError, AdobeHeartbeatPlugin.this._errorInfo));
            return null;
        }
    };
    private ICallback _handleMediaTrackingSwitch = new ICallback(){

        public Object call(Object param) {
            Map eventData = (Map)((Event)param).getData();
            boolean trackingDisabled = eventData.get(AdobeHeartbeatPlugin.KEY_CHECK_TRACKING_DISABLED) != null ? (Boolean)eventData.get(AdobeHeartbeatPlugin.KEY_CHECK_TRACKING_DISABLED) : false;
            AdobeHeartbeatPlugin.this._logger.debug(AdobeHeartbeatPlugin.this._logTag, "#_onCheckStatusComplete(trackingDisabled=" + trackingDisabled + ")");
            if (trackingDisabled && AdobeHeartbeatPlugin.this._delegate != null) {
                AdobeHeartbeatPlugin.this._delegate.onTrackingDisabled();
            }
            return null;
        }
    };
    private ICallback _triggerError = new ICallback(){

        public Object call(Object errorInfo) {
            AdobeHeartbeatPlugin.this._trigger(AdobeHeartbeatPlugin.ERROR, errorInfo);
            return null;
        }
    };

    public AdobeHeartbeatPlugin(AdobeHeartbeatPluginDelegate delegate) {
        super("adobe-heartbeat");
        this._radio = new Radio(this._logger);
        this._channel = this._radio.channel(HEARTBEAT_CHANNEL);
        this._delegate = delegate;
        this._context = new Context(this._channel, this._logger);
        this._filter = new ReportFilter(this._channel, this._logger);
        this._network = new Network(this._channel, this._logger);
        this._workQueue = new CommandQueue(true);
        this._setupDataResolver();
    }

    public void configure(IPluginConfig configData) {
        if (configData == null) {
            throw new Error("Reference tp the configuration data cannot be NULL.");
        }
        if (!(configData instanceof AdobeHeartbeatPluginConfig)) {
            throw new Error("Expected config data to be instance of AdobeHeartbeatPluginConfig.");
        }
        this._config = (AdobeHeartbeatPluginConfig)configData;
        if (this._config.debugLogging) {
            this._logger.enable();
        } else {
            this._logger.disable();
        }
        this._logger.debug(this._logTag, "#configure({trackingServer=" + this._config.getTrackingServer() + ", publisher=" + this._config.getPublisher() + ", quietMode=" + this._config.quietMode + ", ssl=" + this._config.ssl + "})");
        String checkStatusServer = this._config.getTrackingServer() + "/settings/";
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put(KEY_TRACKING_SERVER, this._config.getTrackingServer());
        eventData.put(KEY_CHECK_STATUS_SERVER, checkStatusServer);
        eventData.put(KEY_PUBLISHER, this._config.getPublisher());
        eventData.put(KEY_QUIET_MODE, this._config.quietMode);
        eventData.put(KEY_SSL, this._config.ssl);
        this._channel.trigger(new Event(EVENT_API_CONFIG, eventData));
        this._workQueue.resume();
        this._isConfigured = true;
    }

    public void bootstrap(PluginManager pluginManager) {
        super.bootstrap(pluginManager);
        this._channel.on(ERROR, this._onError, this);
        this._clock = new Clock(this._pluginManager, this._channel, this._logger);
        this._channel.command(CMD_ENABLE_CHECK_STATUS_TIMER, null);
        this._channel.trigger(new Event(EVENT_CLOCK_CHECK_STATUS_GET_SETTINGS, null));
        this._channel.on(EVENT_NET_CHECK_STATUS_COMPLETE, this._onCheckStatusComplete, this);
        this._registerCommands();
        this._registerBehaviours();
    }

    protected void _teardown() {
        this._logger.debug(this._logTag, "#_teardown()");
        this._context.destroy();
        this._clock.destroy();
        this._filter.destroy();
        this._network.destroy();
        this._radio.shutdown();
        this._workQueue.destroy();
    }

    protected boolean _canProcess() {
        if (!this._isConfigured) {
            this._logger.error(this._logTag, "_canProcess() > Plugin not configured.");
            return false;
        }
        if (this._errorInfo != null) {
            this._logger.error(this._logTag, "_canProcess() > Plugin in ERROR state.");
            return false;
        }
        return super._canProcess();
    }

    private void _runIdleTimer(boolean run) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(KEY_RESET, true);
        if (run && !this._idleTimerRunning) {
            this._channel.command(CMD_ENABLE_IDLE_TIMER, params);
            this._idleTimerRunning = true;
        } else if (!run) {
            this._channel.command(CMD_DISABLE_IDLE_TIMER, params);
            this._idleTimerRunning = false;
        }
    }

    private void _runFlushFilterTimer(boolean run) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(KEY_RESET, true);
        if (run) {
            this._channel.command(CMD_ENABLE_FLUSH_FILTER_TIMER, params);
        } else {
            this._channel.command(CMD_DISABLE_FLUSH_FILTER_TIMER, params);
        }
    }

    private void _runReportingTimer(boolean run) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(KEY_RESET, true);
        if (run) {
            this._channel.command(CMD_ENABLE_REPORTING_TIMER, params);
        } else {
            this._channel.command(CMD_DISABLE_REPORTING_TIMER, params);
        }
    }

    private void _registerCommands() {
        this._pluginManager.comply(this, "handleAnalyticsError", this._cmdAnalyticsError);
        this._pluginManager.comply(this, "handleAnalyticsStart", this._cmdAnalyticsStart);
        this._pluginManager.comply(this, "handleAnalyticsAdStart", this._cmdAnalyticsAdStart);
        this._pluginManager.comply(this, "handleVideoLoad", this._cmdVideoLoad);
        this._pluginManager.comply(this, "handleVideoUnload", this._cmdVideoUnload);
        this._pluginManager.comply(this, "handleVideoSessionEnd", this._cmdVideoSessionEnd);
        this._pluginManager.comply(this, "handleVideoStart", this._cmdVideoStart);
        this._pluginManager.comply(this, "handleVideoComplete", this._cmdVideoComplete);
        this._pluginManager.comply(this, "handleVideoSkip", this._cmdVideoSkip);
        this._pluginManager.comply(this, "handleVideoResume", this._cmdVideoResume);
        this._pluginManager.comply(this, "handlePlay", this._cmdPlay);
        this._pluginManager.comply(this, "handlePause", this._cmdPause);
        this._pluginManager.comply(this, "handleAdStart", this._cmdAdStart);
        this._pluginManager.comply(this, "handleAdComplete", this._cmdAdComplete);
        this._pluginManager.comply(this, "handleAdSkip", this._cmdAdSkip);
        this._pluginManager.comply(this, "handleAdBreakStart", this._cmdAdBreakStart);
        this._pluginManager.comply(this, "handleAdBreakComplete", this._cmdAdBreakComplete);
        this._pluginManager.comply(this, "handleBufferStart", this._cmdBufferStart);
        this._pluginManager.comply(this, "handleBufferComplete", this._cmdBufferComplete);
        this._pluginManager.comply(this, "handleSeekStart", this._cmdSeekStart);
        this._pluginManager.comply(this, "handleSeekComplete", this._cmdSeekComplete);
        this._pluginManager.comply(this, "handleChapterStart", this._cmdChapterStart);
        this._pluginManager.comply(this, "handleChapterComplete", this._cmdChapterComplete);
        this._pluginManager.comply(this, "handleChapterSkip", this._cmdChapterSkip);
        this._pluginManager.comply(this, "handleBitrateChange", this._cmdBitrateChange);
        this._pluginManager.comply(this, "handleTrackError", this._cmdTrackError);
        this._pluginManager.comply(this, "handleClockReportingTick", this._cmdClockReportingTick);
        this._pluginManager.comply(this, "handleIdleTick", this._cmdIdleTick);
    }

    private void _registerBehaviours() {
        ArrayList<ParamMapping> videoLoad = new ArrayList<ParamMapping>();
        videoLoad.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "rsid", "rsid"));
        videoLoad.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, KEY_TRACKING_SERVER, "trackingServer"));
        videoLoad.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "opt_out", "opt_out"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_LOAD), this, "handleVideoLoad", videoLoad);
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_UNLOAD), this, "handleVideoUnload", null);
        ArrayList<ParamMapping> videoSessionEnd = new ArrayList<ParamMapping>();
        videoSessionEnd.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_SESSION_END), this, "handleVideoSessionEnd", videoSessionEnd);
        ArrayList<ParamMapping> videoStart = new ArrayList<ParamMapping>();
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.id", "videoId"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.name", "videoName"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.length", "videoLength"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playerName", "playerName"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.streamType", "streamType"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "rsid", "rsid"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, KEY_TRACKING_SERVER, "trackingServer"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "channel", "channel"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.video.*", "metaVideo"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, KEY_SSL, "useSsl"));
        videoStart.add(new ParamMapping(ADOBE_NIELSEN_PLUGIN, "meta", "metaNielsen"));
        videoStart.add(new ParamMapping("adobe-heartbeat", KEY_PUBLISHER, KEY_PUBLISHER));
        videoStart.add(new ParamMapping("adobe-heartbeat", "sdk", "sdk"));
        videoStart.add(new ParamMapping("adobe-heartbeat", "ovp", "ovp"));
        videoStart.add(new ParamMapping("adobe-heartbeat", "version", "version"));
        videoStart.add(new ParamMapping("adobe-heartbeat", "api_level", "apiLvl"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_START), this, "handleVideoStart", videoStart);
        ArrayList<ParamMapping> videoComplete = new ArrayList<ParamMapping>();
        videoComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        videoComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        videoComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        videoComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        videoComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_COMPLETE), this, "handleVideoComplete", videoComplete);
        ArrayList<ParamMapping> videoSkip = new ArrayList<ParamMapping>();
        videoSkip.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        videoSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        videoSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        videoSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        videoSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_SKIP), this, "handleVideoSkip", videoSkip);
        ArrayList<ParamMapping> videoResume = new ArrayList<ParamMapping>();
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.id", "videoId"));
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.name", "videoName"));
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.length", "videoLength"));
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.playerName", "playerName"));
        videoResume.add(new ParamMapping(PLAYER_PLUGIN, "video.streamType", "streamType"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_RESUME), this, "handleVideoResume", videoResume);
        ArrayList<ParamMapping> play = new ArrayList<ParamMapping>();
        play.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        play.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        play.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        play.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        play.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, PLAY), this, "handlePlay", play);
        ArrayList<ParamMapping> pause = new ArrayList<ParamMapping>();
        pause.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        pause.add(new ParamMapping(PLAYER_PLUGIN, "video.playheadStalled", "playheadStalled"));
        pause.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        pause.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        pause.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        pause.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, PAUSE), this, "handlePause", pause);
        ArrayList<ParamMapping> adStart = new ArrayList<ParamMapping>();
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.id", "adId"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.name", "adName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.length", "adLength"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.position", "adPosition"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.granularTracking", "adGranularTracking"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.trackingInterval", "adTrackingInterval"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.name", "podName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.playerName", "podPlayerName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.position", "podPosition"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.startTime", "podSecond"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.video.*", "metaVideo"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.ad.*", "metaAd"));
        adStart.add(new ParamMapping(ADOBE_NIELSEN_PLUGIN, "meta", "metaNielsen"));
        adStart.add(new ParamMapping(ADOBE_NIELSEN_PLUGIN, "metaAd", "adMetaNielsen"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, AD_START), this, "handleAdStart", adStart);
        ArrayList<ParamMapping> adComplete = new ArrayList<ParamMapping>();
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "ad.isInAdBreak", "isInAdBreak"));
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        adComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, AD_COMPLETE), this, "handleAdComplete", adComplete);
        ArrayList<ParamMapping> adSkip = new ArrayList<ParamMapping>();
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "ad.isInAdBreak", "isInAdBreak"));
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        adSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, AD_SKIP), this, "handleAdSkip", adSkip);
        ArrayList<ParamMapping> adBreakStart = new ArrayList<ParamMapping>();
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.isInAdBreak", "isInAdBreak"));
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        adBreakStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, ADBREAK_START), this, "handleAdBreakStart", adBreakStart);
        ArrayList<ParamMapping> adBreakComplete = new ArrayList<ParamMapping>();
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "ad.isInAdBreak", "isInAdBreak"));
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        adBreakComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, ADBREAK_COMPLETE), this, "handleAdBreakComplete", adBreakComplete);
        ArrayList<ParamMapping> bufferStart = new ArrayList<ParamMapping>();
        bufferStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        bufferStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        bufferStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        bufferStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        bufferStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, BUFFER_START), this, "handleBufferStart", bufferStart);
        ArrayList<ParamMapping> bufferComplete = new ArrayList<ParamMapping>();
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playheadStalled", "playheadStalled"));
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        bufferComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, BUFFER_COMPLETE), this, "handleBufferComplete", bufferComplete);
        ArrayList<ParamMapping> seekStart = new ArrayList<ParamMapping>();
        seekStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, SEEK_START), this, "handleSeekStart", seekStart);
        ArrayList<ParamMapping> seekComplete = new ArrayList<ParamMapping>();
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "ad.isInAd", "isInAd"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "ad.id", "adId"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "ad.position", "adPosition"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "pod.playerName", "podPlayerName"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "pod.position", "podPosition"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "chapter.isInChapter", "isInChapter"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "chapter.position", "chapterPosition"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "chapter.name", "chapterName"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "chapter.length", "chapterLength"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "chapter.startTime", "chapterOffset"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        seekComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, SEEK_COMPLETE), this, "handleSeekComplete", seekComplete);
        ArrayList<ParamMapping> chapterStart = new ArrayList<ParamMapping>();
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "chapter.position", "chapterPosition"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "chapter.name", "chapterName"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "chapter.length", "chapterLength"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "chapter.startTime", "chapterOffset"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        chapterStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        chapterStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.video.*", "metaVideo"));
        chapterStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.chapter.*", "metaChapter"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, CHAPTER_START), this, "handleChapterStart", chapterStart);
        ArrayList<ParamMapping> chapterComplete = new ArrayList<ParamMapping>();
        chapterComplete.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        chapterComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        chapterComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        chapterComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        chapterComplete.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, CHAPTER_COMPLETE), this, "handleChapterComplete", chapterComplete);
        ArrayList<ParamMapping> chapterSkip = new ArrayList<ParamMapping>();
        chapterSkip.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        chapterSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        chapterSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        chapterSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        chapterSkip.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, CHAPTER_SKIP), this, "handleChapterSkip", chapterSkip);
        ArrayList<ParamMapping> bitrateChange = new ArrayList<ParamMapping>();
        bitrateChange.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        bitrateChange.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        bitrateChange.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        bitrateChange.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        bitrateChange.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, BITRATE_CHANGE), this, "handleBitrateChange", bitrateChange);
        ArrayList<ParamMapping> trackError = new ArrayList<ParamMapping>();
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, TRACK_ERROR), this, "handleTrackError", trackError);
        ArrayList<ParamMapping> timeReportingTick = new ArrayList<ParamMapping>();
        timeReportingTick.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        timeReportingTick.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        timeReportingTick.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        timeReportingTick.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        timeReportingTick.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(CLOCK_SERVICE, TIMER_REPORTING_TICK), this, "handleClockReportingTick", timeReportingTick);
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, CONTENT_START), this, "handleClockReportingTick", timeReportingTick);
        ArrayList<ParamMapping> timeIdleTick = new ArrayList<ParamMapping>();
        timeIdleTick.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        this._pluginManager.registerBehaviour(new Trigger(CLOCK_SERVICE, TIMER_IDLE_TICK), this, "handleIdleTick", timeIdleTick);
        this._pluginManager.registerBehaviour(new Trigger("adobe-heartbeat", VIDEO_QUANTUM_CLOSE), this, "handleClockReportingTick", timeReportingTick);
        ArrayList<ParamMapping> error = new ArrayList<ParamMapping>();
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_ANALYTICS_PLUGIN, ERROR), this, "handleAnalyticsError", error);
        ArrayList<ParamMapping> aaStart = new ArrayList<ParamMapping>();
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "vid", "vid"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "aid", "aid"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "mid", "mid"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "userId.id", "dpid"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "puuid.id", "dpuuid"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "blob", "blob"));
        aaStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "loc_hint", "loc_hint"));
        aaStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        aaStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        aaStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        aaStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        aaStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_ANALYTICS_PLUGIN, AA_START), this, "handleAnalyticsStart", aaStart);
        ArrayList<ParamMapping> aaAdStart = new ArrayList<ParamMapping>();
        aaAdStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        aaAdStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.fps", "fps"));
        aaAdStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.droppedFrames", "droppedFrames"));
        aaAdStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.bitrate", "bitrate"));
        aaAdStart.add(new ParamMapping(PLAYER_PLUGIN, "qos.startupTime", "startupTime"));
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_ANALYTICS_PLUGIN, AA_AD_START), this, "handleAnalyticsAdStart", aaAdStart);
    }

    private void _setupDataResolver() {
        final HashMap<String, ICallback> fnMap = new HashMap<String, ICallback>();
        fnMap.put("version", new ICallback(){

            public Object call(Object param) {
                return Version.getVersion();
            }
        });
        fnMap.put("api_level", new ICallback(){

            public Object call(Object param) {
                return Version.getApiLevel();
            }
        });
        fnMap.put(KEY_TRACKING_SERVER, new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? AdobeHeartbeatPlugin.this._config.getTrackingServer() : null;
            }
        });
        fnMap.put(KEY_PUBLISHER, new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? AdobeHeartbeatPlugin.this._config.getPublisher() : null;
            }
        });
        fnMap.put(KEY_QUIET_MODE, new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? ((AdobeHeartbeatPlugin)AdobeHeartbeatPlugin.this)._config.quietMode : false;
            }
        });
        fnMap.put("ovp", new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? ((AdobeHeartbeatPlugin)AdobeHeartbeatPlugin.this)._config.ovp : Boolean.valueOf(false);
            }
        });
        fnMap.put("sdk", new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? ((AdobeHeartbeatPlugin)AdobeHeartbeatPlugin.this)._config.sdk : null;
            }
        });
        fnMap.put("is_primetime", new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? ((AdobeHeartbeatPlugin)AdobeHeartbeatPlugin.this)._config.__isPrimetime : false;
            }
        });
        fnMap.put("psdk_version", new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._config != null ? ((AdobeHeartbeatPlugin)AdobeHeartbeatPlugin.this)._config.__psdkVersion : null;
            }
        });
        fnMap.put(REQ_SESSION_ID, new ICallback(){

            public Object call(Object param) {
                return AdobeHeartbeatPlugin.this._channel.request(AdobeHeartbeatPlugin.REQ_SESSION_ID);
            }
        });
        this._dataResolver = new ICallback(){

            public Object call(Object param) {
                ArrayList keys = (ArrayList)param;
                if (keys == null || keys.size() == 0) {
                    return null;
                }
                HashMap<String, Object> _result = new HashMap<String, Object>();
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key;
                    _result.put(key, fnMap.containsKey(key = (String)iterator.next()) ? ((ICallback)fnMap.get(key)).call(this) : null);
                }
                return _result;
            }
        };
    }

    private void _resumePlaybackIfPossible(Object data) {
        if (this._errorInfo != null) {
            return;
        }
        if (!(this._isPaused || this._isSeeking || this._isBuffering)) {
            if (this._isVideoIdle) {
                this._isVideoIdle = false;
                this._resumePlaybackFromIdle();
            } else {
                this._channel.trigger(new Event(EVENT_API_PLAY, data));
            }
            this._runIdleTimer(false);
        }
    }

    private void _resumePlaybackFromIdle() {
        this._trigger(VIDEO_QUANTUM_CLOSE, null);
        this._filter.clear();
        this._channel.trigger(new Event(RESET_SESSION_ID, null));
        this._trigger(VIDEO_IDLE_RESUME, null);
        this._runReportingTimer(true);
        this._runFlushFilterTimer(true);
    }
}

