/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core.plugin;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.Behaviour;
import com.adobe.primetime.core.plugin.IPlugin;
import com.adobe.primetime.core.plugin.ParamMapping;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.core.radio.Radio;
import com.adobe.primetime.va.ErrorInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    public static final String ALL_PLUGINS = "*";
    private static final String DATA_CHANNEL = "data_channel";
    private static final String CTRL_CHANNEL = "ctrl_channel";
    private Map<String, IPlugin> _plugins;
    private Map<String, List<Behaviour>> _behaviours;
    private String _logTag;
    private ILogger _logger;
    private Channel _ctrlChannel;
    private Channel _dataChannel;
    private Radio _radio;
    private boolean _isDestroyed;
    private ErrorInfo _errorInfo;

    public PluginManager(ILogger logger) {
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL");
        }
        this._logTag = PluginManager.class.getSimpleName();
        this._logger = logger;
        this._isDestroyed = false;
        this._plugins = new HashMap<String, IPlugin>();
        this._behaviours = new HashMap<String, List<Behaviour>>();
        this._radio = new Radio(this._logger);
        this._ctrlChannel = this._radio.channel(CTRL_CHANNEL);
        this._dataChannel = this._radio.channel(DATA_CHANNEL);
    }

    public void addPlugin(IPlugin plugin) {
        if (this._isDestroyed) {
            return;
        }
        String pluginName = plugin.getName();
        if (this._plugins.get(pluginName) != null) {
            this._logger.info(this._logTag, "#addPlugin > Replacing plugin: " + plugin.getName());
        }
        this._plugins.put(pluginName, plugin);
        plugin.bootstrap(this);
    }

    public void setupPlugins() {
        if (this._isDestroyed) {
            return;
        }
        for (IPlugin plugin : this._plugins.values()) {
            plugin.setup();
        }
    }

    public Boolean pluginExists(String pluginName) {
        return !this._isDestroyed && this._plugins.get(pluginName) != null;
    }

    public boolean isPluginInitialized(String pluginName) {
        return !this._isDestroyed && this._plugins.get(pluginName) != null && this._plugins.get(pluginName).isInitialized();
    }

    public void on(String pluginName, String eventType, ICallback cb, Object ctx) {
        if (this._isDestroyed) {
            return;
        }
        this._dataChannel.on(pluginName + ":" + eventType, cb, ctx);
    }

    public void off(String pluginName, String eventType, ICallback cb, Object ctx) {
        if (this._isDestroyed) {
            return;
        }
        String eventFullName = pluginName != null && eventType != null ? pluginName + ":" + eventType : null;
        this._dataChannel.off(eventFullName, cb, ctx);
    }

    public void trigger(Event event) {
        String eventName = event.getName();
        ArrayList behaviours = (ArrayList)this._behaviours.get(eventName);
        if (this._isDestroyed) {
            return;
        }
        if (behaviours != null) {
            HashMap batches = new HashMap();
            HashMap<String, Object> dataCache = new HashMap<String, Object>();
            for (Behaviour behaviour : behaviours) {
                for (ParamMapping paramMapping : behaviour.getParams()) {
                    if (!batches.containsKey(paramMapping.getPluginName())) {
                        batches.put(paramMapping.getPluginName(), new ArrayList());
                    }
                    if (((List)batches.get(paramMapping.getPluginName())).contains(paramMapping.getKey())) continue;
                    ((List)batches.get(paramMapping.getPluginName())).add(paramMapping.getKey());
                }
            }
            for (String pluginName : batches.keySet()) {
                if (!batches.containsKey(pluginName)) continue;
                dataCache.put(pluginName, this.request(pluginName, (ArrayList)batches.get(pluginName)));
            }
            for (Behaviour behaviour : behaviours) {
                HashMap<String, Object> resolvedData = new HashMap<String, Object>();
                resolvedData.put("_behaviour", behaviour);
                resolvedData.put("_eventData", event.getData());
                for (ParamMapping paramMapping : behaviour.getParams()) {
                    HashMap map = (HashMap)dataCache.get(paramMapping.getPluginName());
                    if (map == null) continue;
                    String name = paramMapping.getParamName();
                    String key = paramMapping.getKey();
                    if (map.get(key) == null) continue;
                    resolvedData.put(name, map.get(key));
                }
                this.command(behaviour.getPlugin().getName(), behaviour.getAction(), resolvedData);
            }
        }
        this._dataChannel.trigger(event);
    }

    public Object request(String pluginName, ArrayList<String> keys) {
        if (this._isDestroyed) {
            return null;
        }
        IPlugin targetPlugin = this._plugins.get(pluginName);
        if (targetPlugin == null || keys == null || keys.size() == 0) {
            return null;
        }
        return targetPlugin.resolveData(keys);
    }

    public void raise(ErrorInfo errorInfo) {
        this._errorInfo = errorInfo;
        Event event = new Event("error", errorInfo);
        this._ctrlChannel.trigger(event);
    }

    public ErrorInfo getErrorInfo() {
        return this._errorInfo;
    }

    public void destroy() {
        this._isDestroyed = true;
        for (IPlugin plugin : this._plugins.values()) {
            plugin.destroy();
        }
        this._radio.shutdown();
    }

    public void comply(IPlugin plugin, String cmd, ICallback handler) {
        this._dataChannel.comply(plugin.getName() + ":" + cmd, handler);
    }

    public void command(String pluginName, String cmd, Object data) {
        this._dataChannel.command(pluginName + ":" + cmd, data);
    }

    public void registerBehaviour(Trigger trigger, IPlugin plugin, String action, ArrayList<ParamMapping> params) {
        String eventName = trigger.getName();
        Behaviour behaviour = new Behaviour(trigger, plugin, action, params);
        if (!this._behaviours.containsKey(eventName)) {
            this._behaviours.put(eventName, new ArrayList());
        }
        this._behaviours.get(eventName).add(behaviour);
    }
}

