/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core;

import com.mux.stats.sdk.core.CoreView;
import com.mux.stats.sdk.core.MuxSDKViewOrientation;
import com.mux.stats.sdk.core.events.EventBus;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.RedispatchEventListener;
import com.mux.stats.sdk.core.events.TrackableEvent;
import com.mux.stats.sdk.core.events.data.DataEvent;
import com.mux.stats.sdk.core.events.playback.IPlaybackEvent;
import com.mux.stats.sdk.core.events.playback.OrientationChangeEvent;
import com.mux.stats.sdk.core.model.CustomerPlayerData;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.model.ViewDeviceOrientationData;
import com.mux.stats.sdk.core.trackers.BeaconBatchTracker;
import com.mux.stats.sdk.core.util.MuxLogger;
import com.mux.stats.sdk.core.util.UUID;

public class CorePlayer
extends EventBus {
    private PlayerData playerData = new PlayerData();
    private CustomerPlayerData customerPlayerData = new CustomerPlayerData();
    private CoreView view;
    private int playerSequenceNumber = 0;
    private BeaconBatchTracker beaconDispatcher;
    MuxSDKViewOrientation orientation;

    public CorePlayer(boolean sentryEnabled) {
        this.beaconDispatcher = new BeaconBatchTracker(sentryEnabled);
        this.playerData.setPlayerInstanceId(UUID.generateUUID());
    }

    private void handlePlaybackEvent(IPlaybackEvent playbackEvent) {
        this.playerData.update(playbackEvent.getPlayerData());
        if (playbackEvent.getType() == "viewinit") {
            if (this.view != null) {
                this.view.removeAllListeners();
            }
            this.view = new CoreView();
            this.view.addListener(new RedispatchEventListener(this));
        }
    }

    private void handleTrackableEvent(TrackableEvent trackableEvent) {
        this.playerData.update(trackableEvent.getPlayerData());
        this.playerData.setPlayerSequenceNumber(++this.playerSequenceNumber);
        trackableEvent.setPlayerData(this.playerData);
        trackableEvent.setCustomerPlayerData(this.customerPlayerData);
    }

    private void handleDataEvent(DataEvent event) {
        this.customerPlayerData.update(event.getCustomerPlayerData());
    }

    @Override
    public synchronized void dispatch(IEvent event) {
        if (event.isTrackable()) {
            this.handleTrackableEvent((TrackableEvent)event);
            super.dispatch(event);
        } else if (event.isError()) {
            super.dispatch(event);
        } else if (event.isPlayback() || event.isData()) {
            if (event.isPlayback()) {
                this.handlePlaybackEvent((IPlaybackEvent)event);
            } else {
                this.handleDataEvent((DataEvent)event);
            }
            if (this.view != null) {
                this.view.dispatch(event);
            }
        }
    }

    public void handle(IEvent event) {
        this.beaconDispatcher.handle(event);
    }

    public void allowLogcatOutput(boolean allow, boolean verbose) {
        MuxLogger.setAllowLogcat(allow);
        this.beaconDispatcher.setVerboseMode(verbose);
    }

    public void dispatchOrientationChange(MuxSDKViewOrientation orientation) {
        this.orientation = orientation;
        ViewDeviceOrientationData orientationData = new ViewDeviceOrientationData();
        orientationData.setOrientationX(0);
        orientationData.setOrientationY(0);
        switch (orientation) {
            case PORTRAIT: {
                orientationData.setOrientationZ(90);
                break;
            }
            case LANDSCAPE: {
                orientationData.setOrientationZ(0);
                break;
            }
            default: {
                return;
            }
        }
        ViewData viewData = new ViewData();
        viewData.setViewerOrientationData(orientationData);
        OrientationChangeEvent orientationEvent = new OrientationChangeEvent(this.playerData);
        orientationEvent.setViewData(viewData);
        this.dispatch(orientationEvent);
    }

    @Override
    public void flush() {
        this.beaconDispatcher.flush();
    }
}

