/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.smoothstreaming;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.source.SequenceableLoader;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.source.chunk.ChunkSampleStream;
import com.akamai.amp.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.akamai.amp.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.LoaderErrorThrower;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class SsMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<SsChunkSource>> {
    private final SsChunkSource.Factory chunkSourceFactory;
    @Nullable
    private final TransferListener transferListener;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final DrmSessionManager drmSessionManager;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    @Nullable
    private MediaPeriod.Callback callback;
    private SsManifest manifest;
    private ChunkSampleStream<SsChunkSource>[] sampleStreams;
    private SequenceableLoader compositeSequenceableLoader;

    public SsMediaPeriod(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, @Nullable TransferListener transferListener, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator) {
        this.manifest = manifest;
        this.chunkSourceFactory = chunkSourceFactory;
        this.transferListener = transferListener;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.trackGroups = SsMediaPeriod.buildTrackGroups(manifest, drmSessionManager);
        this.sampleStreams = SsMediaPeriod.newSampleStreamArray(0);
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
    }

    public void updateManifest(SsManifest manifest) {
        this.manifest = manifest;
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.getChunkSource().updateManifest(manifest);
        }
        this.callback.onContinueLoadingRequested(this);
    }

    public void release() {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release();
        }
        this.callback = null;
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        callback.onPrepared(this);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    @Override
    public long selectTracks(@NullableType TrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        ArrayList<ChunkSampleStream<SsChunkSource>> sampleStreamsList = new ArrayList<ChunkSampleStream<SsChunkSource>>();
        for (int i = 0; i < selections.length; ++i) {
            ChunkSampleStream<SsChunkSource> stream;
            if (streams[i] != null) {
                stream = (ChunkSampleStream<SsChunkSource>)streams[i];
                if (selections[i] == null || !mayRetainStreamFlags[i]) {
                    stream.release();
                    streams[i] = null;
                } else {
                    ((SsChunkSource)stream.getChunkSource()).updateTrackSelection(selections[i]);
                    sampleStreamsList.add(stream);
                }
            }
            if (streams[i] != null || selections[i] == null) continue;
            stream = this.buildSampleStream(selections[i], positionUs);
            sampleStreamsList.add(stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        this.sampleStreams = SsMediaPeriod.newSampleStreamArray(sampleStreamsList.size());
        sampleStreamsList.toArray(this.sampleStreams);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    @Override
    public List<StreamKey> getStreamKeys(List<TrackSelection> trackSelections) {
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        for (int selectionIndex = 0; selectionIndex < trackSelections.size(); ++selectionIndex) {
            TrackSelection trackSelection = trackSelections.get(selectionIndex);
            int streamElementIndex = this.trackGroups.indexOf(trackSelection.getTrackGroup());
            for (int i = 0; i < trackSelection.length(); ++i) {
                streamKeys.add(new StreamKey(streamElementIndex, trackSelection.getIndexInTrackGroup(i)));
            }
        }
        return streamKeys;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardBuffer(positionUs, toKeyframe);
        }
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    @Override
    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    @Override
    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            if (sampleStream.primaryTrackType != 2) continue;
            return sampleStream.getAdjustedSeekPositionUs(positionUs, seekParameters);
        }
        return positionUs;
    }

    @Override
    public void onContinueLoadingRequested(ChunkSampleStream<SsChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested(this);
    }

    private ChunkSampleStream<SsChunkSource> buildSampleStream(TrackSelection selection, long positionUs) {
        int streamElementIndex = this.trackGroups.indexOf(selection.getTrackGroup());
        SsChunkSource chunkSource = this.chunkSourceFactory.createChunkSource(this.manifestLoaderErrorThrower, this.manifest, streamElementIndex, selection, this.transferListener);
        return new ChunkSampleStream<SsChunkSource>(this.manifest.streamElements[streamElementIndex].type, null, null, chunkSource, this, this.allocator, positionUs, this.drmSessionManager, this.drmEventDispatcher, this.loadErrorHandlingPolicy, this.mediaSourceEventDispatcher);
    }

    private static TrackGroupArray buildTrackGroups(SsManifest manifest, DrmSessionManager drmSessionManager) {
        TrackGroup[] trackGroups = new TrackGroup[manifest.streamElements.length];
        for (int i = 0; i < manifest.streamElements.length; ++i) {
            Format[] manifestFormats = manifest.streamElements[i].formats;
            Format[] exposedFormats = new Format[manifestFormats.length];
            for (int j = 0; j < manifestFormats.length; ++j) {
                Format manifestFormat = manifestFormats[j];
                exposedFormats[j] = manifestFormat.copyWithExoMediaCryptoType(drmSessionManager.getExoMediaCryptoType(manifestFormat));
            }
            trackGroups[i] = new TrackGroup(exposedFormats);
        }
        return new TrackGroupArray(trackGroups);
    }

    private static ChunkSampleStream<SsChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }
}

