/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.CompositeMediaSource;
import com.akamai.amp.exoplayer2.source.ForwardingTimeline;
import com.akamai.amp.exoplayer2.source.MaskingMediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class MaskingMediaSource
extends CompositeMediaSource<Void> {
    private final MediaSource mediaSource;
    private final boolean useLazyPreparation;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private MaskingTimeline timeline;
    @Nullable
    private MaskingMediaPeriod unpreparedMaskingMediaPeriod;
    private boolean hasStartedPreparing;
    private boolean isPrepared;
    private boolean hasRealTimeline;

    public MaskingMediaSource(MediaSource mediaSource, boolean useLazyPreparation) {
        this.mediaSource = mediaSource;
        this.useLazyPreparation = useLazyPreparation && mediaSource.isSingleWindow();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        Timeline initialTimeline = mediaSource.getInitialTimeline();
        if (initialTimeline != null) {
            this.timeline = MaskingTimeline.createWithRealTimeline(initialTimeline, null, null);
            this.hasRealTimeline = true;
        } else {
            this.timeline = MaskingTimeline.createWithPlaceholderTimeline(mediaSource.getMediaItem());
        }
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    @Override
    public void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        if (!this.useLazyPreparation) {
            this.hasStartedPreparing = true;
            this.prepareChildSource(null, this.mediaSource);
        }
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.mediaSource.getTag();
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSource.getMediaItem();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MaskingMediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MaskingMediaPeriod mediaPeriod = new MaskingMediaPeriod(id, allocator, startPositionUs);
        mediaPeriod.setMediaSource(this.mediaSource);
        if (this.isPrepared) {
            MediaSource.MediaPeriodId idInSource = id.copyWithPeriodUid(this.getInternalPeriodUid(id.periodUid));
            mediaPeriod.createPeriod(idInSource);
        } else {
            this.unpreparedMaskingMediaPeriod = mediaPeriod;
            if (!this.hasStartedPreparing) {
                this.hasStartedPreparing = true;
                this.prepareChildSource(null, this.mediaSource);
            }
        }
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((MaskingMediaPeriod)mediaPeriod).releasePeriod();
        if (mediaPeriod == this.unpreparedMaskingMediaPeriod) {
            this.unpreparedMaskingMediaPeriod = null;
        }
    }

    @Override
    public void releaseSourceInternal() {
        this.isPrepared = false;
        this.hasStartedPreparing = false;
        super.releaseSourceInternal();
    }

    @Override
    protected void onChildSourceInfoRefreshed(Void id, MediaSource mediaSource, Timeline newTimeline) {
        MediaSource.MediaPeriodId idForMaskingPeriodPreparation = null;
        if (this.isPrepared) {
            this.timeline = this.timeline.cloneWithUpdatedTimeline(newTimeline);
            if (this.unpreparedMaskingMediaPeriod != null) {
                this.setPreparePositionOverrideToUnpreparedMaskingPeriod(this.unpreparedMaskingMediaPeriod.getPreparePositionOverrideUs());
            }
        } else if (newTimeline.isEmpty()) {
            this.timeline = this.hasRealTimeline ? this.timeline.cloneWithUpdatedTimeline(newTimeline) : MaskingTimeline.createWithRealTimeline(newTimeline, Timeline.Window.SINGLE_WINDOW_UID, MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID);
        } else {
            long periodPreparePositionUs;
            newTimeline.getWindow(0, this.window);
            long windowStartPositionUs = this.window.getDefaultPositionUs();
            if (this.unpreparedMaskingMediaPeriod != null && (periodPreparePositionUs = this.unpreparedMaskingMediaPeriod.getPreparePositionUs()) != 0L) {
                windowStartPositionUs = periodPreparePositionUs;
            }
            Object windowUid = this.window.uid;
            Pair<Object, Long> periodPosition = newTimeline.getPeriodPosition(this.window, this.period, 0, windowStartPositionUs);
            Object periodUid = periodPosition.first;
            long periodPositionUs = (Long)periodPosition.second;
            MaskingTimeline maskingTimeline = this.timeline = this.hasRealTimeline ? this.timeline.cloneWithUpdatedTimeline(newTimeline) : MaskingTimeline.createWithRealTimeline(newTimeline, windowUid, periodUid);
            if (this.unpreparedMaskingMediaPeriod != null) {
                MaskingMediaPeriod maskingPeriod = this.unpreparedMaskingMediaPeriod;
                this.setPreparePositionOverrideToUnpreparedMaskingPeriod(periodPositionUs);
                idForMaskingPeriodPreparation = maskingPeriod.id.copyWithPeriodUid(this.getInternalPeriodUid(maskingPeriod.id.periodUid));
            }
        }
        this.hasRealTimeline = true;
        this.isPrepared = true;
        this.refreshSourceInfo(this.timeline);
        if (idForMaskingPeriodPreparation != null) {
            Assertions.checkNotNull(this.unpreparedMaskingMediaPeriod).createPeriod(idForMaskingPeriodPreparation);
        }
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Void id, MediaSource.MediaPeriodId mediaPeriodId) {
        return mediaPeriodId.copyWithPeriodUid(this.getExternalPeriodUid(mediaPeriodId.periodUid));
    }

    private Object getInternalPeriodUid(Object externalPeriodUid) {
        return this.timeline.replacedInternalPeriodUid != null && externalPeriodUid.equals(MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID) ? this.timeline.replacedInternalPeriodUid : externalPeriodUid;
    }

    private Object getExternalPeriodUid(Object internalPeriodUid) {
        return this.timeline.replacedInternalPeriodUid != null && this.timeline.replacedInternalPeriodUid.equals(internalPeriodUid) ? MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID : internalPeriodUid;
    }

    @RequiresNonNull(value={"unpreparedMaskingMediaPeriod"})
    private void setPreparePositionOverrideToUnpreparedMaskingPeriod(long preparePositionOverrideUs) {
        MaskingMediaPeriod maskingPeriod = this.unpreparedMaskingMediaPeriod;
        int maskingPeriodIndex = this.timeline.getIndexOfPeriod(maskingPeriod.id.periodUid);
        if (maskingPeriodIndex == -1) {
            return;
        }
        long periodDurationUs = this.timeline.getPeriod((int)maskingPeriodIndex, (Timeline.Period)this.period).durationUs;
        if (periodDurationUs != -9223372036854775807L && preparePositionOverrideUs >= periodDurationUs) {
            preparePositionOverrideUs = Math.max(0L, periodDurationUs - 1L);
        }
        maskingPeriod.overridePreparePositionUs(preparePositionOverrideUs);
    }

    private static final class MaskingTimeline
    extends ForwardingTimeline {
        public static final Object MASKING_EXTERNAL_PERIOD_UID = new Object();
        @Nullable
        private final Object replacedInternalWindowUid;
        @Nullable
        private final Object replacedInternalPeriodUid;

        public static MaskingTimeline createWithPlaceholderTimeline(MediaItem mediaItem) {
            return new MaskingTimeline(new PlaceholderTimeline(mediaItem), Timeline.Window.SINGLE_WINDOW_UID, MASKING_EXTERNAL_PERIOD_UID);
        }

        public static MaskingTimeline createWithRealTimeline(Timeline timeline, @Nullable Object firstWindowUid, @Nullable Object firstPeriodUid) {
            return new MaskingTimeline(timeline, firstWindowUid, firstPeriodUid);
        }

        private MaskingTimeline(Timeline timeline, @Nullable Object replacedInternalWindowUid, @Nullable Object replacedInternalPeriodUid) {
            super(timeline);
            this.replacedInternalWindowUid = replacedInternalWindowUid;
            this.replacedInternalPeriodUid = replacedInternalPeriodUid;
        }

        public MaskingTimeline cloneWithUpdatedTimeline(Timeline timeline) {
            return new MaskingTimeline(timeline, this.replacedInternalWindowUid, this.replacedInternalPeriodUid);
        }

        public Timeline getTimeline() {
            return this.timeline;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            this.timeline.getWindow(windowIndex, window, defaultPositionProjectionUs);
            if (Util.areEqual(window.uid, this.replacedInternalWindowUid)) {
                window.uid = Timeline.Window.SINGLE_WINDOW_UID;
            }
            return window;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            this.timeline.getPeriod(periodIndex, period, setIds);
            if (Util.areEqual(period.uid, this.replacedInternalPeriodUid) && setIds) {
                period.uid = MASKING_EXTERNAL_PERIOD_UID;
            }
            return period;
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return this.timeline.getIndexOfPeriod(MASKING_EXTERNAL_PERIOD_UID.equals(uid) && this.replacedInternalPeriodUid != null ? this.replacedInternalPeriodUid : uid);
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            Object uid = this.timeline.getUidOfPeriod(periodIndex);
            return Util.areEqual(uid, this.replacedInternalPeriodUid) ? MASKING_EXTERNAL_PERIOD_UID : uid;
        }
    }

    @VisibleForTesting
    public static final class PlaceholderTimeline
    extends Timeline {
        private final MediaItem mediaItem;

        public PlaceholderTimeline(MediaItem mediaItem) {
            this.mediaItem = mediaItem;
        }

        @Override
        public int getWindowCount() {
            return 1;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            window.set(Timeline.Window.SINGLE_WINDOW_UID, this.mediaItem, null, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, false, true, false, 0L, -9223372036854775807L, 0, 0, 0L);
            window.isPlaceholder = true;
            return window;
        }

        @Override
        public int getPeriodCount() {
            return 1;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            return period.set(setIds ? Integer.valueOf(0) : null, setIds ? MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID : null, 0, -9223372036854775807L, 0L);
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return uid == MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID ? 0 : -1;
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            return MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID;
        }
    }
}

