/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements;

import com.akamai.amp.media.elements.DRMKey;
import com.akamai.amp.media.elements.Source;
import com.akamai.amp.media.elements.Track;
import java.util.List;

public class Media {
    public static final String HLS_TYPE = "application/x-mpegURL";
    public static final String MP4_TYPE = "video/mp4";
    private String title;
    private String poster;
    private List<Source> source;
    private List<Track> track;
    private List<DRMKey> drmKeys;
    private String metadata;
    private Integer duration;

    public Media() {
    }

    public Media(String title, String poster, List<Source> source, List<Track> track, String metadata, int duration) {
        this.title = title;
        this.poster = poster;
        this.source = source;
        this.track = track;
        this.metadata = metadata;
        this.duration = duration;
    }

    public boolean isDAI() {
        if (this.source != null && this.source.size() != 0) {
            for (Source src : this.source) {
                if (src.getAssetKey() == null && src.getVideoID() == null && src.getContentSourceID() == null) continue;
                return true;
            }
        }
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPoster() {
        return this.poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public List<Source> getSource() {
        return this.source;
    }

    public void setSource(List<Source> source) {
        this.source = source;
    }

    public List<Track> getTrack() {
        return this.track;
    }

    public void setTrack(List<Track> track) {
        this.track = track;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public List<DRMKey> getDrmKeys() {
        return this.drmKeys;
    }

    public void setDrmKeys(List<DRMKey> drmKeys) {
        this.drmKeys = drmKeys;
    }
}

