/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import androidx.annotation.IntRange;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

final class BatchBuffer
extends DecoderInputBuffer {
    public static final int DEFAULT_BATCH_SIZE_ACCESS_UNITS = 32;
    private static final int BATCH_SIZE_BYTES = 0x2EE000;
    private final DecoderInputBuffer nextAccessUnitBuffer = new DecoderInputBuffer(2);
    private boolean hasPendingAccessUnit;
    private long firstAccessUnitTimeUs;
    private int accessUnitCount;
    private int maxAccessUnitCount;

    public BatchBuffer() {
        super(2);
        this.clear();
    }

    public void setMaxAccessUnitCount(@IntRange(from=1L) int maxAccessUnitCount) {
        Assertions.checkArgument(maxAccessUnitCount > 0);
        this.maxAccessUnitCount = maxAccessUnitCount;
    }

    public int getMaxAccessUnitCount() {
        return this.maxAccessUnitCount;
    }

    @Override
    public void clear() {
        this.flush();
        this.maxAccessUnitCount = 32;
    }

    public void flush() {
        this.clearMainBuffer();
        this.nextAccessUnitBuffer.clear();
        this.hasPendingAccessUnit = false;
    }

    public void batchWasConsumed() {
        this.clearMainBuffer();
        if (this.hasPendingAccessUnit) {
            this.putAccessUnit(this.nextAccessUnitBuffer);
            this.hasPendingAccessUnit = false;
        }
    }

    public DecoderInputBuffer getNextAccessUnitBuffer() {
        return this.nextAccessUnitBuffer;
    }

    public long getFirstAccessUnitTimeUs() {
        return this.firstAccessUnitTimeUs;
    }

    public long getLastAccessUnitTimeUs() {
        return this.timeUs;
    }

    public int getAccessUnitCount() {
        return this.accessUnitCount;
    }

    public boolean isEmpty() {
        return this.accessUnitCount == 0;
    }

    public boolean isFull() {
        return this.accessUnitCount >= this.maxAccessUnitCount || this.data != null && this.data.position() >= 0x2EE000 || this.hasPendingAccessUnit;
    }

    public void commitNextAccessUnit() {
        DecoderInputBuffer accessUnit = this.nextAccessUnitBuffer;
        Assertions.checkState(!this.isFull() && !this.isEndOfStream());
        Assertions.checkArgument(!accessUnit.isEncrypted() && !accessUnit.hasSupplementalData());
        if (!this.canBatch(accessUnit)) {
            this.hasPendingAccessUnit = true;
            return;
        }
        this.putAccessUnit(accessUnit);
    }

    private boolean canBatch(DecoderInputBuffer accessUnit) {
        if (this.isEmpty()) {
            return true;
        }
        if (accessUnit.isDecodeOnly() != this.isDecodeOnly()) {
            return false;
        }
        ByteBuffer accessUnitData = accessUnit.data;
        return accessUnitData == null || this.data == null || this.data.position() + accessUnitData.limit() < 0x2EE000;
    }

    private void putAccessUnit(DecoderInputBuffer accessUnit) {
        if (accessUnit.isEndOfStream()) {
            this.setFlags(4);
        } else {
            ByteBuffer accessUnitData;
            this.timeUs = accessUnit.timeUs;
            if (accessUnit.isDecodeOnly()) {
                this.setFlags(Integer.MIN_VALUE);
            }
            if (accessUnit.isKeyFrame()) {
                this.setFlags(1);
            }
            if ((accessUnitData = accessUnit.data) != null) {
                accessUnit.flip();
                this.ensureSpaceForWrite(accessUnitData.remaining());
                this.data.put(accessUnitData);
            }
            ++this.accessUnitCount;
            if (this.accessUnitCount == 1) {
                this.firstAccessUnitTimeUs = this.timeUs;
            }
        }
        accessUnit.clear();
    }

    private void clearMainBuffer() {
        super.clear();
        this.accessUnitCount = 0;
        this.firstAccessUnitTimeUs = -9223372036854775807L;
        this.timeUs = -9223372036854775807L;
    }
}

