/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import com.akamai.amp.utils.LogManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Utils {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_UTC_TIMEZONE = "UTC";
    private static final int MIN_URL_LEN = 4;
    private static final String TAG = "Utils";

    public static String toTimestamp(String UTCDate, String dateFormat) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.getDefault());
            TimeZone utc = TimeZone.getTimeZone(DEFAULT_UTC_TIMEZONE);
            sdf.setTimeZone(utc);
            return sdf.parse(UTCDate).toString();
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    public static String toDateString(long timestamp, String dateFormat) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.getDefault());
            TimeZone utc = TimeZone.getTimeZone(DEFAULT_UTC_TIMEZONE);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timestamp);
            calendar.add(14, utc.getOffset(calendar.getTimeInMillis()));
            sdf.setTimeZone(utc);
            return sdf.format(calendar.getTime());
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    public static String getDefaultUserAgent() {
        return String.format("%s (%s; %s; %s; %s)", "Akamai AMP SDK Android", "9.10.7", Build.VERSION.RELEASE, Build.DEVICE, Build.CPU_ABI);
    }

    public static String getDeviceInfo() {
        try {
            return "\nMODEL: " + Build.MODEL + "\nDEVICE: " + Build.DEVICE + "\nBRAND: " + Build.BRAND + "\nRELEASE: " + Build.VERSION.RELEASE + "\nVERSION: " + Build.VERSION_CODES.class.getFields()[Build.VERSION.SDK_INT].getName() + "\nDISPLAY: " + Build.DISPLAY + "\nBOARD: " + Build.BOARD + "\nHOST: " + Build.HOST + "\nMANUFACTURER: " + Build.MANUFACTURER + "\nPRODUCT: " + Build.PRODUCT + "\nDefaultUserAgent: " + Utils.getDefaultUserAgent();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static final String getCodeFromStreamUrl(String sInUrl) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sInUrl.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String h = Integer.toHexString(0xFF & messageDigest[i]);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static final String getDeviceId(Context context) {
        String androidId;
        ContentResolver contentResolver;
        String sDeviceId = "Unknown";
        if (context != null && (contentResolver = context.getContentResolver()) != null && ((sDeviceId = Settings.Secure.getString((ContentResolver)contentResolver, (String)(androidId = "android_id"))) == null || sDeviceId.length() == 0)) {
            sDeviceId = Settings.System.getString((ContentResolver)contentResolver, (String)androidId);
        }
        return sDeviceId;
    }

    public static final boolean equalDatesSecondLevel(Date a, Date b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getSeconds() == b.getSeconds() && a.getMinutes() == b.getMinutes() && a.getHours() == b.getHours() && a.getDay() == b.getDay() && a.getMonth() == b.getMonth() && a.getYear() == b.getYear();
    }

    public static String makeAbsoluteUrl(String baseUrl, String relativeUrl) {
        String out;
        int baseLen;
        if (relativeUrl.startsWith("http://")) {
            return relativeUrl;
        }
        if (relativeUrl.startsWith("https://")) {
            return relativeUrl;
        }
        if (!(baseUrl.startsWith("http://") || baseUrl.startsWith("https://") || baseUrl.startsWith("file://"))) {
            Log.e((String)TAG, (String)("makeItemUrl: invalid base URL: " + baseUrl));
            return null;
        }
        if (relativeUrl.length() < 4) {
            Log.e((String)TAG, (String)("makeAbsoluteUrl: invalid URL: " + relativeUrl));
            return null;
        }
        if (baseUrl.contains("?")) {
            baseUrl = baseUrl.substring(0, baseUrl.indexOf(63));
        }
        if (baseUrl.charAt((baseLen = baseUrl.length()) - 1) == '/') {
            out = baseUrl + relativeUrl;
        } else {
            int slashPos = baseUrl.lastIndexOf(47);
            if (relativeUrl.charAt(0) == '/') {
                int slashslash = baseUrl.indexOf("//") + 2;
                String domain = baseUrl.substring(0, baseUrl.indexOf(47, slashslash));
                out = domain + relativeUrl;
            } else {
                out = slashPos > 6 ? baseUrl.substring(0, slashPos) + "/" + relativeUrl : baseUrl + "/" + relativeUrl;
            }
        }
        return out;
    }

    public static boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static final boolean isAndroid30_orAbove() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static final boolean isAndroid31_orAbove() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static final boolean isAndroid40_orAbove() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static final boolean isAndroid41_orAbove() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static final boolean isAndroid6_orAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static final boolean isFireTV(Context c) {
        String AMAZON_FEATURE_FIRE_TV = "amazon.hardware.fire_tv";
        boolean result = c.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
        return result;
    }

    public static String getPlatform(Context c) {
        if (Utils.isFireTV(c)) {
            return "FireTV";
        }
        if (Utils.isTelevision(c)) {
            return "AndroidTV";
        }
        if (Utils.isTablet(c)) {
            return "Android Tablet";
        }
        return "Android Mobile";
    }

    private static boolean isTablet(Context c) {
        if (c instanceof Activity) {
            Activity activity = (Activity)c;
            WindowManager windowManager = activity.getWindowManager();
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            float widthInches = (float)metrics.widthPixels / metrics.xdpi;
            float heightInches = (float)metrics.heightPixels / metrics.ydpi;
            double diagonalInches = Math.sqrt(Math.pow(widthInches, 2.0) + Math.pow(heightInches, 2.0));
            boolean result = diagonalInches >= 7.0;
            return result;
        }
        return false;
    }

    @TargetApi(value=13)
    private static boolean isTelevision(Context c) {
        int uiMode = c.getResources().getConfiguration().uiMode;
        return (uiMode & 0xF) == 4;
    }

    public static final boolean isNonStandardHost(String url) {
        return url.contains("_");
    }

    public static final boolean isHTTPS(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith("https");
    }

    public static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
    }

    public static String getApplicationVersion(Context context) {
        try {
            String packageName = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            String version = packageInfo.versionName;
            return version;
        }
        catch (Throwable throwable) {
            return UNKNOWN;
        }
    }

    public static final URL setIPasHost(URL url) throws Exception {
        try {
            InetAddress addr = InetAddress.getByName(url.getHost());
            return new URL(url.toString().replace(url.getHost(), addr.getHostAddress()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error resolving IP address from URL: " + url));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getLogLines() {
        Process mLogcatProc = null;
        BufferedReader reader = null;
        StringBuilder log = new StringBuilder();
        try {
            String line;
            mLogcatProc = Runtime.getRuntime().exec(new String[]{"logcat", "-d", "AndroidRuntime:E AkamaiPlayer:V *:S"});
            reader = new BufferedReader(new InputStreamReader(mLogcatProc.getInputStream()));
            String separator = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                log.append(line);
                log.append(separator);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return log.toString();
    }

    public static final void resetLog() {
        try {
            Runtime.getRuntime().exec(new String[]{"logcat", "-c"});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public static String getFieldName(String className, String fieldName) {
        try {
            Class<?> c = Class.forName(className);
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                try {
                    Object o = f.get(null);
                    String value = (String)o;
                    return value;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void checkModuleVersion(String moduleName, String moduleVersion) {
        String coreVersion = "9.10.7";
        boolean sameVersion = coreVersion.equals(moduleVersion);
        if (!sameVersion) {
            String message = String.format("WARNING: AMP Module Mismatch, module %s is using version %s, while the AMP core is using version %s", moduleName, moduleVersion, coreVersion);
            LogManager.error("Akamai AMP SDK Android", message);
        }
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T extends Collection> T requireNonEmpty(T collection) {
        Utils.requireNonNull(collection);
        if (collection.isEmpty()) {
            throw new IllegalStateException("The Collection must not be empty");
        }
        return collection;
    }

    public static void tryRemoveFromParent(View view) {
        if (view == null) {
            return;
        }
        ViewParent parent = view.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            viewGroup.removeView(view);
        }
    }

    public static int getNextIndex(ViewGroup view) {
        return view.getChildCount();
    }

    public static List<String> emptyListIfNull(List<String> list) {
        if (list == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(list);
    }

    public static void printChildren(ViewGroup vg, String LOG_TAG, String from) {
        if (vg == null) {
            return;
        }
        int childCount = vg.getChildCount();
        LogManager.log(LOG_TAG, from + " / " + childCount + " children of " + vg);
        for (int i = 0; i < childCount; ++i) {
            View child = vg.getChildAt(i);
            LogManager.log(LOG_TAG, i + ": " + child);
        }
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        long result = timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
        return result;
    }

    public static int getDeviceVolume(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            double volume = audioManager.getStreamVolume(3);
            double max = audioManager.getStreamMaxVolume(3);
            if (max <= 0.0) {
                return 0;
            }
            return (int)(volume / max * 100.0);
        }
        return 0;
    }

    public static UUID generateSessionId() {
        return UUID.randomUUID();
    }

    public static class Time {
        public static long getSecondsSinceMidnightInLocalTimeZone() {
            Calendar c = Calendar.getInstance();
            return Time.getSecondsSinceMidnight(c);
        }

        public static long getSecondsSinceMidnight(TimeZone tz) {
            Calendar c = Time.getCalendarInstance(tz);
            return Time.getSecondsSinceMidnight(c);
        }

        private static Calendar getCalendarInstance(TimeZone tz) {
            if (tz == null) {
                return Calendar.getInstance();
            }
            return Calendar.getInstance(tz);
        }

        private static long getSecondsSinceMidnight(Calendar c) {
            long now = c.getTimeInMillis();
            Time.setMidnight(c);
            long passed = now - c.getTimeInMillis();
            long secondsPassed = passed / 1000L;
            return secondsPassed;
        }

        private static void setMidnight(Calendar c) {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
    }
}

