/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.cea;

import android.graphics.Color;
import android.text.Layout;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.text.SubtitleInputBuffer;
import com.akamai.amp.exoplayer2.text.cea.CeaDecoder;
import com.akamai.amp.exoplayer2.text.cea.CeaSubtitle;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.CodecSpecificDataUtil;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.ParsableBitArray;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Cea708Decoder
extends CeaDecoder {
    private static final String TAG = "Cea708Decoder";
    private static final int NUM_WINDOWS = 8;
    private static final int DTVCC_PACKET_DATA = 2;
    private static final int DTVCC_PACKET_START = 3;
    private static final int CC_VALID_FLAG = 4;
    private static final int GROUP_C0_END = 31;
    private static final int GROUP_G0_END = 127;
    private static final int GROUP_C1_END = 159;
    private static final int GROUP_G1_END = 255;
    private static final int GROUP_C2_END = 31;
    private static final int GROUP_G2_END = 127;
    private static final int GROUP_C3_END = 159;
    private static final int GROUP_G3_END = 255;
    private static final int COMMAND_NUL = 0;
    private static final int COMMAND_ETX = 3;
    private static final int COMMAND_BS = 8;
    private static final int COMMAND_FF = 12;
    private static final int COMMAND_CR = 13;
    private static final int COMMAND_HCR = 14;
    private static final int COMMAND_EXT1 = 16;
    private static final int COMMAND_EXT1_START = 17;
    private static final int COMMAND_EXT1_END = 23;
    private static final int COMMAND_P16_START = 24;
    private static final int COMMAND_P16_END = 31;
    private static final int COMMAND_CW0 = 128;
    private static final int COMMAND_CW1 = 129;
    private static final int COMMAND_CW2 = 130;
    private static final int COMMAND_CW3 = 131;
    private static final int COMMAND_CW4 = 132;
    private static final int COMMAND_CW5 = 133;
    private static final int COMMAND_CW6 = 134;
    private static final int COMMAND_CW7 = 135;
    private static final int COMMAND_CLW = 136;
    private static final int COMMAND_DSW = 137;
    private static final int COMMAND_HDW = 138;
    private static final int COMMAND_TGW = 139;
    private static final int COMMAND_DLW = 140;
    private static final int COMMAND_DLY = 141;
    private static final int COMMAND_DLC = 142;
    private static final int COMMAND_RST = 143;
    private static final int COMMAND_SPA = 144;
    private static final int COMMAND_SPC = 145;
    private static final int COMMAND_SPL = 146;
    private static final int COMMAND_SWA = 151;
    private static final int COMMAND_DF0 = 152;
    private static final int COMMAND_DF1 = 153;
    private static final int COMMAND_DF2 = 154;
    private static final int COMMAND_DF3 = 155;
    private static final int COMMAND_DF4 = 156;
    private static final int COMMAND_DF5 = 157;
    private static final int COMMAND_DF6 = 158;
    private static final int COMMAND_DF7 = 159;
    private static final int CHARACTER_MN = 127;
    private static final int CHARACTER_TSP = 32;
    private static final int CHARACTER_NBTSP = 33;
    private static final int CHARACTER_ELLIPSIS = 37;
    private static final int CHARACTER_BIG_CARONS = 42;
    private static final int CHARACTER_BIG_OE = 44;
    private static final int CHARACTER_SOLID_BLOCK = 48;
    private static final int CHARACTER_OPEN_SINGLE_QUOTE = 49;
    private static final int CHARACTER_CLOSE_SINGLE_QUOTE = 50;
    private static final int CHARACTER_OPEN_DOUBLE_QUOTE = 51;
    private static final int CHARACTER_CLOSE_DOUBLE_QUOTE = 52;
    private static final int CHARACTER_BOLD_BULLET = 53;
    private static final int CHARACTER_TM = 57;
    private static final int CHARACTER_SMALL_CARONS = 58;
    private static final int CHARACTER_SMALL_OE = 60;
    private static final int CHARACTER_SM = 61;
    private static final int CHARACTER_DIAERESIS_Y = 63;
    private static final int CHARACTER_ONE_EIGHTH = 118;
    private static final int CHARACTER_THREE_EIGHTHS = 119;
    private static final int CHARACTER_FIVE_EIGHTHS = 120;
    private static final int CHARACTER_SEVEN_EIGHTHS = 121;
    private static final int CHARACTER_VERTICAL_BORDER = 122;
    private static final int CHARACTER_UPPER_RIGHT_BORDER = 123;
    private static final int CHARACTER_LOWER_LEFT_BORDER = 124;
    private static final int CHARACTER_HORIZONTAL_BORDER = 125;
    private static final int CHARACTER_LOWER_RIGHT_BORDER = 126;
    private static final int CHARACTER_UPPER_LEFT_BORDER = 127;
    private final ParsableByteArray ccData = new ParsableByteArray();
    private final ParsableBitArray serviceBlockPacket = new ParsableBitArray();
    private final boolean isWideAspectRatio;
    private final int selectedServiceNumber;
    private final CueInfoBuilder[] cueInfoBuilders;
    private CueInfoBuilder currentCueInfoBuilder;
    @Nullable
    private List<Cue> cues;
    @Nullable
    private List<Cue> lastCues;
    @Nullable
    private DtvCcPacket currentDtvCcPacket;
    private int currentWindow;

    public Cea708Decoder(int accessibilityChannel, @Nullable List<byte[]> initializationData) {
        this.selectedServiceNumber = accessibilityChannel == -1 ? 1 : accessibilityChannel;
        this.isWideAspectRatio = initializationData != null && CodecSpecificDataUtil.parseCea708InitializationData(initializationData);
        this.cueInfoBuilders = new CueInfoBuilder[8];
        for (int i = 0; i < 8; ++i) {
            this.cueInfoBuilders[i] = new CueInfoBuilder();
        }
        this.currentCueInfoBuilder = this.cueInfoBuilders[0];
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public void flush() {
        super.flush();
        this.cues = null;
        this.lastCues = null;
        this.currentWindow = 0;
        this.currentCueInfoBuilder = this.cueInfoBuilders[this.currentWindow];
        this.resetCueBuilders();
        this.currentDtvCcPacket = null;
    }

    @Override
    protected boolean isNewSubtitleDataAvailable() {
        return this.cues != this.lastCues;
    }

    @Override
    protected Subtitle createSubtitle() {
        this.lastCues = this.cues;
        return new CeaSubtitle(Assertions.checkNotNull(this.cues));
    }

    @Override
    protected void decode(SubtitleInputBuffer inputBuffer) {
        ByteBuffer subtitleData = Assertions.checkNotNull(inputBuffer.data);
        byte[] inputBufferData = subtitleData.array();
        this.ccData.reset(inputBufferData, subtitleData.limit());
        while (this.ccData.bytesLeft() >= 3) {
            int ccTypeAndValid = this.ccData.readUnsignedByte() & 7;
            int ccType = ccTypeAndValid & 3;
            boolean ccValid = (ccTypeAndValid & 4) == 4;
            byte ccData1 = (byte)this.ccData.readUnsignedByte();
            byte ccData2 = (byte)this.ccData.readUnsignedByte();
            if (ccType != 2 && ccType != 3 || !ccValid) continue;
            if (ccType == 3) {
                this.finalizeCurrentPacket();
                int sequenceNumber = (ccData1 & 0xC0) >> 6;
                int packetSize = ccData1 & 0x3F;
                if (packetSize == 0) {
                    packetSize = 64;
                }
                this.currentDtvCcPacket = new DtvCcPacket(sequenceNumber, packetSize);
                this.currentDtvCcPacket.packetData[this.currentDtvCcPacket.currentIndex++] = ccData2;
            } else {
                Assertions.checkArgument(ccType == 2);
                if (this.currentDtvCcPacket == null) {
                    Log.e(TAG, "Encountered DTVCC_PACKET_DATA before DTVCC_PACKET_START");
                    continue;
                }
                this.currentDtvCcPacket.packetData[this.currentDtvCcPacket.currentIndex++] = ccData1;
                this.currentDtvCcPacket.packetData[this.currentDtvCcPacket.currentIndex++] = ccData2;
            }
            if (this.currentDtvCcPacket.currentIndex != this.currentDtvCcPacket.packetSize * 2 - 1) continue;
            this.finalizeCurrentPacket();
        }
    }

    private void finalizeCurrentPacket() {
        if (this.currentDtvCcPacket == null) {
            return;
        }
        this.processCurrentPacket();
        this.currentDtvCcPacket = null;
    }

    @RequiresNonNull(value={"currentDtvCcPacket"})
    private void processCurrentPacket() {
        if (this.currentDtvCcPacket.currentIndex != this.currentDtvCcPacket.packetSize * 2 - 1) {
            Log.w(TAG, "DtvCcPacket ended prematurely; size is " + (this.currentDtvCcPacket.packetSize * 2 - 1) + ", but current index is " + this.currentDtvCcPacket.currentIndex + " (sequence number " + this.currentDtvCcPacket.sequenceNumber + "); ignoring packet");
            return;
        }
        this.serviceBlockPacket.reset(this.currentDtvCcPacket.packetData, this.currentDtvCcPacket.currentIndex);
        int serviceNumber = this.serviceBlockPacket.readBits(3);
        int blockSize = this.serviceBlockPacket.readBits(5);
        if (serviceNumber == 7) {
            this.serviceBlockPacket.skipBits(2);
            serviceNumber = this.serviceBlockPacket.readBits(6);
            if (serviceNumber < 7) {
                Log.w(TAG, "Invalid extended service number: " + serviceNumber);
            }
        }
        if (blockSize == 0) {
            if (serviceNumber != 0) {
                Log.w(TAG, "serviceNumber is non-zero (" + serviceNumber + ") when blockSize is 0");
            }
            return;
        }
        if (serviceNumber != this.selectedServiceNumber) {
            return;
        }
        boolean cuesNeedUpdate = false;
        while (this.serviceBlockPacket.bitsLeft() > 0) {
            int command = this.serviceBlockPacket.readBits(8);
            if (command != 16) {
                if (command <= 31) {
                    this.handleC0Command(command);
                    continue;
                }
                if (command <= 127) {
                    this.handleG0Character(command);
                    cuesNeedUpdate = true;
                    continue;
                }
                if (command <= 159) {
                    this.handleC1Command(command);
                    cuesNeedUpdate = true;
                    continue;
                }
                if (command <= 255) {
                    this.handleG1Character(command);
                    cuesNeedUpdate = true;
                    continue;
                }
                Log.w(TAG, "Invalid base command: " + command);
                continue;
            }
            command = this.serviceBlockPacket.readBits(8);
            if (command <= 31) {
                this.handleC2Command(command);
                continue;
            }
            if (command <= 127) {
                this.handleG2Character(command);
                cuesNeedUpdate = true;
                continue;
            }
            if (command <= 159) {
                this.handleC3Command(command);
                continue;
            }
            if (command <= 255) {
                this.handleG3Character(command);
                cuesNeedUpdate = true;
                continue;
            }
            Log.w(TAG, "Invalid extended command: " + command);
        }
        if (cuesNeedUpdate) {
            this.cues = this.getDisplayCues();
        }
    }

    private void handleC0Command(int command) {
        switch (command) {
            case 0: {
                break;
            }
            case 3: {
                this.cues = this.getDisplayCues();
                break;
            }
            case 8: {
                this.currentCueInfoBuilder.backspace();
                break;
            }
            case 12: {
                this.resetCueBuilders();
                break;
            }
            case 13: {
                this.currentCueInfoBuilder.append('\n');
                break;
            }
            case 14: {
                break;
            }
            default: {
                if (command >= 17 && command <= 23) {
                    Log.w(TAG, "Currently unsupported COMMAND_EXT1 Command: " + command);
                    this.serviceBlockPacket.skipBits(8);
                    break;
                }
                if (command >= 24 && command <= 31) {
                    Log.w(TAG, "Currently unsupported COMMAND_P16 Command: " + command);
                    this.serviceBlockPacket.skipBits(16);
                    break;
                }
                Log.w(TAG, "Invalid C0 command: " + command);
            }
        }
    }

    private void handleC1Command(int command) {
        switch (command) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                int window = command - 128;
                if (this.currentWindow == window) break;
                this.currentWindow = window;
                this.currentCueInfoBuilder = this.cueInfoBuilders[window];
                break;
            }
            case 136: {
                for (int i = 1; i <= 8; ++i) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i].clear();
                }
                break;
            }
            case 137: {
                for (int i = 1; i <= 8; ++i) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i].setVisibility(true);
                }
                break;
            }
            case 138: {
                for (int i = 1; i <= 8; ++i) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i].setVisibility(false);
                }
                break;
            }
            case 139: {
                for (int i = 1; i <= 8; ++i) {
                    CueInfoBuilder cueInfoBuilder;
                    if (!this.serviceBlockPacket.readBit()) continue;
                    cueInfoBuilder.setVisibility(!(cueInfoBuilder = this.cueInfoBuilders[8 - i]).isVisible());
                }
                break;
            }
            case 140: {
                for (int i = 1; i <= 8; ++i) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i].reset();
                }
                break;
            }
            case 141: {
                this.serviceBlockPacket.skipBits(8);
                break;
            }
            case 142: {
                break;
            }
            case 143: {
                this.resetCueBuilders();
                break;
            }
            case 144: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(16);
                    break;
                }
                this.handleSetPenAttributes();
                break;
            }
            case 145: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(24);
                    break;
                }
                this.handleSetPenColor();
                break;
            }
            case 146: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(16);
                    break;
                }
                this.handleSetPenLocation();
                break;
            }
            case 151: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(32);
                    break;
                }
                this.handleSetWindowAttributes();
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                int window = command - 152;
                this.handleDefineWindow(window);
                if (this.currentWindow == window) break;
                this.currentWindow = window;
                this.currentCueInfoBuilder = this.cueInfoBuilders[window];
                break;
            }
            default: {
                Log.w(TAG, "Invalid C1 command: " + command);
            }
        }
    }

    private void handleC2Command(int command) {
        if (command > 7) {
            if (command <= 15) {
                this.serviceBlockPacket.skipBits(8);
            } else if (command <= 23) {
                this.serviceBlockPacket.skipBits(16);
            } else if (command <= 31) {
                this.serviceBlockPacket.skipBits(24);
            }
        }
    }

    private void handleC3Command(int command) {
        if (command <= 135) {
            this.serviceBlockPacket.skipBits(32);
        } else if (command <= 143) {
            this.serviceBlockPacket.skipBits(40);
        } else if (command <= 159) {
            this.serviceBlockPacket.skipBits(2);
            int length = this.serviceBlockPacket.readBits(6);
            this.serviceBlockPacket.skipBits(8 * length);
        }
    }

    private void handleG0Character(int characterCode) {
        if (characterCode == 127) {
            this.currentCueInfoBuilder.append('\u266b');
        } else {
            this.currentCueInfoBuilder.append((char)(characterCode & 0xFF));
        }
    }

    private void handleG1Character(int characterCode) {
        this.currentCueInfoBuilder.append((char)(characterCode & 0xFF));
    }

    private void handleG2Character(int characterCode) {
        switch (characterCode) {
            case 32: {
                this.currentCueInfoBuilder.append(' ');
                break;
            }
            case 33: {
                this.currentCueInfoBuilder.append('\u00a0');
                break;
            }
            case 37: {
                this.currentCueInfoBuilder.append('\u2026');
                break;
            }
            case 42: {
                this.currentCueInfoBuilder.append('\u0160');
                break;
            }
            case 44: {
                this.currentCueInfoBuilder.append('\u0152');
                break;
            }
            case 48: {
                this.currentCueInfoBuilder.append('\u2588');
                break;
            }
            case 49: {
                this.currentCueInfoBuilder.append('\u2018');
                break;
            }
            case 50: {
                this.currentCueInfoBuilder.append('\u2019');
                break;
            }
            case 51: {
                this.currentCueInfoBuilder.append('\u201c');
                break;
            }
            case 52: {
                this.currentCueInfoBuilder.append('\u201d');
                break;
            }
            case 53: {
                this.currentCueInfoBuilder.append('\u2022');
                break;
            }
            case 57: {
                this.currentCueInfoBuilder.append('\u2122');
                break;
            }
            case 58: {
                this.currentCueInfoBuilder.append('\u0161');
                break;
            }
            case 60: {
                this.currentCueInfoBuilder.append('\u0153');
                break;
            }
            case 61: {
                this.currentCueInfoBuilder.append('\u2120');
                break;
            }
            case 63: {
                this.currentCueInfoBuilder.append('\u0178');
                break;
            }
            case 118: {
                this.currentCueInfoBuilder.append('\u215b');
                break;
            }
            case 119: {
                this.currentCueInfoBuilder.append('\u215c');
                break;
            }
            case 120: {
                this.currentCueInfoBuilder.append('\u215d');
                break;
            }
            case 121: {
                this.currentCueInfoBuilder.append('\u215e');
                break;
            }
            case 122: {
                this.currentCueInfoBuilder.append('\u2502');
                break;
            }
            case 123: {
                this.currentCueInfoBuilder.append('\u2510');
                break;
            }
            case 124: {
                this.currentCueInfoBuilder.append('\u2514');
                break;
            }
            case 125: {
                this.currentCueInfoBuilder.append('\u2500');
                break;
            }
            case 126: {
                this.currentCueInfoBuilder.append('\u2518');
                break;
            }
            case 127: {
                this.currentCueInfoBuilder.append('\u250c');
                break;
            }
            default: {
                Log.w(TAG, "Invalid G2 character: " + characterCode);
            }
        }
    }

    private void handleG3Character(int characterCode) {
        if (characterCode == 160) {
            this.currentCueInfoBuilder.append('\u33c4');
        } else {
            Log.w(TAG, "Invalid G3 character: " + characterCode);
            this.currentCueInfoBuilder.append('_');
        }
    }

    private void handleSetPenAttributes() {
        int textTag = this.serviceBlockPacket.readBits(4);
        int offset = this.serviceBlockPacket.readBits(2);
        int penSize = this.serviceBlockPacket.readBits(2);
        boolean italicsToggle = this.serviceBlockPacket.readBit();
        boolean underlineToggle = this.serviceBlockPacket.readBit();
        int edgeType = this.serviceBlockPacket.readBits(3);
        int fontStyle = this.serviceBlockPacket.readBits(3);
        this.currentCueInfoBuilder.setPenAttributes(textTag, offset, penSize, italicsToggle, underlineToggle, edgeType, fontStyle);
    }

    private void handleSetPenColor() {
        int foregroundO = this.serviceBlockPacket.readBits(2);
        int foregroundR = this.serviceBlockPacket.readBits(2);
        int foregroundG = this.serviceBlockPacket.readBits(2);
        int foregroundB = this.serviceBlockPacket.readBits(2);
        int foregroundColor = CueInfoBuilder.getArgbColorFromCeaColor(foregroundR, foregroundG, foregroundB, foregroundO);
        int backgroundO = this.serviceBlockPacket.readBits(2);
        int backgroundR = this.serviceBlockPacket.readBits(2);
        int backgroundG = this.serviceBlockPacket.readBits(2);
        int backgroundB = this.serviceBlockPacket.readBits(2);
        int backgroundColor = CueInfoBuilder.getArgbColorFromCeaColor(backgroundR, backgroundG, backgroundB, backgroundO);
        this.serviceBlockPacket.skipBits(2);
        int edgeR = this.serviceBlockPacket.readBits(2);
        int edgeG = this.serviceBlockPacket.readBits(2);
        int edgeB = this.serviceBlockPacket.readBits(2);
        int edgeColor = CueInfoBuilder.getArgbColorFromCeaColor(edgeR, edgeG, edgeB);
        this.currentCueInfoBuilder.setPenColor(foregroundColor, backgroundColor, edgeColor);
    }

    private void handleSetPenLocation() {
        this.serviceBlockPacket.skipBits(4);
        int row = this.serviceBlockPacket.readBits(4);
        this.serviceBlockPacket.skipBits(2);
        int column = this.serviceBlockPacket.readBits(6);
        this.currentCueInfoBuilder.setPenLocation(row, column);
    }

    private void handleSetWindowAttributes() {
        int fillO = this.serviceBlockPacket.readBits(2);
        int fillR = this.serviceBlockPacket.readBits(2);
        int fillG = this.serviceBlockPacket.readBits(2);
        int fillB = this.serviceBlockPacket.readBits(2);
        int fillColor = CueInfoBuilder.getArgbColorFromCeaColor(fillR, fillG, fillB, fillO);
        int borderType = this.serviceBlockPacket.readBits(2);
        int borderR = this.serviceBlockPacket.readBits(2);
        int borderG = this.serviceBlockPacket.readBits(2);
        int borderB = this.serviceBlockPacket.readBits(2);
        int borderColor = CueInfoBuilder.getArgbColorFromCeaColor(borderR, borderG, borderB);
        if (this.serviceBlockPacket.readBit()) {
            borderType |= 4;
        }
        boolean wordWrapToggle = this.serviceBlockPacket.readBit();
        int printDirection = this.serviceBlockPacket.readBits(2);
        int scrollDirection = this.serviceBlockPacket.readBits(2);
        int justification = this.serviceBlockPacket.readBits(2);
        this.serviceBlockPacket.skipBits(8);
        this.currentCueInfoBuilder.setWindowAttributes(fillColor, borderColor, wordWrapToggle, borderType, printDirection, scrollDirection, justification);
    }

    private void handleDefineWindow(int window) {
        CueInfoBuilder cueInfoBuilder = this.cueInfoBuilders[window];
        this.serviceBlockPacket.skipBits(2);
        boolean visible = this.serviceBlockPacket.readBit();
        boolean rowLock = this.serviceBlockPacket.readBit();
        boolean columnLock = this.serviceBlockPacket.readBit();
        int priority = this.serviceBlockPacket.readBits(3);
        boolean relativePositioning = this.serviceBlockPacket.readBit();
        int verticalAnchor = this.serviceBlockPacket.readBits(7);
        int horizontalAnchor = this.serviceBlockPacket.readBits(8);
        int anchorId = this.serviceBlockPacket.readBits(4);
        int rowCount = this.serviceBlockPacket.readBits(4);
        this.serviceBlockPacket.skipBits(2);
        int columnCount = this.serviceBlockPacket.readBits(6);
        this.serviceBlockPacket.skipBits(2);
        int windowStyle = this.serviceBlockPacket.readBits(3);
        int penStyle = this.serviceBlockPacket.readBits(3);
        cueInfoBuilder.defineWindow(visible, rowLock, columnLock, priority, relativePositioning, verticalAnchor, horizontalAnchor, rowCount, columnCount, anchorId, windowStyle, penStyle);
    }

    private List<Cue> getDisplayCues() {
        ArrayList<Cea708CueInfo> displayCueInfos = new ArrayList<Cea708CueInfo>();
        for (int i = 0; i < 8; ++i) {
            Cea708CueInfo cueInfo;
            if (this.cueInfoBuilders[i].isEmpty() || !this.cueInfoBuilders[i].isVisible() || (cueInfo = this.cueInfoBuilders[i].build()) == null) continue;
            displayCueInfos.add(cueInfo);
        }
        Collections.sort(displayCueInfos, (thisInfo, thatInfo) -> Integer.compare(thisInfo.priority, thatInfo.priority));
        ArrayList<Cue> displayCues = new ArrayList<Cue>(displayCueInfos.size());
        for (int i = 0; i < displayCueInfos.size(); ++i) {
            displayCues.add(((Cea708CueInfo)displayCueInfos.get((int)i)).cue);
        }
        return Collections.unmodifiableList(displayCues);
    }

    private void resetCueBuilders() {
        for (int i = 0; i < 8; ++i) {
            this.cueInfoBuilders[i].reset();
        }
    }

    private static final class CueInfoBuilder {
        private static final int RELATIVE_CUE_SIZE = 99;
        private static final int VERTICAL_SIZE = 74;
        private static final int HORIZONTAL_SIZE = 209;
        private static final int DEFAULT_PRIORITY = 4;
        private static final int MAXIMUM_ROW_COUNT = 15;
        private static final int JUSTIFICATION_LEFT = 0;
        private static final int JUSTIFICATION_RIGHT = 1;
        private static final int JUSTIFICATION_CENTER = 2;
        private static final int JUSTIFICATION_FULL = 3;
        private static final int DIRECTION_LEFT_TO_RIGHT = 0;
        private static final int DIRECTION_RIGHT_TO_LEFT = 1;
        private static final int DIRECTION_TOP_TO_BOTTOM = 2;
        private static final int DIRECTION_BOTTOM_TO_TOP = 3;
        private static final int BORDER_AND_EDGE_TYPE_NONE = 0;
        private static final int BORDER_AND_EDGE_TYPE_UNIFORM = 3;
        public static final int COLOR_SOLID_WHITE = CueInfoBuilder.getArgbColorFromCeaColor(2, 2, 2, 0);
        public static final int COLOR_SOLID_BLACK = CueInfoBuilder.getArgbColorFromCeaColor(0, 0, 0, 0);
        public static final int COLOR_TRANSPARENT = CueInfoBuilder.getArgbColorFromCeaColor(0, 0, 0, 3);
        private static final int PEN_SIZE_STANDARD = 1;
        private static final int PEN_FONT_STYLE_DEFAULT = 0;
        private static final int PEN_FONT_STYLE_MONOSPACED_WITH_SERIFS = 1;
        private static final int PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITH_SERIFS = 2;
        private static final int PEN_FONT_STYLE_MONOSPACED_WITHOUT_SERIFS = 3;
        private static final int PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITHOUT_SERIFS = 4;
        private static final int PEN_OFFSET_NORMAL = 1;
        private static final int[] WINDOW_STYLE_JUSTIFICATION = new int[]{0, 0, 0, 0, 0, 2, 0};
        private static final int[] WINDOW_STYLE_PRINT_DIRECTION = new int[]{0, 0, 0, 0, 0, 0, 2};
        private static final int[] WINDOW_STYLE_SCROLL_DIRECTION = new int[]{3, 3, 3, 3, 3, 3, 1};
        private static final boolean[] WINDOW_STYLE_WORD_WRAP = new boolean[]{false, false, false, true, true, true, false};
        private static final int[] WINDOW_STYLE_FILL = new int[]{COLOR_SOLID_BLACK, COLOR_TRANSPARENT, COLOR_SOLID_BLACK, COLOR_SOLID_BLACK, COLOR_TRANSPARENT, COLOR_SOLID_BLACK, COLOR_SOLID_BLACK};
        private static final int[] PEN_STYLE_FONT_STYLE = new int[]{0, 1, 2, 3, 4, 3, 4};
        private static final int[] PEN_STYLE_EDGE_TYPE = new int[]{0, 0, 0, 0, 0, 3, 3};
        private static final int[] PEN_STYLE_BACKGROUND = new int[]{COLOR_SOLID_BLACK, COLOR_SOLID_BLACK, COLOR_SOLID_BLACK, COLOR_SOLID_BLACK, COLOR_SOLID_BLACK, COLOR_TRANSPARENT, COLOR_TRANSPARENT};
        private final List<SpannableString> rolledUpCaptions = new ArrayList<SpannableString>();
        private final SpannableStringBuilder captionStringBuilder = new SpannableStringBuilder();
        private boolean defined;
        private boolean visible;
        private int priority;
        private boolean relativePositioning;
        private int verticalAnchor;
        private int horizontalAnchor;
        private int anchorId;
        private int rowCount;
        private boolean rowLock;
        private int justification;
        private int windowStyleId;
        private int penStyleId;
        private int windowFillColor;
        private int italicsStartPosition;
        private int underlineStartPosition;
        private int foregroundColorStartPosition;
        private int foregroundColor;
        private int backgroundColorStartPosition;
        private int backgroundColor;
        private int row;

        public CueInfoBuilder() {
            this.reset();
        }

        public boolean isEmpty() {
            return !this.isDefined() || this.rolledUpCaptions.isEmpty() && this.captionStringBuilder.length() == 0;
        }

        public void reset() {
            this.clear();
            this.defined = false;
            this.visible = false;
            this.priority = 4;
            this.relativePositioning = false;
            this.verticalAnchor = 0;
            this.horizontalAnchor = 0;
            this.anchorId = 0;
            this.rowCount = 15;
            this.rowLock = true;
            this.justification = 0;
            this.windowStyleId = 0;
            this.penStyleId = 0;
            this.windowFillColor = COLOR_SOLID_BLACK;
            this.foregroundColor = COLOR_SOLID_WHITE;
            this.backgroundColor = COLOR_SOLID_BLACK;
        }

        public void clear() {
            this.rolledUpCaptions.clear();
            this.captionStringBuilder.clear();
            this.italicsStartPosition = -1;
            this.underlineStartPosition = -1;
            this.foregroundColorStartPosition = -1;
            this.backgroundColorStartPosition = -1;
            this.row = 0;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public void setVisibility(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void defineWindow(boolean visible, boolean rowLock, boolean columnLock, int priority, boolean relativePositioning, int verticalAnchor, int horizontalAnchor, int rowCount, int columnCount, int anchorId, int windowStyleId, int penStyleId) {
            this.defined = true;
            this.visible = visible;
            this.rowLock = rowLock;
            this.priority = priority;
            this.relativePositioning = relativePositioning;
            this.verticalAnchor = verticalAnchor;
            this.horizontalAnchor = horizontalAnchor;
            this.anchorId = anchorId;
            if (this.rowCount != rowCount + 1) {
                this.rowCount = rowCount + 1;
                while (rowLock && this.rolledUpCaptions.size() >= this.rowCount || this.rolledUpCaptions.size() >= 15) {
                    this.rolledUpCaptions.remove(0);
                }
            }
            if (windowStyleId != 0 && this.windowStyleId != windowStyleId) {
                this.windowStyleId = windowStyleId;
                int windowStyleIdIndex = windowStyleId - 1;
                this.setWindowAttributes(WINDOW_STYLE_FILL[windowStyleIdIndex], COLOR_TRANSPARENT, WINDOW_STYLE_WORD_WRAP[windowStyleIdIndex], 0, WINDOW_STYLE_PRINT_DIRECTION[windowStyleIdIndex], WINDOW_STYLE_SCROLL_DIRECTION[windowStyleIdIndex], WINDOW_STYLE_JUSTIFICATION[windowStyleIdIndex]);
            }
            if (penStyleId != 0 && this.penStyleId != penStyleId) {
                this.penStyleId = penStyleId;
                int penStyleIdIndex = penStyleId - 1;
                this.setPenAttributes(0, 1, 1, false, false, PEN_STYLE_EDGE_TYPE[penStyleIdIndex], PEN_STYLE_FONT_STYLE[penStyleIdIndex]);
                this.setPenColor(COLOR_SOLID_WHITE, PEN_STYLE_BACKGROUND[penStyleIdIndex], COLOR_SOLID_BLACK);
            }
        }

        public void setWindowAttributes(int fillColor, int borderColor, boolean wordWrapToggle, int borderType, int printDirection, int scrollDirection, int justification) {
            this.windowFillColor = fillColor;
            this.justification = justification;
        }

        public void setPenAttributes(int textTag, int offset, int penSize, boolean italicsToggle, boolean underlineToggle, int edgeType, int fontStyle) {
            if (this.italicsStartPosition != -1) {
                if (!italicsToggle) {
                    this.captionStringBuilder.setSpan((Object)new StyleSpan(2), this.italicsStartPosition, this.captionStringBuilder.length(), 33);
                    this.italicsStartPosition = -1;
                }
            } else if (italicsToggle) {
                this.italicsStartPosition = this.captionStringBuilder.length();
            }
            if (this.underlineStartPosition != -1) {
                if (!underlineToggle) {
                    this.captionStringBuilder.setSpan((Object)new UnderlineSpan(), this.underlineStartPosition, this.captionStringBuilder.length(), 33);
                    this.underlineStartPosition = -1;
                }
            } else if (underlineToggle) {
                this.underlineStartPosition = this.captionStringBuilder.length();
            }
        }

        public void setPenColor(int foregroundColor, int backgroundColor, int edgeColor) {
            if (this.foregroundColorStartPosition != -1 && this.foregroundColor != foregroundColor) {
                this.captionStringBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), this.foregroundColorStartPosition, this.captionStringBuilder.length(), 33);
            }
            if (foregroundColor != COLOR_SOLID_WHITE) {
                this.foregroundColorStartPosition = this.captionStringBuilder.length();
                this.foregroundColor = foregroundColor;
            }
            if (this.backgroundColorStartPosition != -1 && this.backgroundColor != backgroundColor) {
                this.captionStringBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), this.backgroundColorStartPosition, this.captionStringBuilder.length(), 33);
            }
            if (backgroundColor != COLOR_SOLID_BLACK) {
                this.backgroundColorStartPosition = this.captionStringBuilder.length();
                this.backgroundColor = backgroundColor;
            }
        }

        public void setPenLocation(int row, int column) {
            if (this.row != row) {
                this.append('\n');
            }
            this.row = row;
        }

        public void backspace() {
            int length = this.captionStringBuilder.length();
            if (length > 0) {
                this.captionStringBuilder.delete(length - 1, length);
            }
        }

        public void append(char text) {
            if (text == '\n') {
                this.rolledUpCaptions.add(this.buildSpannableString());
                this.captionStringBuilder.clear();
                if (this.italicsStartPosition != -1) {
                    this.italicsStartPosition = 0;
                }
                if (this.underlineStartPosition != -1) {
                    this.underlineStartPosition = 0;
                }
                if (this.foregroundColorStartPosition != -1) {
                    this.foregroundColorStartPosition = 0;
                }
                if (this.backgroundColorStartPosition != -1) {
                    this.backgroundColorStartPosition = 0;
                }
                while (this.rowLock && this.rolledUpCaptions.size() >= this.rowCount || this.rolledUpCaptions.size() >= 15) {
                    this.rolledUpCaptions.remove(0);
                }
            } else {
                this.captionStringBuilder.append(text);
            }
        }

        public SpannableString buildSpannableString() {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)this.captionStringBuilder);
            int length = spannableStringBuilder.length();
            if (length > 0) {
                if (this.italicsStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new StyleSpan(2), this.italicsStartPosition, length, 33);
                }
                if (this.underlineStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new UnderlineSpan(), this.underlineStartPosition, length, 33);
                }
                if (this.foregroundColorStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), this.foregroundColorStartPosition, length, 33);
                }
                if (this.backgroundColorStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), this.backgroundColorStartPosition, length, 33);
                }
            }
            return new SpannableString((CharSequence)spannableStringBuilder);
        }

        @Nullable
        public Cea708CueInfo build() {
            float line;
            float position;
            if (this.isEmpty()) {
                return null;
            }
            SpannableStringBuilder cueString = new SpannableStringBuilder();
            for (int i = 0; i < this.rolledUpCaptions.size(); ++i) {
                cueString.append((CharSequence)this.rolledUpCaptions.get(i));
                cueString.append('\n');
            }
            cueString.append((CharSequence)this.buildSpannableString());
            Layout.Alignment alignment = switch (this.justification) {
                case 0, 3 -> Layout.Alignment.ALIGN_NORMAL;
                case 1 -> Layout.Alignment.ALIGN_OPPOSITE;
                case 2 -> Layout.Alignment.ALIGN_CENTER;
                default -> throw new IllegalArgumentException("Unexpected justification value: " + this.justification);
            };
            if (this.relativePositioning) {
                position = (float)this.horizontalAnchor / 99.0f;
                line = (float)this.verticalAnchor / 99.0f;
            } else {
                position = (float)this.horizontalAnchor / 209.0f;
                line = (float)this.verticalAnchor / 74.0f;
            }
            position = position * 0.9f + 0.05f;
            line = line * 0.9f + 0.05f;
            int verticalAnchorType = this.anchorId / 3 == 0 ? 0 : (this.anchorId / 3 == 1 ? 1 : 2);
            int horizontalAnchorType = this.anchorId % 3 == 0 ? 0 : (this.anchorId % 3 == 1 ? 1 : 2);
            boolean windowColorSet = this.windowFillColor != COLOR_SOLID_BLACK;
            return new Cea708CueInfo((CharSequence)cueString, alignment, line, 0, verticalAnchorType, position, horizontalAnchorType, -3.4028235E38f, windowColorSet, this.windowFillColor, this.priority);
        }

        public static int getArgbColorFromCeaColor(int red, int green, int blue) {
            return CueInfoBuilder.getArgbColorFromCeaColor(red, green, blue, 0);
        }

        public static int getArgbColorFromCeaColor(int red, int green, int blue, int opacity) {
            Assertions.checkIndex(red, 0, 4);
            Assertions.checkIndex(green, 0, 4);
            Assertions.checkIndex(blue, 0, 4);
            Assertions.checkIndex(opacity, 0, 4);
            return Color.argb((int)(switch (opacity) {
                case 0, 1 -> 255;
                case 2 -> 127;
                case 3 -> 0;
                default -> 255;
            }), (int)(red > 1 ? 255 : 0), (int)(green > 1 ? 255 : 0), (int)(blue > 1 ? 255 : 0));
        }
    }

    private static final class DtvCcPacket {
        public final int sequenceNumber;
        public final int packetSize;
        public final byte[] packetData;
        int currentIndex;

        public DtvCcPacket(int sequenceNumber, int packetSize) {
            this.sequenceNumber = sequenceNumber;
            this.packetSize = packetSize;
            this.packetData = new byte[2 * packetSize - 1];
            this.currentIndex = 0;
        }
    }

    private static final class Cea708CueInfo {
        public final Cue cue;
        public final int priority;

        public Cea708CueInfo(CharSequence text, Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, boolean windowColorSet, int windowColor, int priority) {
            Cue.Builder cueBuilder = new Cue.Builder().setText(text).setTextAlignment(textAlignment).setLine(line, lineType).setLineAnchor(lineAnchor).setPosition(position).setPositionAnchor(positionAnchor).setSize(size);
            if (windowColorSet) {
                cueBuilder.setWindowColor(windowColor);
            }
            this.cue = cueBuilder.build();
            this.priority = priority;
        }
    }
}

