/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;

public interface AudioRendererEventListener {
    default public void onAudioEnabled(DecoderCounters counters) {
    }

    default public void onAudioSessionId(int audioSessionId) {
    }

    default public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    default public void onAudioInputFormatChanged(Format format) {
    }

    default public void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
    }

    default public void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onAudioDisabled(DecoderCounters counters) {
    }

    default public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
    }

    public static final class EventDispatcher {
        @Nullable
        private final Handler handler;
        @Nullable
        private final AudioRendererEventListener listener;

        public EventDispatcher(@Nullable Handler handler, @Nullable AudioRendererEventListener listener) {
            this.handler = listener != null ? Assertions.checkNotNull(handler) : null;
            this.listener = listener;
        }

        public void enabled(DecoderCounters decoderCounters) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioEnabled(decoderCounters));
            }
        }

        public void decoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs));
            }
        }

        public void inputFormatChanged(Format format) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioInputFormatChanged(format));
            }
        }

        public void positionAdvancing(long playoutStartSystemTimeMs) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioPositionAdvancing(playoutStartSystemTimeMs));
            }
        }

        public void underrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs));
            }
        }

        public void disabled(DecoderCounters counters) {
            counters.ensureUpdated();
            if (this.handler != null) {
                this.handler.post(() -> {
                    counters.ensureUpdated();
                    Util.castNonNull(this.listener).onAudioDisabled(counters);
                });
            }
        }

        public void audioSessionId(int audioSessionId) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onAudioSessionId(audioSessionId));
            }
        }

        public void skipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            if (this.handler != null) {
                this.handler.post(() -> Util.castNonNull(this.listener).onSkipSilenceEnabledChanged(skipSilenceEnabled));
            }
        }
    }
}

