/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.ssa;

import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.Collections;
import java.util.List;

final class SsaSubtitle
implements Subtitle {
    private final List<List<Cue>> cues;
    private final List<Long> cueTimesUs;

    public SsaSubtitle(List<List<Cue>> cues, List<Long> cueTimesUs) {
        this.cues = cues;
        this.cueTimesUs = cueTimesUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil(this.cueTimesUs, Long.valueOf(timeUs), false, false);
        return index < this.cueTimesUs.size() ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.cueTimesUs.size();
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument(index >= 0);
        Assertions.checkArgument(index < this.cueTimesUs.size());
        return this.cueTimesUs.get(index);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        int index = Util.binarySearchFloor(this.cueTimesUs, Long.valueOf(timeUs), true, false);
        if (index == -1) {
            return Collections.emptyList();
        }
        return this.cues.get(index);
    }
}

