/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads;

import com.akamai.amp.ads.AdPosition;
import com.akamai.amp.ads.AdsInfo;

public class AdsCount {
    private static final int unknownCount = -1;
    public static final AdsCount UNKNOWN = new AdsCount(-1, -1, -1);
    private int prerollCount;
    private int midrollCount;
    private int postrollCount;
    private boolean singleType;
    private int mainCount = -1;
    private AdPosition adPosition = AdPosition.MIDROLL;

    public AdsCount(int prerolls, int midrolls, int postrolls) {
        this.singleType = false;
        this.setCounts(prerolls, midrolls, postrolls);
    }

    public AdsCount(AdsInfo adsInfo) {
        this.singleType = true;
        this.mainCount = adsInfo.adBreakTotal;
        this.adPosition = adsInfo.adPosition;
        switch (this.adPosition) {
            case PREROLL: {
                this.setCounts(this.mainCount, 0, 0);
                break;
            }
            case MIDROLL: {
                this.setCounts(0, this.mainCount, 0);
                break;
            }
            case POSTROLL: {
                this.setCounts(0, 0, this.mainCount);
            }
        }
    }

    private void setCounts(int prerolls, int midrolls, int postrolls) {
        this.prerollCount = prerolls;
        this.midrollCount = midrolls;
        this.postrollCount = postrolls;
    }

    public int getPrerollCount() {
        return this.prerollCount;
    }

    public int getMidrollCount() {
        return this.midrollCount;
    }

    public int getPostrollCount() {
        return this.postrollCount;
    }

    public String toString() {
        if (this.singleType) {
            String singleTypeString = String.format("AdsCount: the upcoming adBreak will contain %d ad(s) of type %s", new Object[]{this.mainCount, this.adPosition});
            return singleTypeString;
        }
        String multiTypeString = String.format("AdsCount: prerolls(%d) midrolls(%d) postrolls(%d)", this.prerollCount, this.midrollCount, this.postrollCount);
        return multiTypeString;
    }

    public boolean hasPrerolls() {
        return this.hasAds(this.prerollCount);
    }

    public boolean hasMidrolls() {
        return this.hasAds(this.midrollCount);
    }

    public boolean hasPostrolls() {
        return this.hasAds(this.postrollCount);
    }

    private boolean hasAds(int adCount) {
        boolean result = adCount > 0;
        return result;
    }

    public boolean hasAds() {
        boolean result = this.hasPrerolls() || this.hasMidrolls() || this.hasPostrolls();
        return result;
    }

    public boolean isSingleType() {
        return this.singleType;
    }

    public int getMainCount() {
        return this.mainCount;
    }

    public AdPosition getAdPosition() {
        return this.adPosition;
    }
}

