/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.content.Intent;
import android.net.Uri;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.MediaMetadata;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.media.elements.DRMKey;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntentUtil {
    public static Intent getIntentFromMediaSource(MediaResource mediaResource) {
        Intent i = new Intent();
        i.setAction("com.akamai.amp.exoplayer.demo.action.VIEW");
        i.putExtra("abr_algorithm", "default");
        if (mediaResource != null) {
            String url = mediaResource.getUrl();
            String mimeType = mediaResource.getMimeType();
            Uri uri = Uri.parse((String)url);
            i.setData(uri);
            i.putExtra("mime_type", mimeType);
            IntentUtil.addDrmToIntent(i, mediaResource);
            IntentUtil.addExtensionToIntent(i, mediaResource);
        }
        return i;
    }

    private static void addExtensionToIntent(Intent i, MediaResource mediaResource) {
        String extension = mediaResource.getExtension();
        i.putExtra("extension", extension);
    }

    private static void addDrmToIntent(Intent i, MediaResource mediaResource) {
        DrmScheme selectedScheme = mediaResource.getSelectedScheme();
        if (selectedScheme == null) {
            return;
        }
        String drmScheme = selectedScheme.toString().toLowerCase();
        i.putExtra("drm_scheme", drmScheme);
        DRMKey drmKey = mediaResource.getDRMKey(selectedScheme);
        if (drmKey == null) {
            return;
        }
        String drmLicenseUrl = drmKey.getLicenseURL();
        i.putExtra("drm_license_url", drmLicenseUrl);
        String[] httpHeaders = IntentUtil.createHttpHeaders();
        if (httpHeaders != null) {
            i.putExtra("drm_key_request_properties", httpHeaders);
        }
    }

    private static String[] createHttpHeaders() {
        Map<String, String> httpHeaders = AMPPreSettings.getPreSettingsInstance().getHttpHeaders();
        if (httpHeaders == null) {
            return null;
        }
        String[] result = new String[httpHeaders.size() * 2];
        Set<Map.Entry<String, String>> entries = httpHeaders.entrySet();
        int c = 0;
        for (Map.Entry<String, String> entry : entries) {
            result[c] = entry.getKey();
            result[c + 1] = entry.getValue();
            c += 2;
        }
        return result;
    }

    public static MediaItem createMediaItemFromIntent(MediaResource mediaResource, Intent intent) {
        Uri uri = Uri.parse((String)mediaResource.getUrl());
        String title = mediaResource.getTitle();
        String mimeType = mediaResource.getMimeType();
        MediaItem.Builder builder = new MediaItem.Builder().setUri(uri).setMediaMetadata(new MediaMetadata.Builder().setTitle(title).build()).setMimeType(mimeType);
        return IntentUtil.populateDrmPropertiesFromIntent(builder, intent).build();
    }

    private static MediaItem.Builder populateDrmPropertiesFromIntent(MediaItem.Builder builder, Intent intent) {
        String drmSchemeExtra = intent.getStringExtra("drm_scheme");
        if (drmSchemeExtra == null) {
            return builder;
        }
        Map<String, String> headers = IntentUtil.getDrmHeaders();
        String[] keyRequestPropertiesArray = intent.getStringArrayExtra("drm_key_request_properties");
        if (keyRequestPropertiesArray != null) {
            for (int i = 0; i < keyRequestPropertiesArray.length; i += 2) {
                headers.put(keyRequestPropertiesArray[i], keyRequestPropertiesArray[i + 1]);
            }
        }
        builder.setDrmUuid(Util.getDrmUuid(Util.castNonNull(drmSchemeExtra))).setDrmLicenseUri(Uri.parse((String)intent.getStringExtra("drm_license_url"))).setDrmMultiSession(intent.getBooleanExtra("drm_multi_session", false)).setDrmForceDefaultLicenseUri(intent.getBooleanExtra("drm_force_default_license_uri", false)).setDrmLicenseRequestHeaders(headers);
        if (intent.getBooleanExtra("drm_session_for_clear_content", false)) {
            builder.setDrmSessionForClearTypes((List<Integer>)ImmutableList.of((Object)2, (Object)1));
        }
        return builder;
    }

    public static Map<String, String> getDrmHeaders() {
        Map<String, String> drmHeaders = AMPPreSettings.getPreSettingsInstance().getDrmLicenseHeaders();
        if (drmHeaders == null || drmHeaders.isEmpty()) {
            return new HashMap<String, String>();
        }
        return drmHeaders;
    }
}

