/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.exowrapper2;

import android.content.Context;
import com.akamai.amp.downloader.LocalPathProvider;
import com.akamai.amp.exoplayer2.DefaultRenderersFactory;
import com.akamai.amp.exoplayer2.RenderersFactory;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultDataSourceFactory;
import com.akamai.amp.exoplayer2.upstream.DefaultHttpDataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.cache.Cache;
import com.akamai.amp.exoplayer2.upstream.cache.CacheDataSource;
import com.akamai.amp.utils.Utils;
import java.util.Iterator;
import java.util.Map;

public class DataSourceBuilder {
    public static DataSource.Factory buildDataSourceFactory(Context c, LocalPathProvider localPathProvider) {
        DefaultDataSourceFactory upstreamFactory = new DefaultDataSourceFactory(c, DataSourceBuilder.buildHttpDataSourceFactory());
        return DataSourceBuilder.buildReadOnlyCacheDataSource(upstreamFactory, localPathProvider.getDownloadCache());
    }

    public static HttpDataSource.Factory buildHttpDataSourceFactory() {
        String userAgent = AMPPreSettings.getPreSettingsInstance().getUserAgent();
        if (userAgent == null) {
            userAgent = Utils.getDefaultUserAgent();
        }
        DefaultHttpDataSourceFactory factory = new DefaultHttpDataSourceFactory(userAgent);
        Map<String, String> headers = AMPPreSettings.getPreSettingsInstance().getHttpHeaders();
        DataSourceBuilder.setProperties(headers, factory);
        return factory;
    }

    public static RenderersFactory buildRendererFactory(Context context, boolean preferExtensionDecoders) {
        int extensionRendererMode = DataSourceBuilder.useExtensionRenderers() ? (preferExtensionDecoders ? 2 : 1) : 0;
        return new DefaultRenderersFactory(context).setExtensionRendererMode(extensionRendererMode);
    }

    public static boolean useExtensionRenderers() {
        return false;
    }

    public static void setProperties(Map<String, String> requestProperties, HttpDataSource.Factory httpDataSourceFactory) {
        if (requestProperties != null) {
            Iterator<Map.Entry<String, String>> it = requestProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                httpDataSourceFactory.getDefaultRequestProperties().set(pair.getKey().toString(), pair.getValue().toString());
                it.remove();
            }
        }
    }

    public static void updateCommonMediaClientData(Map<String, String> requestProperties) {
        if (requestProperties != null) {
            Iterator<Map.Entry<String, String>> it = requestProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                DefaultHttpDataSource.getCommonMediaClientData().set(pair.getKey().toString(), pair.getValue().toString());
                it.remove();
            }
        }
    }

    private static CacheDataSource.Factory buildReadOnlyCacheDataSource(DataSource.Factory upstreamFactory, Cache cache) {
        return new CacheDataSource.Factory().setCache(cache).setUpstreamDataSourceFactory(upstreamFactory).setCacheWriteDataSinkFactory(null).setFlags(2);
    }
}

