/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.dash;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.extractor.ChunkIndex;
import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.mkv.MatroskaExtractor;
import com.akamai.amp.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.akamai.amp.exoplayer2.source.chunk.BundledChunkExtractor;
import com.akamai.amp.exoplayer2.source.chunk.ChunkExtractor;
import com.akamai.amp.exoplayer2.source.chunk.InitializationChunk;
import com.akamai.amp.exoplayer2.source.dash.manifest.DashManifest;
import com.akamai.amp.exoplayer2.source.dash.manifest.DashManifestParser;
import com.akamai.amp.exoplayer2.source.dash.manifest.Period;
import com.akamai.amp.exoplayer2.source.dash.manifest.RangedUri;
import com.akamai.amp.exoplayer2.source.dash.manifest.Representation;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.ParsingLoadable;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.List;

public final class DashUtil {
    public static DataSpec buildDataSpec(Representation representation, RangedUri requestUri) {
        return new DataSpec.Builder().setUri(requestUri.resolveUri(representation.baseUrl)).setPosition(requestUri.start).setLength(requestUri.length).setKey(representation.getCacheKey()).build();
    }

    public static DashManifest loadManifest(DataSource dataSource, Uri uri) throws IOException {
        return ParsingLoadable.load(dataSource, new DashManifestParser(), uri, 4);
    }

    @Nullable
    public static Format loadFormatWithDrmInitData(DataSource dataSource, Period period) throws IOException {
        int primaryTrackType = 2;
        Representation representation = DashUtil.getFirstRepresentation(period, primaryTrackType);
        if (representation == null && (representation = DashUtil.getFirstRepresentation(period, primaryTrackType = 1)) == null) {
            return null;
        }
        Format manifestFormat = representation.format;
        Format sampleFormat = DashUtil.loadSampleFormat(dataSource, primaryTrackType, representation);
        return sampleFormat == null ? manifestFormat : sampleFormat.withManifestFormatInfo(manifestFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Format loadSampleFormat(DataSource dataSource, int trackType, Representation representation) throws IOException {
        if (representation.getInitializationUri() == null) {
            return null;
        }
        ChunkExtractor chunkExtractor = DashUtil.newChunkExtractor(trackType, representation.format);
        try {
            DashUtil.loadInitializationData(chunkExtractor, dataSource, representation, false);
        }
        finally {
            chunkExtractor.release();
        }
        return Assertions.checkStateNotNull(chunkExtractor.getSampleFormats())[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ChunkIndex loadChunkIndex(DataSource dataSource, int trackType, Representation representation) throws IOException {
        if (representation.getInitializationUri() == null) {
            return null;
        }
        ChunkExtractor chunkExtractor = DashUtil.newChunkExtractor(trackType, representation.format);
        try {
            DashUtil.loadInitializationData(chunkExtractor, dataSource, representation, true);
        }
        finally {
            chunkExtractor.release();
        }
        return chunkExtractor.getChunkIndex();
    }

    private static void loadInitializationData(ChunkExtractor chunkExtractor, DataSource dataSource, Representation representation, boolean loadIndex) throws IOException {
        RangedUri requestUri;
        RangedUri initializationUri = Assertions.checkNotNull(representation.getInitializationUri());
        if (loadIndex) {
            RangedUri indexUri = representation.getIndexUri();
            if (indexUri == null) {
                return;
            }
            requestUri = initializationUri.attemptMerge(indexUri, representation.baseUrl);
            if (requestUri == null) {
                DashUtil.loadInitializationData(dataSource, representation, chunkExtractor, initializationUri);
                requestUri = indexUri;
            }
        } else {
            requestUri = initializationUri;
        }
        DashUtil.loadInitializationData(dataSource, representation, chunkExtractor, requestUri);
    }

    private static void loadInitializationData(DataSource dataSource, Representation representation, ChunkExtractor chunkExtractor, RangedUri requestUri) throws IOException {
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, requestUri);
        InitializationChunk initializationChunk = new InitializationChunk(dataSource, dataSpec, representation.format, 0, null, chunkExtractor);
        initializationChunk.load();
    }

    private static ChunkExtractor newChunkExtractor(int trackType, Format format) {
        String mimeType = format.containerMimeType;
        boolean isWebm = mimeType != null && (mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm"));
        Extractor extractor = isWebm ? new MatroskaExtractor() : new FragmentedMp4Extractor();
        return new BundledChunkExtractor(extractor, trackType, format);
    }

    @Nullable
    private static Representation getFirstRepresentation(Period period, int type) {
        int index = period.getAdaptationSetIndex(type);
        if (index == -1) {
            return null;
        }
        List<Representation> representations = period.adaptationSets.get((int)index).representations;
        return representations.isEmpty() ? null : representations.get(0);
    }

    private DashUtil() {
    }
}

