/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.FixedTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class TrackSelectionUtil {
    private TrackSelectionUtil() {
    }

    public static @NullableType TrackSelection[] createTrackSelectionsForDefinitions(@NullableType TrackSelection.Definition[] definitions, AdaptiveTrackSelectionFactory adaptiveTrackSelectionFactory) {
        TrackSelection[] selections = new TrackSelection[definitions.length];
        boolean createdAdaptiveTrackSelection = false;
        for (int i = 0; i < definitions.length; ++i) {
            TrackSelection.Definition definition = definitions[i];
            if (definition == null) continue;
            if (definition.tracks.length > 1 && !createdAdaptiveTrackSelection) {
                createdAdaptiveTrackSelection = true;
                selections[i] = adaptiveTrackSelectionFactory.createAdaptiveTrackSelection(definition);
                continue;
            }
            selections[i] = new FixedTrackSelection(definition.group, definition.tracks[0], definition.reason, definition.data);
        }
        return selections;
    }

    public static DefaultTrackSelector.Parameters updateParametersWithOverride(DefaultTrackSelector.Parameters parameters, int rendererIndex, TrackGroupArray trackGroupArray, boolean isDisabled, @Nullable DefaultTrackSelector.SelectionOverride override) {
        DefaultTrackSelector.ParametersBuilder builder = parameters.buildUpon().clearSelectionOverrides(rendererIndex).setRendererDisabled(rendererIndex, isDisabled);
        if (override != null) {
            builder.setSelectionOverride(rendererIndex, trackGroupArray, override);
        }
        return builder.build();
    }

    public static interface AdaptiveTrackSelectionFactory {
        public TrackSelection createAdaptiveTrackSelection(TrackSelection.Definition var1);
    }
}

