/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.service.clock;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.va.service.clock.ClockService;
import com.adobe.primetime.va.service.clock.TimerDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class TimerManager {
    static double TIMER_BASE_INTERVAL = 250.0;
    private String _logTag;
    private ILogger _logger;
    private ClockService _service;
    private Map<String, TimerDescriptor> _timers;
    private Timer _baseTimer;
    private boolean _isDestroyed;
    private static final int REPEAT_FOREVER = -1;

    TimerManager(ClockService service, ILogger logger) {
        if (service == null) {
            throw new Error("Reference to ClockService object cannot be NULL.");
        }
        this._service = service;
        if (logger == null) {
            throw new Error("Reference to logger cannot be NULL.");
        }
        this._logTag = TimerManager.class.getSimpleName();
        this._logger = logger;
        this._isDestroyed = false;
        this._timers = new HashMap<String, TimerDescriptor>();
        this._baseTimer = new Timer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTimer(String name, double interval, int repeatCount) {
        TimerManager timerManager = this;
        synchronized (timerManager) {
            this._timers.put(name, new TimerDescriptor(name, interval, repeatCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyTimer(String name) {
        TimerManager timerManager = this;
        synchronized (timerManager) {
            this._timers.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeTimer(String name, boolean reset) {
        TimerManager timerManager = this;
        synchronized (timerManager) {
            this._logger.debug(this._logTag, "#resumedTimer(name=" + name + ", " + "reset=" + reset + ")");
            TimerDescriptor timer = this._timers.get(name);
            if (timer != null) {
                timer.isActive(true);
                if (reset) {
                    timer.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseTimer(String name, boolean reset) {
        TimerManager timerManager = this;
        synchronized (timerManager) {
            this._logger.debug(this._logTag, "#pauseTimer(name=" + name + ", " + "reset=" + reset + ")");
            TimerDescriptor timer = this._timers.get(name);
            if (timer != null) {
                timer.isActive(false);
                if (reset) {
                    timer.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        TimerManager timerManager = this;
        synchronized (timerManager) {
            this._timers.clear();
            this._baseTimer.invalidate();
            this._baseTimer.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTimerPaused(String name) {
        TimerManager timerManager = this;
        synchronized (timerManager) {
            TimerDescriptor timer = this._timers.get(name);
            return timer != null && !timer.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _onTick() {
        if (this._isDestroyed) {
            return;
        }
        ArrayList<TimerHolder> timerHolders = new ArrayList<TimerHolder>();
        TimerManager timerManager = this;
        synchronized (timerManager) {
            for (Map.Entry<String, TimerDescriptor> entry : this._timers.entrySet()) {
                TimerDescriptor timer = entry.getValue();
                if (!timer.isActive() || !timer.shouldTick()) continue;
                int repeatCount = timer.getRepeatCount();
                if (timer.getInterval() > 1.0) {
                    this._logger.debug(this._logTag, "#_onTick() > " + timer.getName() + "(" + timer.getTick() + " | " + timer.getInterval() + " | " + repeatCount + ")");
                }
                if (repeatCount != 0) {
                    TimerHolder timerHolder = new TimerHolder(timer.getName(), timer.getInterval(), timer.getTick());
                    timerHolders.add(timerHolder);
                    if (repeatCount == -1) continue;
                    timer.setRepeatCount(repeatCount - 1);
                    continue;
                }
                this.destroyTimer(timer.getName());
            }
        }
        if (!timerHolders.isEmpty()) {
            for (TimerHolder timerHolder : timerHolders) {
                this._service.onTick(timerHolder.getName(), timerHolder.getInterval(), timerHolder.getTick());
            }
            timerHolders.clear();
        }
    }

    private class TimerHolder {
        private String _name;
        private double _interval;
        private int _tick;

        TimerHolder(String name, double interval, int tick) {
            this._name = name;
            this._interval = interval;
            this._tick = tick;
        }

        String getName() {
            return this._name;
        }

        double getInterval() {
            return this._interval;
        }

        int getTick() {
            return this._tick;
        }
    }

    private class Timer
    extends HandlerThread {
        private Handler _handler;
        private boolean _shouldStop;

        Timer() {
            super("VideoHeartbeatClock");
            this._shouldStop = false;
            this.start();
            Looper looper = this.getLooper();
            if (looper == null) {
                TimerManager.this._logger.error(TimerManager.this._logTag, "Unable to obtain looper thread.");
                return;
            }
            final Handler handler = this._handler = new Handler(this.getLooper());
            Runnable clockRunnable = new Runnable(){

                public void run() {
                    if (!Timer.this._shouldStop) {
                        TimerManager.this._onTick();
                        handler.postDelayed((Runnable)this, (long)TIMER_BASE_INTERVAL);
                    }
                }
            };
            handler.post(clockRunnable);
        }

        public void invalidate() {
            this._shouldStop = true;
        }
    }
}

