/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.clock;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Channel;
import java.util.ArrayList;
import java.util.HashMap;

class Timer {
    protected String _logTag;
    protected ILogger _logger;
    private boolean _isDestroyed;
    protected Double _interval;
    protected Channel _channel;
    protected PluginManager _pluginManager;
    protected String _name;
    private static final String HEARTBEAT_PLUGIN = "heartbeat";
    private static final String CLOCK_SERVICE = "service.clock";
    private static final String CMD_CREATE = "create";
    private static final String CMD_PAUSE = "pause";
    private static final String CMD_RESUME = "resume";
    private static final String CMD_DESTROY = "destroy";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_INTERVAL = "interval";
    protected static final String KEY_RESET = "reset";
    private static final String REQ_TIMER_IS_PAUSED = "is_paused";
    private ICallback _cmdResume = new ICallback(){

        public Object call(Object param) {
            HashMap data = (HashMap)param;
            Boolean reset = false;
            if (data != null && data.containsKey(Timer.KEY_RESET)) {
                reset = (Boolean)data.get(Timer.KEY_RESET);
            }
            Timer.this.resume(reset);
            return null;
        }
    };
    private ICallback _cmdPause = new ICallback(){

        public Object call(Object param) {
            HashMap data = (HashMap)param;
            Boolean reset = false;
            if (data != null && ((Boolean)data.get(Timer.KEY_RESET)).booleanValue()) {
                reset = (Boolean)data.get(Timer.KEY_RESET);
            }
            Timer.this.pause(reset);
            return null;
        }
    };
    private ICallback _onTick = new ICallback(){

        public Object call(Object param) {
            Event event = (Event)param;
            Timer.this._channel.trigger(new Event("clock:" + Timer.this._name + ".tick", event.getData()));
            return null;
        }
    };

    Timer(PluginManager pluginManager, Channel channel, String name, double interval, ILogger logger) {
        if (channel == null) {
            throw new Error("Reference to the channel object cannot be NULL.");
        }
        this._channel = channel;
        if (pluginManager == null) {
            throw new Error("Reference to the pluginManager object cannot be NULL.");
        }
        this._pluginManager = pluginManager;
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL.");
        }
        this._logger = logger;
        this._logTag = this.getClass().getSimpleName();
        this._isDestroyed = false;
        this._createTimer(name, interval);
        this._installHandlers();
    }

    public void resume(Boolean reset) {
        this._logger.debug(this._logTag, "Starting timer: " + this._name);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_NAME, "heartbeat." + this._name);
        data.put(KEY_RESET, reset);
        this._pluginManager.command(CLOCK_SERVICE, CMD_RESUME, data);
    }

    public void pause(Boolean reset) {
        this._logger.debug(this._logTag, "Stopping timer: " + this._name);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_NAME, "heartbeat." + this._name);
        data.put(KEY_RESET, reset);
        this._pluginManager.command(CLOCK_SERVICE, CMD_PAUSE, data);
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        this._uninstallHandlers();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(KEY_NAME, "heartbeat." + this._name);
        this._pluginManager.command(CLOCK_SERVICE, CMD_DESTROY, data);
    }

    void setInterval(double interval) {
        String isPausedKey = "is_paused.heartbeat." + this._name;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(isPausedKey);
        Boolean wasPaused = (Boolean)((HashMap)this._pluginManager.request(CLOCK_SERVICE, keys)).get(isPausedKey);
        this.pause(true);
        this._createTimer(this._name, interval);
        if (!wasPaused.booleanValue()) {
            this.resume(true);
        }
    }

    private void _installHandlers() {
        this._channel.comply("clock:" + this._name + ".resume", this._cmdResume);
        this._channel.comply("clock:" + this._name + ".pause", this._cmdPause);
        this._pluginManager.on(CLOCK_SERVICE, "heartbeat." + this._name + ".tick", this._onTick, this);
    }

    private void _uninstallHandlers() {
        this._channel.off(null, null, this);
        this._pluginManager.off(null, null, null, this);
    }

    private void _createTimer(String name, double interval) {
        this._name = name;
        this._interval = interval;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_NAME, "heartbeat." + this._name);
        data.put(KEY_INTERVAL, this._interval);
        this._pluginManager.command(CLOCK_SERVICE, CMD_CREATE, data);
    }
}

