/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.clock;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.va.plugins.ah.engine.clock.CheckStatusTimer;
import com.adobe.primetime.va.plugins.ah.engine.clock.FlushFilterTimer;
import com.adobe.primetime.va.plugins.ah.engine.clock.IdleTimer;
import com.adobe.primetime.va.plugins.ah.engine.clock.ReportingTimer;

public final class Clock {
    private ReportingTimer _reportingTimer;
    private FlushFilterTimer _flushFilterTimer;
    private CheckStatusTimer _checkStatusTimer;
    private IdleTimer _idleTimer;
    private boolean _isDestroyed;

    public Clock(PluginManager pluginManager, Channel channel, ILogger logger) {
        if (pluginManager == null) {
            throw new Error("Reference to the pluginManger object cannot be NULL.");
        }
        if (channel == null) {
            throw new Error("Reference to the channel object cannot be NULL.");
        }
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL.");
        }
        this._isDestroyed = false;
        this._reportingTimer = new ReportingTimer(pluginManager, channel, logger);
        this._flushFilterTimer = new FlushFilterTimer(pluginManager, channel, logger);
        this._checkStatusTimer = new CheckStatusTimer(pluginManager, channel, logger);
        this._idleTimer = new IdleTimer(pluginManager, channel, logger);
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        this._reportingTimer.destroy();
        this._checkStatusTimer.destroy();
        this._flushFilterTimer.destroy();
        this._idleTimer.destroy();
    }
}

