/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.clock;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.va.plugins.ah.engine.clock.Timer;
import java.util.Map;

public final class CheckStatusTimer
extends Timer {
    private static final double MAXIMUM_CHECK_STATUS_INTERVAL = 600.0;
    private static final double DEFAULT_CHECK_STATUS_INTERVAL = 180.0;
    private static final String NAME = "check_status";
    private static final String EVENT_CLOCK_CHECK_STATUS_TICK = "clock:check_status.tick";
    private static final String EVENT_CLOCK_CHECK_STATUS_GET_SETTINGS = "clock:check_status.get_settings";
    private static final String EVENT_NET_CHECK_STATUS_COMPLETE = "net:check_status_complete";
    private static final String KEY_CHECK_STATUS_INTERVAL = "check_status_interval";
    private final ICallback _onCheckStatusComplete = new ICallback(){

        public Object call(Object param) {
            Map eventData = (Map)((Event)param).getData();
            Double newTimerInterval = (Double)eventData.get(CheckStatusTimer.KEY_CHECK_STATUS_INTERVAL);
            CheckStatusTimer.this._logger.debug(CheckStatusTimer.this._logTag, "#_onCheckStatusComplete(interval=" + newTimerInterval + ")");
            if (newTimerInterval != null) {
                if (newTimerInterval.equals(CheckStatusTimer.this._interval)) {
                    CheckStatusTimer.this._logger.debug(CheckStatusTimer.this._logTag, "#_onCheckStatusComplete() - Interval value not changed.");
                    return null;
                }
                if (newTimerInterval > 600.0) {
                    CheckStatusTimer.this._logger.warn(CheckStatusTimer.this._logTag, "#_onCheckStatusComplete() - Interval value too large: " + newTimerInterval);
                    CheckStatusTimer.this.setInterval(600.0);
                } else {
                    CheckStatusTimer.this._logger.debug(CheckStatusTimer.this._logTag, "#_onCheckStatusComplete() - Interval changed to: " + newTimerInterval);
                    CheckStatusTimer.this.setInterval(newTimerInterval);
                }
            } else {
                CheckStatusTimer.this._logger.warn(CheckStatusTimer.this._logTag, "#_onCheckStatusComplete() - Invalid interval value.");
                CheckStatusTimer.this.setInterval(180.0);
            }
            return null;
        }
    };
    private final ICallback _getSettings = new ICallback(){

        public Object call(Object param) {
            CheckStatusTimer.this._logger.debug(CheckStatusTimer.this._logTag, "#_getSettings()");
            CheckStatusTimer.this._channel.trigger(new Event(CheckStatusTimer.EVENT_CLOCK_CHECK_STATUS_TICK, null));
            return null;
        }
    };

    public CheckStatusTimer(PluginManager pluginManager, Channel channel, ILogger logger) {
        super(pluginManager, channel, NAME, 180.0, logger);
        this.installHandlers();
    }

    private void installHandlers() {
        this._channel.on(EVENT_CLOCK_CHECK_STATUS_GET_SETTINGS, this._getSettings, this);
        this._channel.on(EVENT_NET_CHECK_STATUS_COMPLETE, this._onCheckStatusComplete, this);
        this._channel.reply(KEY_CHECK_STATUS_INTERVAL, new ICallback(){

            public Object call(Object param) {
                return CheckStatusTimer.this._interval;
            }
        });
    }
}

