/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core;

import android.os.Build;
import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.TLSSocketFactory;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.va.ErrorInfo;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class URLLoader {
    private static final Integer NETWORK_TIMEOUT = 30000;
    private static final String CHANNEL_URL_LOADER = "channel_url_loader";
    public static final String SERVER_RESPONSE = "server_response";
    private String _logTag;
    private ILogger _logger;
    private static ExecutorService _executor;
    private static volatile boolean _executor_pred;
    private static String platform;
    private static volatile boolean getPlatform_pred;
    private static String userAgent;
    private static volatile boolean getDefaultUserAgent_pred;
    private final Channel _channel;

    private static synchronized ExecutorService getExecutor() {
        if (_executor_pred) {
            _executor = Executors.newSingleThreadExecutor();
            _executor_pred = false;
        }
        return _executor;
    }

    public URLLoader(ILogger logger) {
        if (logger == null) {
            throw new Error("Reference to logger cannot be NULL.");
        }
        this._logger = logger;
        this._logTag = URLLoader.class.getSimpleName();
        this._channel = new Channel(CHANNEL_URL_LOADER, this._logger);
    }

    public void on(String eventType, ICallback callback) {
        this._channel.on(eventType, callback, this);
    }

    public void load(URLRequest request) {
        this.load(request, false);
    }

    public void load(final URLRequest request, final boolean disableKeepAlive) {
        URLLoader.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpURLConnection connection = null;
                try {
                    connection = URLLoader.this._requestConnect(request.getUrl());
                    if (connection != null) {
                        connection.setRequestMethod(request.getMethod().toString());
                        connection.setConnectTimeout(NETWORK_TIMEOUT);
                        connection.setReadTimeout(NETWORK_TIMEOUT);
                        connection.setRequestProperty("User-Agent", URLLoader.getDefaultUserAgent());
                        if (disableKeepAlive) {
                            connection.setRequestProperty("Connection", "close");
                        }
                        if (request.getMethod() == HttpMethod.POST) {
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            String urlParams = request.getUrlEncodedData();
                            DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
                            outStream.writeBytes(urlParams);
                            outStream.flush();
                            outStream.close();
                        }
                        connection.connect();
                        URLLoader.this._logger.debug(URLLoader.this._logTag, "#load() - Request sent: " + request.getUrl());
                        InputStream stream = connection.getInputStream();
                        int statusCode = connection.getResponseCode();
                        char statusCodeClass = Integer.toString(statusCode).charAt(0);
                        if (statusCodeClass == '4' || statusCodeClass == '5') {
                            URLLoader.this._logger.warn(URLLoader.this._logTag, "#load() - Server status error code: " + statusCode);
                        } else {
                            String response = URLLoader.this._inputStreamToString(stream);
                            HashMap<String, String> eventData = new HashMap<String, String>();
                            eventData.put(URLLoader.SERVER_RESPONSE, response);
                            URLLoader.this._channel.trigger(new Event("success", eventData));
                        }
                        stream.close();
                        URLLoader.this._channel.shutdown();
                    }
                }
                catch (SocketTimeoutException e) {
                    URLLoader.this._handleConnectionError("#load() - Timed out sending request(" + request.getUrl() + ")");
                }
                catch (IOException e) {
                    URLLoader.this._handleConnectionError("#load() - IOException while sending request, may retry(" + e.getLocalizedMessage() + ")");
                }
                catch (Exception e) {
                    URLLoader.this._handleConnectionError("#load() - Unable to create HTTP connection (" + e.getLocalizedMessage() + ")");
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        });
    }

    private void _handleConnectionError(String message) {
        this._logger.error(this._logTag, message);
        this._channel.trigger(new Event("error", new ErrorInfo("error", "Internal Error: " + message)));
    }

    private HttpURLConnection _requestConnect(String url) {
        try {
            URL requestURL = new URL(url);
            String protocol = requestURL.getProtocol();
            if (protocol != null) {
                HttpURLConnection connection;
                if (protocol.startsWith("https")) {
                    connection = (HttpsURLConnection)requestURL.openConnection();
                } else if (protocol.startsWith("http")) {
                    connection = (HttpURLConnection)requestURL.openConnection();
                } else {
                    return null;
                }
                if (Build.VERSION.SDK_INT < 20 && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(TLSSocketFactory.getInstance());
                }
                return connection;
            }
        }
        catch (Exception e) {
            this._logger.error(this._logTag, "#load() -  Exception opening URL(" + e.getLocalizedMessage() + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _inputStreamToString(InputStream input) {
        if (input == null) {
            return null;
        }
        StringBuilder returnString = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            try {
                String chunk;
                while ((chunk = reader.readLine()) != null) {
                    returnString.append(chunk);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            this._logger.error(this._logTag, "#load() - Exception while reading from stream(" + e.getLocalizedMessage() + ")");
        }
        return returnString.toString();
    }

    protected static synchronized String getPlatform() {
        if (getPlatform_pred) {
            platform = Build.MODEL;
            getPlatform_pred = false;
        }
        return platform;
    }

    private static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    protected static synchronized String getDefaultUserAgent() {
        if (getDefaultUserAgent_pred) {
            userAgent = "Mozilla/5.0 (Linux; U; Android " + URLLoader.getAndroidVersion() + "; en-US" + "; " + URLLoader.getPlatform() + " Build/" + Build.ID + ")";
            getDefaultUserAgent_pred = false;
        }
        return userAgent;
    }

    static {
        _executor_pred = true;
        platform = null;
        getPlatform_pred = true;
        userAgent = null;
        getDefaultUserAgent_pred = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLRequest {
        private final String _url;
        private final HttpMethod _method;
        private final Map<String, String> _data;

        public URLRequest(String url, HttpMethod method) {
            this(url, method, null);
        }

        public URLRequest(String url, HttpMethod method, Map<String, String> data) {
            this._url = url;
            this._method = method;
            this._data = data;
        }

        public HttpMethod getMethod() {
            return this._method;
        }

        public String getUrl() {
            return this._url;
        }

        public String getUrlEncodedData() {
            String retVal = "";
            if (this._data == null) {
                return retVal;
            }
            for (Map.Entry<String, String> entry : this._data.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                retVal = retVal + key + "=" + value + "&";
            }
            if (retVal.length() > 0) {
                retVal = retVal.substring(0, retVal.length() - 1);
            }
            return retVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET,
        POST;

    }
}

