/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetLocationRequest;
import com.adobe.mobile.TargetPrefetchObject;
import com.adobe.mobile.TargetPreviewManager;
import com.adobe.mobile.TargetRequestObject;
import com.adobe.mobile.TargetWorker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class Target {
    public static void loadRequest(TargetLocationRequest request, TargetCallback<String> callback) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Target - Method loadRequest is not available for Wearable", new Object[0]);
            return;
        }
        TargetWorker.loadRequest(request, callback);
    }

    public static void loadRequest(String name, String defaultContent, Map<String, Object> profileParameters, Map<String, Object> orderParameters, Map<String, Object> mboxParameters, TargetCallback<String> callback) {
        Target.loadRequest(name, defaultContent, profileParameters, orderParameters, mboxParameters, null, callback);
    }

    public static void loadRequest(String name, String defaultContent, Map<String, Object> profileParameters, Map<String, Object> orderParameters, Map<String, Object> mboxParameters, Map<String, Object> requestLocationParameters, TargetCallback<String> callback) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Target - Method loadRequest is not available for Wearable", new Object[0]);
            return;
        }
        TargetWorker.loadRequest(name, defaultContent, profileParameters, orderParameters, mboxParameters, requestLocationParameters, callback);
    }

    public static TargetLocationRequest createRequest(String name, String defaultContent, Map<String, Object> parameters) {
        return new TargetLocationRequest(name, defaultContent, parameters);
    }

    public static TargetLocationRequest createOrderConfirmRequest(String name, String orderId, String orderTotal, String productPurchasedId, Map<String, Object> parameters) {
        return TargetLocationRequest.createRequestWithOrderConfirm(name, orderId, orderTotal, productPurchasedId, parameters);
    }

    public static String getPcID() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TargetWorker.getTntId();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Target - Unable to get PcID (%s)", e.getMessage());
            return null;
        }
    }

    public static String getSessionID() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TargetWorker.getSessionId();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Target - Unable to get SessionID (%s)", e.getMessage());
            return null;
        }
    }

    public static String getThirdPartyID() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TargetWorker.getThirdPartyId();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Target - Unable to get ThirdPartyID (%s)", e.getMessage());
            return null;
        }
    }

    public static void setThirdPartyID(final String thirdPartyId) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TargetWorker.setThirdPartyId(thirdPartyId);
            }
        });
    }

    public static void clearCookies() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TargetWorker.resetExperience();
            }
        });
    }

    public static void setPreviewRestartDeeplink(String deeplink) {
        if (MobileConfig.getInstance().mobileUsingTarget()) {
            TargetPreviewManager.getInstance().setPreviewRestartDeeplink(deeplink);
        }
    }

    public static void prefetchContent(List<TargetPrefetchObject> targetPrefetchArray, Map<String, Object> profileParameters, TargetCallback<Boolean> callback) {
        TargetWorker.prefetchContent(targetPrefetchArray, profileParameters, callback);
    }

    public static void clearPrefetchCache() {
        TargetWorker.clearPrefetchCache();
    }

    public static void loadRequests(List<TargetRequestObject> requestArray, Map<String, Object> profileParameters) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Target - Method loadRequest is not available for Wearable", new Object[0]);
            return;
        }
        TargetWorker.loadRequests(requestArray, profileParameters);
    }

    public static TargetRequestObject createTargetRequestObject(String mboxName, String defaultContent, Map<String, Object> mboxParams, Map<String, Object> orderParams, Map<String, Object> productParams, TargetCallback<String> callback) {
        return new TargetRequestObject(mboxName, defaultContent, mboxParams, orderParams, productParams, callback);
    }

    public static TargetRequestObject createTargetRequestObject(String mboxName, String defaultContent, Map<String, Object> mboxParams, TargetCallback<String> callback) {
        return new TargetRequestObject(mboxName, defaultContent, mboxParams, null, null, callback);
    }

    public static TargetPrefetchObject createTargetPrefetchObject(String mboxName, Map<String, Object> mboxParams, Map<String, Object> orderParams, Map<String, Object> productParams) {
        return new TargetPrefetchObject(mboxName, mboxParams, orderParams, productParams);
    }

    public static TargetPrefetchObject createTargetPrefetchObject(String mboxName, Map<String, Object> mboxParams) {
        return new TargetPrefetchObject(mboxName, mboxParams, null, null);
    }

    public static void locationClicked(String mboxName, Map<String, Object> mboxParameters, Map<String, Object> orderParameters, Map<String, Object> productParameters, Map<String, Object> profileParameters) {
        TargetWorker.locationClicked(mboxName, mboxParameters, orderParameters, productParameters, profileParameters);
    }

    public static interface TargetCallback<T> {
        public void call(T var1);
    }
}

