/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.Message;
import com.adobe.mobile.MessageFullScreen;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.ReferrerHandler;
import com.adobe.mobile.StaticMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

final class Messages {
    protected static final String MESSAGE_ACTION_NAME = "In-App Message";
    protected static final String MESSAGE_TRIGGERED = "a.message.triggered";
    protected static final String MESSAGE_CLICKED = "a.message.clicked";
    protected static final String MESSAGE_VIEWED = "a.message.viewed";
    protected static final String MESSAGE_ID = "a.message.id";
    protected static final String MESSAGE_BUTTON_ID = "a.message.button.id";
    protected static final String MESSAGE_CANCEL_ID = "ADBMessageCancelButton";
    protected static final String MESSAGE_CLICK_THROUGH_ID = "ADBMessageClickThroughButton";
    protected static final String MESSAGE_JSON_USER_INFO_KEY = "userData";
    protected static final String MESSAGE_TOKEN_USER_ID = "{userId}";
    protected static final String MESSAGE_TOKEN_TRACKING_ID = "{trackingId}";
    protected static final String MESSAGE_TOKEN_MESSAGE_ID = "{messageId}";
    protected static final String MESSAGE_TOKEN_LIFETIME_VALUE = "{lifetimeValue}";
    protected static final String MESSAGE_LOCAL_PAYLOAD = "alarm_message";
    protected static final Integer MESSAGE_LOCAL_IDENTIFIER = 750183;
    protected static final String MESSAGE_LOCAL_ADB_CODE = "adbMessageCode";
    protected static final String MESSAGE_LOCAL_REQUEST_CODE = "requestCode";
    private static MessageFullScreen _messageFullScreen = null;
    private static final Object _messageFullScreenMutex = new Object();
    private static int _smallIconResourceId = -1;
    private static int _largeIconResourceId = -1;
    private static Message _currentMessage = null;
    private static final Object _currentMessageMutex = new Object();

    Messages() {
    }

    protected static HashMap<String, Object> lowercaseKeysForMap(Map<String, Object> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return null;
        }
        HashMap<String, Object> lowercasedDataMap = new HashMap<String, Object>(dataMap.size());
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            lowercasedDataMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return lowercasedDataMap;
    }

    protected static void block3rdPartyCallbacksQueueForReferrer() {
        StaticMethods.getThirdPartyCallbacksExecutor().execute(new Runnable(){

            @Override
            public void run() {
                while (!ReferrerHandler.getReferrerProcessed()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        StaticMethods.logWarningFormat("Data Callback - Data Callback Queue Is Interrupted(%s)", e.getMessage());
                    }
                }
            }
        });
    }

    protected static void checkFor3rdPartyCallbacks(final Map<String, Object> vars, final Map<String, Object> cdata) {
        StaticMethods.getThirdPartyCallbacksExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Message> callbacks = MobileConfig.getInstance().getCallbackTemplates();
                if (callbacks == null || callbacks.size() <= 0) {
                    return;
                }
                HashMap<String, Object> lifecycleData = new HashMap<String, Object>(Lifecycle.getContextDataLowercase());
                HashMap<String, Object> lowercaseContextData = Messages.lowercaseKeysForMap(cdata);
                HashMap<String, Object> lowercaseVars = Messages.lowercaseKeysForMap(vars);
                for (Message message : callbacks) {
                    if (!message.shouldShowForVariables(lowercaseVars, lowercaseContextData, lifecycleData)) continue;
                    message.show();
                }
            }
        });
    }

    protected static void checkForPIIRequests(final Map<String, Object> data) {
        StaticMethods.getPIIExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Message> piiRequests = MobileConfig.getInstance().getPiiRequests();
                if (piiRequests == null || piiRequests.size() <= 0) {
                    return;
                }
                FutureTask<Map<String, Object>> f = new FutureTask<Map<String, Object>>(new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> lifecycleData = new HashMap<String, Object>(Lifecycle.getContextDataLowercase());
                        return lifecycleData;
                    }
                });
                StaticMethods.getAnalyticsExecutor().execute(f);
                try {
                    Map<String, Object> lifecycleData = f.get();
                    HashMap<String, Object> lowercaseVars = Messages.lowercaseKeysForMap(data);
                    for (Message message : piiRequests) {
                        if (!message.shouldShowForVariables(lowercaseVars, null, lifecycleData)) continue;
                        message.show();
                    }
                }
                catch (Exception e) {
                    StaticMethods.logErrorFormat("Lifecycle - Unable to get context data (%s)", e.getMessage());
                }
            }
        });
    }

    protected static void checkForInAppMessage(final Map<String, Object> vars, final Map<String, Object> cdata, final Map<String, Object> lifecycleData) {
        StaticMethods.getMessagesExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Message> messages = null;
                if (!StaticMethods.isWearableApp()) {
                    messages = MobileConfig.getInstance().getInAppMessages();
                }
                if (messages == null || messages.size() <= 0) {
                    return;
                }
                if (vars != null && vars.containsKey("pev2") && vars.get("pev2").toString().equals("ADBINTERNAL:In-App Message")) {
                    return;
                }
                HashMap<String, Object> lowercaseContextData = Messages.lowercaseKeysForMap(cdata);
                HashMap<String, Object> lowercaseVars = Messages.lowercaseKeysForMap(vars);
                for (Message message : messages) {
                    if (!message.shouldShowForVariables(lowercaseVars, lowercaseContextData, lifecycleData)) continue;
                    message.show();
                    break;
                }
            }
        });
    }

    protected static MessageFullScreen getFullScreenMessageById(String messageId) {
        ArrayList<Message> messages = null;
        MessageFullScreen messageFullScreen = null;
        if (!StaticMethods.isWearableApp()) {
            messages = MobileConfig.getInstance().getInAppMessages();
        }
        if (messages == null || messages.size() <= 0) {
            return null;
        }
        for (Message message : messages) {
            if (message.messageId == null || !message.messageId.equals(messageId) || !(message instanceof MessageFullScreen)) continue;
            messageFullScreen = (MessageFullScreen)message;
            break;
        }
        return messageFullScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setCurrentMessageFullscreen(MessageFullScreen message) {
        Object object = _messageFullScreenMutex;
        synchronized (object) {
            _messageFullScreen = message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MessageFullScreen getCurrentFullscreenMessage() {
        Object object = _messageFullScreenMutex;
        synchronized (object) {
            return _messageFullScreen;
        }
    }

    protected static void resetAllInAppMessages() {
        StaticMethods.getMessagesExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Message> messages = MobileConfig.getInstance().getInAppMessages();
                if (messages == null || messages.size() <= 0) {
                    return;
                }
                for (Message message : messages) {
                    message.isVisible = false;
                }
            }
        });
    }

    protected static void setSmallIconResourceId(int resourceId) {
        _smallIconResourceId = resourceId;
    }

    protected static int getSmallIconResourceId() {
        return _smallIconResourceId;
    }

    protected static void setLargeIconResourceId(int resourceId) {
        _largeIconResourceId = resourceId;
    }

    protected static int getLargeIconResourceId() {
        return _largeIconResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Message getCurrentMessage() {
        Object object = _currentMessageMutex;
        synchronized (object) {
            return _currentMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setCurrentMessage(Message message) {
        Object object = _currentMessageMutex;
        synchronized (object) {
            _currentMessage = message;
        }
    }

    protected static enum MessageShowRule {
        MESSAGE_SHOW_RULE_UNKNOWN(0),
        MESSAGE_SHOW_RULE_ALWAYS(1),
        MESSAGE_SHOW_RULE_ONCE(2),
        MESSAGE_SHOW_RULE_UNTIL_CLICK(3);

        private final int value;

        private MessageShowRule(int value) {
            this.value = value;
        }

        protected int getValue() {
            return this.value;
        }
    }
}

