/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import com.adobe.mobile.MessageTemplateCallback;
import com.adobe.mobile.Messages;
import com.adobe.mobile.StaticMethods;

final class MessageOpenURL
extends MessageTemplateCallback {
    private static final String ADB_TEMPLATE_OPEN_URL_LOG_PREFIX = "OpenURL";

    MessageOpenURL() {
    }

    @Override
    protected void show() {
        Activity currentActivity;
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
            return;
        }
        if (this.showRule == Messages.MessageShowRule.MESSAGE_SHOW_RULE_ONCE) {
            this.blacklist();
        }
        String expandedUrl = this.getExpandedUrl();
        StaticMethods.logDebugFormat("%s - Creating intent with uri: %s", this.logPrefix(), expandedUrl);
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)expandedUrl));
            currentActivity.startActivity(intent);
        }
        catch (Exception ex) {
            StaticMethods.logDebugFormat("%s - Could not load intent for message (%s)", this.logPrefix(), ex.toString());
        }
    }

    @Override
    protected String logPrefix() {
        return ADB_TEMPLATE_OPEN_URL_LOG_PREFIX;
    }
}

