/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.Message;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.StaticMethods;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

final class MessageAlert
extends Message {
    protected String title;
    protected String content;
    protected String url;
    protected String confirmButtonText;
    protected String cancelButtonText;
    protected AlertDialog alertDialog;
    private static final String JSON_CONFIG_TITLE = "title";
    private static final String JSON_CONFIG_CONTENT = "content";
    private static final String JSON_CONFIG_URL = "url";
    private static final String JSON_CONFIG_CONFIRM = "confirm";
    private static final String JSON_CONFIG_CANCEL = "cancel";

    MessageAlert() {
    }

    @Override
    protected boolean initWithPayloadObject(JSONObject dictionary) {
        JSONObject jsonPayload;
        if (dictionary == null || dictionary.length() <= 0) {
            return false;
        }
        if (!super.initWithPayloadObject(dictionary)) {
            return false;
        }
        try {
            jsonPayload = dictionary.getJSONObject("payload");
            if (jsonPayload.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", payload is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", payload is required", this.messageId);
            return false;
        }
        try {
            this.title = jsonPayload.getString(JSON_CONFIG_TITLE);
            if (this.title.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", title is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", title is required", this.messageId);
            return false;
        }
        try {
            this.content = jsonPayload.getString(JSON_CONFIG_CONTENT);
            if (this.content.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", content is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", content is required", this.messageId);
            return false;
        }
        try {
            this.cancelButtonText = jsonPayload.getString(JSON_CONFIG_CANCEL);
            if (this.cancelButtonText.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", cancel is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create alert message \"%s\", cancel is required", this.messageId);
            return false;
        }
        try {
            this.confirmButtonText = jsonPayload.getString(JSON_CONFIG_CONFIRM);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read \"confirm\" for alert message but found none. This is not a required field", new Object[0]);
        }
        try {
            this.url = jsonPayload.getString(JSON_CONFIG_URL);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read url for alert message but found none. This is not a required field", new Object[0]);
        }
        return true;
    }

    @Override
    protected void show() {
        if (!(this.cancelButtonText != null && this.cancelButtonText.length() >= 1 || this.confirmButtonText != null && this.confirmButtonText.length() >= 1)) {
            return;
        }
        super.show();
        this.messageTriggered();
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post((Runnable)new MessageShower(this));
    }

    protected static void clearCurrentDialog() {
        Message currentMessage = Messages.getCurrentMessage();
        if (currentMessage == null || !(currentMessage instanceof MessageAlert)) {
            return;
        }
        if (currentMessage.orientationWhenShown != StaticMethods.getCurrentOrientation()) {
            if (((MessageAlert)currentMessage).alertDialog != null && ((MessageAlert)currentMessage).alertDialog.isShowing()) {
                ((MessageAlert)currentMessage).alertDialog.dismiss();
            }
            ((MessageAlert)currentMessage).alertDialog = null;
        }
    }

    private static final class MessageShower
    implements Runnable {
        private final MessageAlert message;

        public MessageShower(MessageAlert messageToActOn) {
            this.message = messageToActOn;
        }

        @Override
        public void run() {
            Activity currentActivity;
            try {
                currentActivity = StaticMethods.getCurrentActivity();
            }
            catch (StaticMethods.NullActivityException ex) {
                StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
                return;
            }
            try {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)currentActivity);
                builder.setTitle((CharSequence)this.message.title);
                builder.setMessage((CharSequence)this.message.content);
                if (this.message.confirmButtonText != null && !this.message.confirmButtonText.isEmpty()) {
                    builder.setPositiveButton((CharSequence)this.message.confirmButtonText, (DialogInterface.OnClickListener)new PositiveClickHandler(this.message));
                }
                builder.setNegativeButton((CharSequence)this.message.cancelButtonText, (DialogInterface.OnClickListener)new NegativeClickHandler(this.message));
                builder.setOnCancelListener((DialogInterface.OnCancelListener)new CancelClickHandler(this.message));
                this.message.alertDialog = builder.create();
                this.message.alertDialog.setCanceledOnTouchOutside(false);
                this.message.alertDialog.show();
                this.message.isVisible = true;
            }
            catch (Exception ex) {
                StaticMethods.logDebugFormat("Messages - Could not show alert message (%s)", ex.toString());
            }
        }

        private static final class CancelClickHandler
        implements DialogInterface.OnCancelListener {
            private final MessageAlert message;

            public CancelClickHandler(MessageAlert messageAlert) {
                this.message = messageAlert;
            }

            public void onCancel(DialogInterface dialogInterface) {
                this.message.viewed();
                this.message.isVisible = false;
            }
        }

        private static final class NegativeClickHandler
        implements DialogInterface.OnClickListener {
            private final MessageAlert message;

            public NegativeClickHandler(MessageAlert messageToActOn) {
                this.message = messageToActOn;
            }

            public void onClick(DialogInterface dialogInterface, int i) {
                this.message.viewed();
                this.message.isVisible = false;
            }
        }

        private static final class PositiveClickHandler
        implements DialogInterface.OnClickListener {
            private final MessageAlert message;

            public PositiveClickHandler(MessageAlert messageToActOn) {
                this.message = messageToActOn;
            }

            public void onClick(DialogInterface dialogInterface, int i) {
                this.message.clickedThrough();
                this.message.isVisible = false;
                if (this.message.url != null && this.message.url.length() > 0) {
                    Activity currentActivity;
                    HashMap tokens = new HashMap();
                    HashMap<String, String> urlTokens = this.message.buildExpansionsForTokens(this.message.findTokensForExpansion(this.message.url), true);
                    urlTokens.put("{userId}", "0");
                    urlTokens.put("{trackingId}", "0");
                    urlTokens.put("{messageId}", this.message.messageId);
                    urlTokens.put("{lifetimeValue}", AnalyticsTrackLifetimeValueIncrease.getLifetimeValue().toString());
                    if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
                        urlTokens.put("{userId}", StaticMethods.getVisitorID() == null ? "" : StaticMethods.getVisitorID());
                        urlTokens.put("{trackingId}", StaticMethods.getAID() == null ? "" : StaticMethods.getAID());
                    }
                    String expansionUrl = StaticMethods.expandTokens(this.message.url, urlTokens);
                    try {
                        currentActivity = StaticMethods.getCurrentActivity();
                    }
                    catch (StaticMethods.NullActivityException ex) {
                        StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
                        return;
                    }
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)expansionUrl));
                        currentActivity.startActivity(intent);
                    }
                    catch (Exception ex) {
                        StaticMethods.logDebugFormat("Messages - Could not load click-through intent for message (%s)", ex.toString());
                    }
                }
            }
        }
    }
}

