/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.MessageAlert;
import com.adobe.mobile.MessageFullScreen;
import com.adobe.mobile.MessageLocalNotification;
import com.adobe.mobile.MessageMatcher;
import com.adobe.mobile.MessageOpenURL;
import com.adobe.mobile.MessageTemplateCallback;
import com.adobe.mobile.MessageTemplatePii;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.VisitorIDService;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class Message {
    protected String messageId;
    protected Messages.MessageShowRule showRule;
    protected Date startDate;
    protected Date endDate;
    protected boolean showOffline;
    protected boolean isVisible;
    protected int orientationWhenShown;
    protected ArrayList<ArrayList<String>> assets;
    private final SecureRandom randomGen = new SecureRandom();
    protected ArrayList<MessageMatcher> audiences;
    protected ArrayList<MessageMatcher> triggers;
    private HashMap<String, Object> _allVars;
    protected static final String MESSAGE_JSON_PAYLOAD = "payload";
    private static final String SHARED_PREFERENCES_BLACK_LIST = "messagesBlackList";
    private static final String JSON_CONFIG_MESSAGE_ID = "messageId";
    private static final String JSON_CONFIG_TEMPLATE = "template";
    private static final String JSON_CONFIG_SHOW_RULE = "showRule";
    private static final String JSON_CONFIG_START_DATE = "startDate";
    private static final String JSON_CONFIG_END_DATE = "endDate";
    private static final String JSON_CONFIG_SHOW_OFFLINE = "showOffline";
    private static final String JSON_CONFIG_AUDIENCES = "audiences";
    private static final String JSON_CONFIG_TRIGGERS = "triggers";
    protected static final String JSON_CONFIG_ASSETS = "assets";
    protected static final String MESSAGE_IMAGE_CACHE_DIR = "messageImages";
    private static final Long JSON_DEFAULT_START_DATE = 0L;
    private static final boolean JSON_DEFAULT_SHOW_OFFLINE = false;
    private static final String MESSAGE_ENUM_STRING_UNKNOWN = "unknown";
    private static final String MESSAGE_SHOW_RULE_STRING_ALWAYS = "always";
    private static final String MESSAGE_SHOW_RULE_STRING_ONCE = "once";
    private static final String MESSAGE_SHOW_RULE_STRING_UNTIL_CLICK = "untilClick";
    private static final String MESSAGE_TEMPLATE_STRING_ALERT = "alert";
    private static final String MESSAGE_TEMPLATE_STRING_FULLSCREEN = "fullscreen";
    private static final String MESSAGE_TEMPLATE_STRING_LOCAL_NOTIFICATION = "local";
    private static final String MESSAGE_TEMPLATE_STRING_CALLBACK = "callback";
    private static final String MESSAGE_TEMPLATE_STRING_PII = "pii";
    private static final String MESSAGE_TEMPLATE_STRING_OPEN_URL = "openUrl";
    private static final char ADB_TEMPLATE_TOKEN_START = '{';
    private static final char ADB_TEMPLATE_TOKEN_END = '}';
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_SDK_VERSION = "%sdkver%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_SDK_CACHEBUST = "%cachebust%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ADVERTISING_IDENTIFIER = "%adid%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_UNIX_TIMESTAMP = "%timestampu%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ISO8601_TIMESTAMP = "%timestampz%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_PUSH_IDENTIFIER = "%pushid%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_MARKETING_CLOUD_ID = "%mcid%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ALL_URL_ENCODED = "%all_url%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ALL_JSON_ENCODED = "%all_json%";
    private static final Map<String, Class> _messageTypeDictionary = new HashMap<String, Class>(){
        {
            this.put(Message.MESSAGE_TEMPLATE_STRING_LOCAL_NOTIFICATION, MessageLocalNotification.class);
            this.put(Message.MESSAGE_TEMPLATE_STRING_ALERT, MessageAlert.class);
            this.put(Message.MESSAGE_TEMPLATE_STRING_FULLSCREEN, MessageFullScreen.class);
            this.put(Message.MESSAGE_TEMPLATE_STRING_CALLBACK, MessageTemplateCallback.class);
            this.put(Message.MESSAGE_TEMPLATE_STRING_PII, MessageTemplatePii.class);
            this.put(Message.MESSAGE_TEMPLATE_STRING_OPEN_URL, MessageOpenURL.class);
        }
    };
    private static HashMap<String, Integer> _blacklist;
    private static final Object _blacklistMutex;
    private static final boolean[] tokenDataMask;
    private static final Map<String, Messages.MessageShowRule> _showRuleEnumDictionary;

    Message() {
    }

    protected static Message messageWithJsonObject(JSONObject dictionary) {
        boolean initComplete;
        Message message;
        String messageTypeString = "";
        try {
            messageTypeString = dictionary.getString(JSON_CONFIG_TEMPLATE);
            Class messageClass = _messageTypeDictionary.get(messageTypeString);
            message = (Message)messageClass.newInstance();
            initComplete = message.initWithPayloadObject(dictionary);
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - template is required for in-app message", new Object[0]);
            return null;
        }
        catch (NullPointerException ex) {
            StaticMethods.logWarningFormat("Messages - invalid template specified for message (%s)", messageTypeString);
            return null;
        }
        catch (IllegalAccessException ex) {
            StaticMethods.logWarningFormat("Messages - unable to create instance of message (%s)", ex.getMessage());
            return null;
        }
        catch (InstantiationException ex) {
            StaticMethods.logWarningFormat("Messages - unable to create instance of message (%s)", ex.getMessage());
            return null;
        }
        return initComplete ? message : null;
    }

    protected boolean initWithPayloadObject(JSONObject dictionary) {
        JSONObject matcher;
        int i;
        if (dictionary == null || dictionary.length() == 0) {
            return false;
        }
        try {
            this.messageId = dictionary.getString(JSON_CONFIG_MESSAGE_ID);
            if (this.messageId.length() <= 0) {
                StaticMethods.logWarningFormat("Messages - Unable to create message, messageId is empty", new Object[0]);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create message, messageId is required", new Object[0]);
            return false;
        }
        try {
            String showRuleString = dictionary.getString(JSON_CONFIG_SHOW_RULE);
            this.showRule = Message.messageShowRuleFromString(showRuleString);
            if (this.showRule == null || this.showRule == Messages.MessageShowRule.MESSAGE_SHOW_RULE_UNKNOWN) {
                StaticMethods.logWarningFormat("Messages - Unable to create message \"%s\", showRule not valid (%s)", this.messageId, showRuleString);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Messages - Unable to create message \"%s\", showRule is required", this.messageId);
            return false;
        }
        try {
            long startDateConfig = dictionary.getLong(JSON_CONFIG_START_DATE);
            this.startDate = new Date(startDateConfig * 1000L);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read startDate from message \"%s\" but none found. Using default value", this.messageId);
            this.startDate = new Date(JSON_DEFAULT_START_DATE * 1000L);
        }
        try {
            long endDateConfig = dictionary.getLong(JSON_CONFIG_END_DATE);
            this.endDate = new Date(endDateConfig * 1000L);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read endDate from message \"%s\" but none found. Using default value", this.messageId);
        }
        try {
            this.showOffline = dictionary.getBoolean(JSON_CONFIG_SHOW_OFFLINE);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read showOffline from message \"%s\" but none found. Using default value", this.messageId);
            this.showOffline = false;
        }
        this.audiences = new ArrayList();
        try {
            JSONArray jsonAudiences = dictionary.getJSONArray(JSON_CONFIG_AUDIENCES);
            int audienceCount = jsonAudiences.length();
            for (i = 0; i < audienceCount; ++i) {
                matcher = jsonAudiences.getJSONObject(i);
                this.audiences.add(MessageMatcher.messageMatcherWithJsonObject(matcher));
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - failed to read audience for message \"%s\", error: %s", this.messageId, ex.getMessage());
        }
        this.triggers = new ArrayList();
        try {
            JSONArray jsonTriggers = dictionary.getJSONArray(JSON_CONFIG_TRIGGERS);
            int triggersCount = jsonTriggers.length();
            for (i = 0; i < triggersCount; ++i) {
                matcher = jsonTriggers.getJSONObject(i);
                this.triggers.add(MessageMatcher.messageMatcherWithJsonObject(matcher));
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - failed to read trigger for message \"%s\", error: %s", this.messageId, ex.getMessage());
        }
        if (this.triggers.size() <= 0) {
            StaticMethods.logWarningFormat("Messages - Unable to load message \"%s\" - at least one valid trigger is required for a message", this.messageId);
            return false;
        }
        this.isVisible = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blacklist() {
        Object object = _blacklistMutex;
        synchronized (object) {
            if (_blacklist == null) {
                _blacklist = this.loadBlacklist();
            }
            _blacklist.put(this.messageId, this.showRule.getValue());
            StaticMethods.logDebugFormat("Messages - adding message \"%s\" to blacklist", this.messageId);
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putString(SHARED_PREFERENCES_BLACK_LIST, this.stringFromMap(_blacklist));
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Messages - Error persisting blacklist map (%s).", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromBlacklist() {
        if (this.isBlacklisted()) {
            Object object = _blacklistMutex;
            synchronized (object) {
                _blacklist.remove(this.messageId);
                StaticMethods.logDebugFormat("Messages - removing message \"%s\" from blacklist", this.messageId);
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.putString(SHARED_PREFERENCES_BLACK_LIST, this.stringFromMap(_blacklist));
                    editor.commit();
                }
                catch (StaticMethods.NullContextException e) {
                    StaticMethods.logErrorFormat("Messages - Error persisting blacklist map (%s).", e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBlacklisted() {
        Object object = _blacklistMutex;
        synchronized (object) {
            if (_blacklist == null) {
                _blacklist = this.loadBlacklist();
            }
            return _blacklist.get(this.messageId) != null;
        }
    }

    protected HashMap<String, Integer> loadBlacklist() {
        try {
            String blackListString = StaticMethods.getSharedPreferences().getString(SHARED_PREFERENCES_BLACK_LIST, null);
            if (blackListString == null) {
                return new HashMap<String, Integer>();
            }
            return this.mapFromString(blackListString);
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logDebugFormat("Messaging - Unable to get shared preferences while loading blacklist. (%s)", e.getMessage());
            return new HashMap<String, Integer>();
        }
    }

    protected boolean shouldShowForVariables(Map<String, Object> vars, Map<String, Object> cdata, Map<String, Object> lifecycleData) {
        HashMap<String, Object> joinedData;
        if (this.isVisible && this.orientationWhenShown != StaticMethods.getCurrentOrientation() && this instanceof MessageAlert) {
            return true;
        }
        if (Messages.getCurrentMessage() != null && !(this instanceof MessageLocalNotification) && !(this instanceof MessageTemplateCallback)) {
            return false;
        }
        HashMap<String, Object> hashMap = joinedData = cdata != null ? new HashMap<String, Object>(cdata) : new HashMap();
        if (vars != null) {
            joinedData.putAll(vars);
        }
        if (joinedData.size() <= 0) {
            return false;
        }
        joinedData.putAll(this.getExpansionTokensForVariables(joinedData));
        if (lifecycleData != null) {
            joinedData.putAll(lifecycleData);
        }
        this._allVars = new HashMap<String, Object>(joinedData);
        if (this.isBlacklisted()) {
            return false;
        }
        if (!MobileConfig.getInstance().networkConnectivity() && MobileConfig.getInstance().reachabilityChecksEnabled() && !this.showOffline) {
            return false;
        }
        Date now = new Date(StaticMethods.getTimeSince1970() * 1000L);
        if (now.before(this.startDate)) {
            return false;
        }
        if (this.endDate != null && now.after(this.endDate)) {
            return false;
        }
        for (MessageMatcher matcher : this.audiences) {
            if (matcher.matchesInMaps(lifecycleData)) continue;
            return false;
        }
        Map<String, Object> cdataCleaned = StaticMethods.cleanContextDataDictionary(cdata);
        for (MessageMatcher matcher : this.triggers) {
            if (matcher.matchesInMaps(vars, cdataCleaned)) continue;
            return false;
        }
        return true;
    }

    protected void messageTriggered() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("a.message.id", this.messageId);
        contextData.put("a.message.triggered", 1);
        AnalyticsTrackInternal.trackInternal("In-App Message", contextData, StaticMethods.getTimeSince1970());
    }

    protected void show() {
        this.orientationWhenShown = StaticMethods.getCurrentOrientation();
        if (this.showRule == Messages.MessageShowRule.MESSAGE_SHOW_RULE_ONCE) {
            this.blacklist();
        }
        if (this instanceof MessageAlert || this instanceof MessageFullScreen) {
            Messages.setCurrentMessage(this);
        }
    }

    protected void viewed() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("a.message.id", this.messageId);
        contextData.put("a.message.viewed", 1);
        AnalyticsTrackInternal.trackInternal("In-App Message", contextData, StaticMethods.getTimeSince1970());
        Messages.setCurrentMessage(null);
    }

    protected void clickedThrough() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("a.message.id", this.messageId);
        contextData.put("a.message.clicked", 1);
        AnalyticsTrackInternal.trackInternal("In-App Message", contextData, StaticMethods.getTimeSince1970());
        if (this.showRule == Messages.MessageShowRule.MESSAGE_SHOW_RULE_UNTIL_CLICK) {
            this.blacklist();
        }
        Messages.setCurrentMessage(null);
    }

    private HashMap<String, Object> getExpansionTokensForVariables(Map<String, Object> vars) {
        HashMap<String, Object> expansionTokens = new HashMap<String, Object>(9);
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_SDK_VERSION, "4.18.0-AN");
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_SDK_CACHEBUST, String.valueOf(this.randomGen.nextInt(100000000)));
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_ADVERTISING_IDENTIFIER, StaticMethods.getAdvertisingIdentifier());
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_UNIX_TIMESTAMP, String.valueOf(StaticMethods.getTimeSince1970()));
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_ISO8601_TIMESTAMP, StaticMethods.getIso8601Date());
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_PUSH_IDENTIFIER, StaticMethods.getPushIdentifier());
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_MARKETING_CLOUD_ID, VisitorIDService.sharedInstance().getMarketingCloudID() != null ? VisitorIDService.sharedInstance().getMarketingCloudID() : "");
        ArrayList<String> queryParameters = new ArrayList<String>();
        HashMap<String, String> cleanVars = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            String cleanValue = value == null ? "" : value.toString();
            String queryParameterString = StaticMethods.URLEncode(key) + "=" + StaticMethods.URLEncode(cleanValue);
            queryParameters.add(queryParameterString);
            cleanVars.put(key, cleanValue);
        }
        String joinedParams = TextUtils.join((CharSequence)"&", queryParameters);
        expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_ALL_URL_ENCODED, joinedParams);
        try {
            JSONObject jsonObject = new JSONObject(cleanVars);
            String jsonString = jsonObject.toString();
            if (jsonString.length() > 0) {
                expansionTokens.put(ADB_TEMPLATE_CALLBACK_TOKEN_ALL_JSON_ENCODED, jsonString);
            }
        }
        catch (NullPointerException ex) {
            StaticMethods.logDebugFormat("Data Callback - unable to create json string for vars:  (%s)", ex.getLocalizedMessage());
        }
        return expansionTokens;
    }

    protected HashMap<String, String> buildExpansionsForTokens(ArrayList<String> tokens, boolean urlEncodeExpansions) {
        if (tokens == null || tokens.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> expansions = new HashMap<String, String>(tokens.size());
        for (String token : tokens) {
            String cleanToken = token.substring(1, token.length() - 1).toLowerCase();
            Object tokenObject = this._allVars.get(cleanToken);
            String tokenString = tokenObject == null ? "" : tokenObject.toString();
            String tokenValue = urlEncodeExpansions ? StaticMethods.URLEncode(tokenString) : tokenString;
            expansions.put(token, tokenValue);
        }
        return expansions;
    }

    protected ArrayList<String> findTokensForExpansion(String input) {
        if (input == null || input.length() <= 0) {
            return null;
        }
        ArrayList<String> foundList = new ArrayList<String>(32);
        int inputLength = input.length();
        for (int i = 0; i < inputLength; ++i) {
            int j;
            if (input.charAt(i) != '{') continue;
            for (j = i + 1; j < inputLength && input.charAt(j) != '}'; ++j) {
            }
            if (j == inputLength) break;
            String token = input.substring(i, j + 1);
            if (!this.tokenIsValid(token.substring(1, token.length() - 1))) continue;
            foundList.add(token);
            i = j;
        }
        return foundList;
    }

    private boolean tokenIsValid(String token) {
        try {
            byte[] utf8Token;
            for (byte currentByte : utf8Token = token.getBytes("UTF-8")) {
                if (tokenDataMask[currentByte & 0xFF]) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logErrorFormat("Data Callback - Unable to validate token (%s)", ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    protected String description() {
        return "Message ID: " + this.messageId + "; Show Rule: " + this.showRule.toString() + "; Blacklisted: " + this.isBlacklisted();
    }

    private static Messages.MessageShowRule messageShowRuleFromString(String showRule) {
        return _showRuleEnumDictionary.get(showRule);
    }

    private HashMap<String, Integer> mapFromString(String string) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            JSONObject obj = new JSONObject(string);
            Iterator keys = obj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, obj.getInt(key));
            }
        }
        catch (JSONException ex) {
            StaticMethods.logErrorFormat("Messages- Unable to deserialize blacklist(%s)", ex.getMessage());
        }
        return map;
    }

    private String stringFromMap(Map<String, Integer> map) {
        JSONObject obj = new JSONObject(map);
        return obj.toString();
    }

    static {
        _blacklistMutex = new Object();
        tokenDataMask = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        _showRuleEnumDictionary = new HashMap<String, Messages.MessageShowRule>(){
            {
                this.put(Message.MESSAGE_ENUM_STRING_UNKNOWN, Messages.MessageShowRule.MESSAGE_SHOW_RULE_UNKNOWN);
                this.put(Message.MESSAGE_SHOW_RULE_STRING_ALWAYS, Messages.MessageShowRule.MESSAGE_SHOW_RULE_ALWAYS);
                this.put(Message.MESSAGE_SHOW_RULE_STRING_ONCE, Messages.MessageShowRule.MESSAGE_SHOW_RULE_ONCE);
                this.put(Message.MESSAGE_SHOW_RULE_STRING_UNTIL_CLICK, Messages.MessageShowRule.MESSAGE_SHOW_RULE_UNTIL_CLICK);
            }
        };
    }
}

