/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.net.Uri;
import com.adobe.mobile.GoogleApiClientWrapper;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.WearableDataRequest;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wearable.DataEvent;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataMapRequest;
import com.google.android.gms.wearable.Wearable;
import java.util.concurrent.TimeUnit;

public final class DataListenerHandheld {
    private static void handleRequest(DataMap requestDataMap, GoogleApiClient mGoogleApiClient, Context context) {
        if (mGoogleApiClient == null || context == null || requestDataMap == null) {
            StaticMethods.logDebugFormat("Wearable - GoogleApiClient or Context or DataMap is null", new Object[0]);
            return;
        }
        WearableDataRequest request = WearableDataRequest.createRequestFromDataMap(requestDataMap);
        if (request == null) {
            StaticMethods.logDebugFormat("Wearable - Invalid data request (%s)", requestDataMap.toString());
            return;
        }
        ConnectionResult connectionResult = GoogleApiClientWrapper.blockingConnect(mGoogleApiClient, 15000L, TimeUnit.MILLISECONDS);
        if (connectionResult == null || !connectionResult.isSuccess()) {
            StaticMethods.logDebugFormat("Wearable - Failed to setup connection", new Object[0]);
            return;
        }
        DataMap result = request.handle(context);
        PutDataMapRequest dataMapRequest = PutDataMapRequest.create((String)"/abdmobile/data/response");
        dataMapRequest.getDataMap().putAll(result);
        Wearable.DataApi.putDataItem(mGoogleApiClient, dataMapRequest.asPutDataRequest());
    }

    public static void onDataChanged(DataEventBuffer dataEvents, GoogleApiClient mGoogleApiClient, Context context) {
        if (dataEvents == null) {
            return;
        }
        for (DataEvent event : dataEvents) {
            Uri uri;
            DataItem item;
            if (event.getType() != 1 || (item = event.getDataItem()) == null || (uri = item.getUri()) == null || uri.getPath() == null || !uri.getPath().startsWith("/abdmobile/data/request")) continue;
            DataMap dataMap = DataMapItem.fromDataItem((DataItem)item).getDataMap();
            DataListenerHandheld.handleRequest(dataMap, mGoogleApiClient, context);
        }
    }
}

