/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DownloadRequest
implements Parcelable {
    public final String id;
    public final Uri uri;
    @Nullable
    public final String mimeType;
    public final List<StreamKey> streamKeys;
    @Nullable
    public final byte[] keySetId;
    @Nullable
    public final String customCacheKey;
    public final byte[] data;
    public static final Parcelable.Creator<DownloadRequest> CREATOR = new Parcelable.Creator<DownloadRequest>(){

        public DownloadRequest createFromParcel(Parcel in) {
            return new DownloadRequest(in);
        }

        public DownloadRequest[] newArray(int size) {
            return new DownloadRequest[size];
        }
    };

    private DownloadRequest(String id, Uri uri, @Nullable String mimeType, List<StreamKey> streamKeys, @Nullable byte[] keySetId, @Nullable String customCacheKey, @Nullable byte[] data) {
        int contentType = Util.inferContentTypeForUriAndMimeType(uri, mimeType);
        if (contentType == 0 || contentType == 2 || contentType == 1) {
            Assertions.checkArgument(customCacheKey == null, "customCacheKey must be null for type: " + contentType);
        }
        this.id = id;
        this.uri = uri;
        this.mimeType = mimeType;
        ArrayList<StreamKey> mutableKeys = new ArrayList<StreamKey>(streamKeys);
        Collections.sort(mutableKeys);
        this.streamKeys = Collections.unmodifiableList(mutableKeys);
        this.keySetId = keySetId != null ? Arrays.copyOf(keySetId, keySetId.length) : null;
        this.customCacheKey = customCacheKey;
        this.data = data != null ? Arrays.copyOf(data, data.length) : Util.EMPTY_BYTE_ARRAY;
    }

    DownloadRequest(Parcel in) {
        this.id = Util.castNonNull(in.readString());
        this.uri = Uri.parse((String)Util.castNonNull(in.readString()));
        this.mimeType = in.readString();
        int streamKeyCount = in.readInt();
        ArrayList<StreamKey> mutableStreamKeys = new ArrayList<StreamKey>(streamKeyCount);
        for (int i = 0; i < streamKeyCount; ++i) {
            mutableStreamKeys.add((StreamKey)in.readParcelable(StreamKey.class.getClassLoader()));
        }
        this.streamKeys = Collections.unmodifiableList(mutableStreamKeys);
        this.keySetId = in.createByteArray();
        this.customCacheKey = in.readString();
        this.data = Util.castNonNull(in.createByteArray());
    }

    public DownloadRequest copyWithId(String id) {
        return new DownloadRequest(id, this.uri, this.mimeType, this.streamKeys, this.keySetId, this.customCacheKey, this.data);
    }

    public DownloadRequest copyWithKeySetId(@Nullable byte[] keySetId) {
        return new DownloadRequest(this.id, this.uri, this.mimeType, this.streamKeys, keySetId, this.customCacheKey, this.data);
    }

    public DownloadRequest copyWithMergedRequest(DownloadRequest newRequest) {
        List<StreamKey> mergedKeys;
        Assertions.checkArgument(this.id.equals(newRequest.id));
        if (this.streamKeys.isEmpty() || newRequest.streamKeys.isEmpty()) {
            mergedKeys = Collections.emptyList();
        } else {
            mergedKeys = new ArrayList<StreamKey>(this.streamKeys);
            for (int i = 0; i < newRequest.streamKeys.size(); ++i) {
                StreamKey newKey = newRequest.streamKeys.get(i);
                if (mergedKeys.contains(newKey)) continue;
                mergedKeys.add(newKey);
            }
        }
        return new DownloadRequest(this.id, newRequest.uri, newRequest.mimeType, mergedKeys, newRequest.keySetId, newRequest.customCacheKey, newRequest.data);
    }

    public MediaItem toMediaItem() {
        return new MediaItem.Builder().setMediaId(this.id).setUri(this.uri).setCustomCacheKey(this.customCacheKey).setMimeType(this.mimeType).setStreamKeys(this.streamKeys).setDrmKeySetId(this.keySetId).build();
    }

    public String toString() {
        return this.mimeType + ":" + this.id;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof DownloadRequest)) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        return this.id.equals(that.id) && this.uri.equals((Object)that.uri) && Util.areEqual(this.mimeType, that.mimeType) && this.streamKeys.equals(that.streamKeys) && Arrays.equals(this.keySetId, that.keySetId) && Util.areEqual(this.customCacheKey, that.customCacheKey) && Arrays.equals(this.data, that.data);
    }

    public final int hashCode() {
        int result = 31 * this.id.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + this.streamKeys.hashCode();
        result = 31 * result + Arrays.hashCode(this.keySetId);
        result = 31 * result + (this.customCacheKey != null ? this.customCacheKey.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.uri.toString());
        dest.writeString(this.mimeType);
        dest.writeInt(this.streamKeys.size());
        for (int i = 0; i < this.streamKeys.size(); ++i) {
            dest.writeParcelable((Parcelable)this.streamKeys.get(i), 0);
        }
        dest.writeByteArray(this.keySetId);
        dest.writeString(this.customCacheKey);
        dest.writeByteArray(this.data);
    }

    public static class Builder {
        private final String id;
        private final Uri uri;
        @Nullable
        private String mimeType;
        @Nullable
        private List<StreamKey> streamKeys;
        @Nullable
        private byte[] keySetId;
        @Nullable
        private String customCacheKey;
        @Nullable
        private byte[] data;

        public Builder(String id, Uri uri) {
            this.id = id;
            this.uri = uri;
        }

        public Builder setMimeType(@Nullable String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys;
            return this;
        }

        public Builder setKeySetId(@Nullable byte[] keySetId) {
            this.keySetId = keySetId;
            return this;
        }

        public Builder setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        public Builder setData(@Nullable byte[] data) {
            this.data = data;
            return this;
        }

        public DownloadRequest build() {
            return new DownloadRequest(this.id, this.uri, this.mimeType, this.streamKeys != null ? this.streamKeys : ImmutableList.of(), this.keySetId, this.customCacheKey, this.data);
        }
    }

    public static class UnsupportedRequestException
    extends IOException {
    }
}

