/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.drm;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.ExoMediaCrypto;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public interface DrmSession {
    public static final int STATE_RELEASED = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_OPENING = 2;
    public static final int STATE_OPENED = 3;
    public static final int STATE_OPENED_WITH_KEYS = 4;

    public static void replaceSession(@Nullable DrmSession previousSession, @Nullable DrmSession newSession) {
        if (previousSession == newSession) {
            return;
        }
        if (newSession != null) {
            newSession.acquire(null);
        }
        if (previousSession != null) {
            previousSession.release(null);
        }
    }

    public int getState();

    default public boolean playClearSamplesWithoutKeys() {
        return false;
    }

    @Nullable
    public DrmSessionException getError();

    @Nullable
    public ExoMediaCrypto getMediaCrypto();

    @Nullable
    public Map<String, String> queryKeyStatus();

    @Nullable
    public byte[] getOfflineLicenseKeySetId();

    public void acquire(@Nullable DrmSessionEventListener.EventDispatcher var1);

    public void release(@Nullable DrmSessionEventListener.EventDispatcher var1);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    public static class DrmSessionException
    extends IOException {
        public DrmSessionException(Throwable cause) {
            super(cause);
        }
    }
}

