/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.audio.Ac3Util;
import com.akamai.amp.exoplayer2.audio.Ac4Util;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.audio.AudioCapabilities;
import com.akamai.amp.exoplayer2.audio.AudioProcessor;
import com.akamai.amp.exoplayer2.audio.AudioSink;
import com.akamai.amp.exoplayer2.audio.AudioTrackPositionTracker;
import com.akamai.amp.exoplayer2.audio.AuxEffectInfo;
import com.akamai.amp.exoplayer2.audio.ChannelMappingAudioProcessor;
import com.akamai.amp.exoplayer2.audio.DtsUtil;
import com.akamai.amp.exoplayer2.audio.FloatResamplingAudioProcessor;
import com.akamai.amp.exoplayer2.audio.MpegAudioUtil;
import com.akamai.amp.exoplayer2.audio.ResamplingAudioProcessor;
import com.akamai.amp.exoplayer2.audio.SilenceSkippingAudioProcessor;
import com.akamai.amp.exoplayer2.audio.SonicAudioProcessor;
import com.akamai.amp.exoplayer2.audio.TrimmingAudioProcessor;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DefaultAudioSink
implements AudioSink {
    public static final float DEFAULT_PLAYBACK_SPEED = 1.0f;
    public static final float MIN_PLAYBACK_SPEED = 0.1f;
    public static final float MAX_PLAYBACK_SPEED = 8.0f;
    public static final float MIN_PITCH = 0.1f;
    public static final float MAX_PITCH = 8.0f;
    private static final boolean DEFAULT_SKIP_SILENCE = false;
    private static final int OUTPUT_MODE_PCM = 0;
    private static final int OUTPUT_MODE_OFFLOAD = 1;
    private static final int OUTPUT_MODE_PASSTHROUGH = 2;
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    private static final long PASSTHROUGH_BUFFER_DURATION_US = 250000L;
    private static final long OFFLOAD_BUFFER_DURATION_US = 50000000L;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final int AC3_BUFFER_MULTIPLICATION_FACTOR = 2;
    private static final int ERROR_BAD_VALUE = -2;
    private static final int MODE_STATIC = 0;
    private static final int MODE_STREAM = 1;
    private static final int STATE_INITIALIZED = 1;
    @SuppressLint(value={"InlinedApi"})
    private static final int WRITE_NON_BLOCKING = 1;
    private static final String TAG = "AudioTrack";
    public static boolean enablePreV21AudioSessionWorkaround = false;
    public static boolean failOnSpuriousAudioTimestamp = false;
    @Nullable
    private final AudioCapabilities audioCapabilities;
    private final AudioProcessorChain audioProcessorChain;
    private final boolean enableFloatOutput;
    private final ChannelMappingAudioProcessor channelMappingAudioProcessor;
    private final TrimmingAudioProcessor trimmingAudioProcessor;
    private final AudioProcessor[] toIntPcmAvailableAudioProcessors;
    private final AudioProcessor[] toFloatPcmAvailableAudioProcessors;
    private final ConditionVariable releasingConditionVariable;
    private final AudioTrackPositionTracker audioTrackPositionTracker;
    private final ArrayDeque<MediaPositionParameters> mediaPositionParametersCheckpoints;
    private final boolean enableAudioTrackPlaybackParams;
    private final boolean enableOffload;
    private @MonotonicNonNull StreamEventCallbackV29 offloadStreamEventCallbackV29;
    @Nullable
    private AudioSink.Listener listener;
    @Nullable
    private AudioTrack keepSessionIdAudioTrack;
    @Nullable
    private Configuration pendingConfiguration;
    private @MonotonicNonNull Configuration configuration;
    @Nullable
    private AudioTrack audioTrack;
    private AudioAttributes audioAttributes;
    @Nullable
    private MediaPositionParameters afterDrainParameters;
    private MediaPositionParameters mediaPositionParameters;
    private PlaybackParameters audioTrackPlaybackParameters;
    @Nullable
    private ByteBuffer avSyncHeader;
    private int bytesUntilNextAvSync;
    private long submittedPcmBytes;
    private long submittedEncodedFrames;
    private long writtenPcmBytes;
    private long writtenEncodedFrames;
    private int framesPerEncodedSample;
    private boolean startMediaTimeUsNeedsSync;
    private boolean startMediaTimeUsNeedsInit;
    private long startMediaTimeUs;
    private float volume;
    private AudioProcessor[] activeAudioProcessors;
    private ByteBuffer[] outputBuffers;
    @Nullable
    private ByteBuffer inputBuffer;
    private int inputBufferAccessUnitCount;
    @Nullable
    private ByteBuffer outputBuffer;
    private @MonotonicNonNull byte[] preV21OutputBuffer;
    private int preV21OutputBufferOffset;
    private int drainingAudioProcessorIndex;
    private boolean handledEndOfStream;
    private boolean stoppedAudioTrack;
    private boolean playing;
    private int audioSessionId;
    private AuxEffectInfo auxEffectInfo;
    private boolean tunneling;
    private long lastFeedElapsedRealtimeMs;
    private boolean offloadDisabledUntilNextConfiguration;
    private boolean isWaitingForOffloadEndOfStreamHandled;

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessors) {
        this(audioCapabilities, audioProcessors, false);
    }

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessors, boolean enableFloatOutput) {
        this(audioCapabilities, new DefaultAudioProcessorChain(audioProcessors), enableFloatOutput, false, false);
    }

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessorChain audioProcessorChain, boolean enableFloatOutput, boolean enableAudioTrackPlaybackParams, boolean enableOffload) {
        this.audioCapabilities = audioCapabilities;
        this.audioProcessorChain = Assertions.checkNotNull(audioProcessorChain);
        this.enableFloatOutput = Util.SDK_INT >= 21 && enableFloatOutput;
        this.enableAudioTrackPlaybackParams = Util.SDK_INT >= 23 && enableAudioTrackPlaybackParams;
        this.enableOffload = Util.SDK_INT >= 29 && enableOffload;
        this.releasingConditionVariable = new ConditionVariable(true);
        this.audioTrackPositionTracker = new AudioTrackPositionTracker(new PositionTrackerListener());
        this.channelMappingAudioProcessor = new ChannelMappingAudioProcessor();
        this.trimmingAudioProcessor = new TrimmingAudioProcessor();
        ArrayList toIntPcmAudioProcessors = new ArrayList();
        Collections.addAll(toIntPcmAudioProcessors, new ResamplingAudioProcessor(), this.channelMappingAudioProcessor, this.trimmingAudioProcessor);
        Collections.addAll(toIntPcmAudioProcessors, audioProcessorChain.getAudioProcessors());
        this.toIntPcmAvailableAudioProcessors = toIntPcmAudioProcessors.toArray(new AudioProcessor[0]);
        this.toFloatPcmAvailableAudioProcessors = new AudioProcessor[]{new FloatResamplingAudioProcessor()};
        this.volume = 1.0f;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.audioSessionId = 0;
        this.auxEffectInfo = new AuxEffectInfo(0, 0.0f);
        this.mediaPositionParameters = new MediaPositionParameters(PlaybackParameters.DEFAULT, false, 0L, 0L);
        this.audioTrackPlaybackParameters = PlaybackParameters.DEFAULT;
        this.drainingAudioProcessorIndex = -1;
        this.activeAudioProcessors = new AudioProcessor[0];
        this.outputBuffers = new ByteBuffer[0];
        this.mediaPositionParametersCheckpoints = new ArrayDeque();
    }

    @Override
    public void setListener(AudioSink.Listener listener) {
        this.listener = listener;
    }

    @Override
    public boolean supportsFormat(Format format) {
        return this.getFormatSupport(format) != 0;
    }

    @Override
    public int getFormatSupport(Format format) {
        if ("audio/raw".equals(format.sampleMimeType)) {
            if (!Util.isEncodingLinearPcm(format.pcmEncoding)) {
                Log.w(TAG, "Invalid PCM encoding: " + format.pcmEncoding);
                return 0;
            }
            if (format.pcmEncoding == 2 || this.enableFloatOutput && format.pcmEncoding == 4) {
                return 2;
            }
            return 1;
        }
        if (this.enableOffload && !this.offloadDisabledUntilNextConfiguration && DefaultAudioSink.isOffloadedPlaybackSupported(format, this.audioAttributes)) {
            return 2;
        }
        if (DefaultAudioSink.isPassthroughPlaybackSupported(format, this.audioCapabilities)) {
            return 2;
        }
        return 0;
    }

    @Override
    public long getCurrentPositionUs(boolean sourceEnded) {
        if (!this.isAudioTrackInitialized() || this.startMediaTimeUsNeedsInit) {
            return Long.MIN_VALUE;
        }
        long positionUs = this.audioTrackPositionTracker.getCurrentPositionUs(sourceEnded);
        positionUs = Math.min(positionUs, this.configuration.framesToDurationUs(this.getWrittenFrames()));
        return this.applySkipping(this.applyMediaPositionParameters(positionUs));
    }

    @Override
    public void configure(Format inputFormat, int specifiedBufferSize, @Nullable int[] outputChannels) throws AudioSink.ConfigurationException {
        int outputPcmFrameSize;
        int outputChannelConfig;
        int outputSampleRate;
        int outputEncoding;
        int outputMode;
        boolean canApplyPlaybackParameters;
        AudioProcessor[] availableAudioProcessors;
        int inputPcmFrameSize;
        if ("audio/raw".equals(inputFormat.sampleMimeType)) {
            Assertions.checkArgument(Util.isEncodingLinearPcm(inputFormat.pcmEncoding));
            inputPcmFrameSize = Util.getPcmFrameSize(inputFormat.pcmEncoding, inputFormat.channelCount);
            boolean useFloatOutput = this.enableFloatOutput && Util.isEncodingHighResolutionPcm(inputFormat.pcmEncoding);
            availableAudioProcessors = useFloatOutput ? this.toFloatPcmAvailableAudioProcessors : this.toIntPcmAvailableAudioProcessors;
            canApplyPlaybackParameters = !useFloatOutput;
            this.trimmingAudioProcessor.setTrimFrameCount(inputFormat.encoderDelay, inputFormat.encoderPadding);
            if (Util.SDK_INT < 21 && inputFormat.channelCount == 8 && outputChannels == null) {
                outputChannels = new int[6];
                for (int i = 0; i < outputChannels.length; ++i) {
                    outputChannels[i] = i;
                }
            }
            this.channelMappingAudioProcessor.setChannelMap(outputChannels);
            AudioProcessor.AudioFormat outputFormat = new AudioProcessor.AudioFormat(inputFormat.sampleRate, inputFormat.channelCount, inputFormat.pcmEncoding);
            for (AudioProcessor audioProcessor : availableAudioProcessors) {
                try {
                    AudioProcessor.AudioFormat nextFormat = audioProcessor.configure(outputFormat);
                    if (!audioProcessor.isActive()) continue;
                    outputFormat = nextFormat;
                }
                catch (AudioProcessor.UnhandledAudioFormatException e) {
                    throw new AudioSink.ConfigurationException(e);
                }
            }
            outputMode = 0;
            outputEncoding = outputFormat.encoding;
            outputSampleRate = outputFormat.sampleRate;
            outputChannelConfig = Util.getAudioTrackChannelConfig(outputFormat.channelCount);
            outputPcmFrameSize = Util.getPcmFrameSize(outputEncoding, outputFormat.channelCount);
        } else {
            inputPcmFrameSize = -1;
            availableAudioProcessors = new AudioProcessor[]{};
            canApplyPlaybackParameters = false;
            outputSampleRate = inputFormat.sampleRate;
            outputPcmFrameSize = -1;
            if (this.enableOffload && DefaultAudioSink.isOffloadedPlaybackSupported(inputFormat, this.audioAttributes)) {
                outputMode = 1;
                outputEncoding = MimeTypes.getEncoding(Assertions.checkNotNull(inputFormat.sampleMimeType), inputFormat.codecs);
                outputChannelConfig = Util.getAudioTrackChannelConfig(inputFormat.channelCount);
            } else {
                outputMode = 2;
                Pair<Integer, Integer> encodingAndChannelConfig = DefaultAudioSink.getEncodingAndChannelConfigForPassthrough(inputFormat, this.audioCapabilities);
                if (encodingAndChannelConfig == null) {
                    throw new AudioSink.ConfigurationException("Unable to configure passthrough for: " + inputFormat);
                }
                outputEncoding = (Integer)encodingAndChannelConfig.first;
                outputChannelConfig = (Integer)encodingAndChannelConfig.second;
            }
        }
        if (outputEncoding == 0) {
            throw new AudioSink.ConfigurationException("Invalid output encoding (mode=" + outputMode + ") for: " + inputFormat);
        }
        if (outputChannelConfig == 0) {
            throw new AudioSink.ConfigurationException("Invalid output channel config (mode=" + outputMode + ") for: " + inputFormat);
        }
        this.offloadDisabledUntilNextConfiguration = false;
        Configuration pendingConfiguration = new Configuration(inputFormat, inputPcmFrameSize, outputMode, outputPcmFrameSize, outputSampleRate, outputChannelConfig, outputEncoding, specifiedBufferSize, this.enableAudioTrackPlaybackParams, canApplyPlaybackParameters, availableAudioProcessors);
        if (this.isAudioTrackInitialized()) {
            this.pendingConfiguration = pendingConfiguration;
        } else {
            this.configuration = pendingConfiguration;
        }
    }

    private void setupAudioProcessors() {
        AudioProcessor[] audioProcessors = this.configuration.availableAudioProcessors;
        ArrayList<AudioProcessor> newAudioProcessors = new ArrayList<AudioProcessor>();
        for (AudioProcessor audioProcessor : audioProcessors) {
            if (audioProcessor.isActive()) {
                newAudioProcessors.add(audioProcessor);
                continue;
            }
            audioProcessor.flush();
        }
        int count = newAudioProcessors.size();
        this.activeAudioProcessors = newAudioProcessors.toArray(new AudioProcessor[count]);
        this.outputBuffers = new ByteBuffer[count];
        this.flushAudioProcessors();
    }

    private void flushAudioProcessors() {
        for (int i = 0; i < this.activeAudioProcessors.length; ++i) {
            AudioProcessor audioProcessor = this.activeAudioProcessors[i];
            audioProcessor.flush();
            this.outputBuffers[i] = audioProcessor.getOutput();
        }
    }

    private void initializeAudioTrack() throws AudioSink.InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = this.buildAudioTrack();
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            this.registerStreamEventCallbackV29(this.audioTrack);
            this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
        }
        int audioSessionId = this.audioTrack.getAudioSessionId();
        if (enablePreV21AudioSessionWorkaround && Util.SDK_INT < 21) {
            if (this.keepSessionIdAudioTrack != null && audioSessionId != this.keepSessionIdAudioTrack.getAudioSessionId()) {
                this.releaseKeepSessionIdAudioTrack();
            }
            if (this.keepSessionIdAudioTrack == null) {
                this.keepSessionIdAudioTrack = DefaultAudioSink.initializeKeepSessionIdAudioTrack(audioSessionId);
            }
        }
        if (this.audioSessionId != audioSessionId) {
            this.audioSessionId = audioSessionId;
            if (this.listener != null) {
                this.listener.onAudioSessionId(audioSessionId);
            }
        }
        this.audioTrackPositionTracker.setAudioTrack(this.audioTrack, this.configuration.outputMode == 2, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.setVolumeInternal();
        if (this.auxEffectInfo.effectId != 0) {
            this.audioTrack.attachAuxEffect(this.auxEffectInfo.effectId);
            this.audioTrack.setAuxEffectSendLevel(this.auxEffectInfo.sendLevel);
        }
        this.startMediaTimeUsNeedsInit = true;
    }

    @Override
    public void play() {
        this.playing = true;
        if (this.isAudioTrackInitialized()) {
            this.audioTrackPositionTracker.start();
            this.audioTrack.play();
        }
    }

    @Override
    public void handleDiscontinuity() {
        this.startMediaTimeUsNeedsSync = true;
    }

    @Override
    public boolean handleBuffer(ByteBuffer buffer, long presentationTimeUs, int encodedAccessUnitCount) throws AudioSink.InitializationException, AudioSink.WriteException {
        Assertions.checkArgument(this.inputBuffer == null || buffer == this.inputBuffer);
        if (this.pendingConfiguration != null) {
            if (!this.drainToEndOfStream()) {
                return false;
            }
            if (!this.pendingConfiguration.canReuseAudioTrack(this.configuration)) {
                this.playPendingData();
                if (this.hasPendingData()) {
                    return false;
                }
                this.flush();
            } else {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
                if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
                    this.audioTrack.setOffloadEndOfStream();
                    this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
                    this.isWaitingForOffloadEndOfStreamHandled = true;
                }
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
        }
        if (!this.isAudioTrackInitialized()) {
            this.initializeAudioTrack();
        }
        if (this.startMediaTimeUsNeedsInit) {
            this.startMediaTimeUs = Math.max(0L, presentationTimeUs);
            this.startMediaTimeUsNeedsSync = false;
            this.startMediaTimeUsNeedsInit = false;
            if (this.enableAudioTrackPlaybackParams && Util.SDK_INT >= 23) {
                this.setAudioTrackPlaybackParametersV23(this.audioTrackPlaybackParameters);
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
            if (this.playing) {
                this.play();
            }
        }
        if (!this.audioTrackPositionTracker.mayHandleBuffer(this.getWrittenFrames())) {
            return false;
        }
        if (this.inputBuffer == null) {
            Assertions.checkArgument(buffer.order() == ByteOrder.LITTLE_ENDIAN);
            if (!buffer.hasRemaining()) {
                return true;
            }
            if (this.configuration.outputMode != 0 && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = DefaultAudioSink.getFramesPerEncodedSample(this.configuration.outputEncoding, buffer);
                if (this.framesPerEncodedSample == 0) {
                    return true;
                }
            }
            if (this.afterDrainParameters != null) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
                this.afterDrainParameters = null;
            }
            long expectedPresentationTimeUs = this.startMediaTimeUs + this.configuration.inputFramesToDurationUs(this.getSubmittedFrames() - this.trimmingAudioProcessor.getTrimmedFrameCount());
            if (!this.startMediaTimeUsNeedsSync && Math.abs(expectedPresentationTimeUs - presentationTimeUs) > 200000L) {
                Log.e(TAG, "Discontinuity detected [expected " + expectedPresentationTimeUs + ", got " + presentationTimeUs + "]");
                this.startMediaTimeUsNeedsSync = true;
            }
            if (this.startMediaTimeUsNeedsSync) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                long adjustmentUs = presentationTimeUs - expectedPresentationTimeUs;
                this.startMediaTimeUs += adjustmentUs;
                this.startMediaTimeUsNeedsSync = false;
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
                if (this.listener != null && adjustmentUs != 0L) {
                    this.listener.onPositionDiscontinuity();
                }
            }
            if (this.configuration.outputMode == 0) {
                this.submittedPcmBytes += (long)buffer.remaining();
            } else {
                this.submittedEncodedFrames += (long)(this.framesPerEncodedSample * encodedAccessUnitCount);
            }
            this.inputBuffer = buffer;
            this.inputBufferAccessUnitCount = encodedAccessUnitCount;
        }
        this.processBuffers(presentationTimeUs);
        if (!this.inputBuffer.hasRemaining()) {
            this.inputBuffer = null;
            this.inputBufferAccessUnitCount = 0;
            return true;
        }
        if (this.audioTrackPositionTracker.isStalled(this.getWrittenFrames())) {
            Log.w(TAG, "Resetting stalled audio track");
            this.flush();
            return true;
        }
        return false;
    }

    private AudioTrack buildAudioTrack() throws AudioSink.InitializationException {
        try {
            return Assertions.checkNotNull(this.configuration).buildAudioTrack(this.tunneling, this.audioAttributes, this.audioSessionId);
        }
        catch (AudioSink.InitializationException e) {
            this.maybeDisableOffload();
            throw e;
        }
    }

    @RequiresApi(value=29)
    private void registerStreamEventCallbackV29(AudioTrack audioTrack) {
        if (this.offloadStreamEventCallbackV29 == null) {
            this.offloadStreamEventCallbackV29 = new StreamEventCallbackV29();
        }
        this.offloadStreamEventCallbackV29.register(audioTrack);
    }

    private void processBuffers(long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        int count;
        int index = count = this.activeAudioProcessors.length;
        while (index >= 0) {
            ByteBuffer input;
            ByteBuffer byteBuffer = index > 0 ? this.outputBuffers[index - 1] : (input = this.inputBuffer != null ? this.inputBuffer : AudioProcessor.EMPTY_BUFFER);
            if (index == count) {
                this.writeBuffer(input, avSyncPresentationTimeUs);
            } else {
                ByteBuffer output;
                AudioProcessor audioProcessor = this.activeAudioProcessors[index];
                if (index > this.drainingAudioProcessorIndex) {
                    audioProcessor.queueInput(input);
                }
                this.outputBuffers[index] = output = audioProcessor.getOutput();
                if (output.hasRemaining()) {
                    ++index;
                    continue;
                }
            }
            if (input.hasRemaining()) {
                return;
            }
            --index;
        }
    }

    private void writeBuffer(ByteBuffer buffer, long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        int bytesRemaining;
        if (!buffer.hasRemaining()) {
            return;
        }
        if (this.outputBuffer != null) {
            Assertions.checkArgument(this.outputBuffer == buffer);
        } else {
            this.outputBuffer = buffer;
            if (Util.SDK_INT < 21) {
                bytesRemaining = buffer.remaining();
                if (this.preV21OutputBuffer == null || this.preV21OutputBuffer.length < bytesRemaining) {
                    this.preV21OutputBuffer = new byte[bytesRemaining];
                }
                int originalPosition = buffer.position();
                buffer.get(this.preV21OutputBuffer, 0, bytesRemaining);
                buffer.position(originalPosition);
                this.preV21OutputBufferOffset = 0;
            }
        }
        bytesRemaining = buffer.remaining();
        int bytesWritten = 0;
        if (Util.SDK_INT < 21) {
            int bytesToWrite = this.audioTrackPositionTracker.getAvailableBufferSize(this.writtenPcmBytes);
            if (bytesToWrite > 0 && (bytesWritten = this.audioTrack.write(this.preV21OutputBuffer, this.preV21OutputBufferOffset, bytesToWrite = Math.min(bytesRemaining, bytesToWrite))) > 0) {
                this.preV21OutputBufferOffset += bytesWritten;
                buffer.position(buffer.position() + bytesWritten);
            }
        } else if (this.tunneling) {
            Assertions.checkState(avSyncPresentationTimeUs != -9223372036854775807L);
            bytesWritten = this.writeNonBlockingWithAvSyncV21(this.audioTrack, buffer, bytesRemaining, avSyncPresentationTimeUs);
        } else {
            bytesWritten = DefaultAudioSink.writeNonBlockingV21(this.audioTrack, buffer, bytesRemaining);
        }
        this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        if (bytesWritten < 0) {
            boolean isRecoverable = DefaultAudioSink.isAudioTrackDeadObject(bytesWritten);
            if (isRecoverable) {
                this.maybeDisableOffload();
            }
            throw new AudioSink.WriteException(bytesWritten);
        }
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            if (this.writtenEncodedFrames > 0L) {
                this.isWaitingForOffloadEndOfStreamHandled = false;
            }
            if (this.playing && this.listener != null && bytesWritten < bytesRemaining && !this.isWaitingForOffloadEndOfStreamHandled) {
                long pendingDurationMs = this.audioTrackPositionTracker.getPendingBufferDurationMs(this.writtenEncodedFrames);
                this.listener.onOffloadBufferFull(pendingDurationMs);
            }
        }
        if (this.configuration.outputMode == 0) {
            this.writtenPcmBytes += (long)bytesWritten;
        }
        if (bytesWritten == bytesRemaining) {
            if (this.configuration.outputMode != 0) {
                Assertions.checkState(buffer == this.inputBuffer);
                this.writtenEncodedFrames += (long)(this.framesPerEncodedSample * this.inputBufferAccessUnitCount);
            }
            this.outputBuffer = null;
        }
    }

    @Override
    public void playToEndOfStream() throws AudioSink.WriteException {
        if (!this.handledEndOfStream && this.isAudioTrackInitialized() && this.drainToEndOfStream()) {
            this.playPendingData();
            this.handledEndOfStream = true;
        }
    }

    private void maybeDisableOffload() {
        if (!this.configuration.outputModeIsOffload()) {
            return;
        }
        this.offloadDisabledUntilNextConfiguration = true;
    }

    private static boolean isAudioTrackDeadObject(int status) {
        return Util.SDK_INT >= 24 && status == -6;
    }

    private boolean drainToEndOfStream() throws AudioSink.WriteException {
        boolean audioProcessorNeedsEndOfStream = false;
        if (this.drainingAudioProcessorIndex == -1) {
            this.drainingAudioProcessorIndex = 0;
            audioProcessorNeedsEndOfStream = true;
        }
        while (this.drainingAudioProcessorIndex < this.activeAudioProcessors.length) {
            AudioProcessor audioProcessor = this.activeAudioProcessors[this.drainingAudioProcessorIndex];
            if (audioProcessorNeedsEndOfStream) {
                audioProcessor.queueEndOfStream();
            }
            this.processBuffers(-9223372036854775807L);
            if (!audioProcessor.isEnded()) {
                return false;
            }
            audioProcessorNeedsEndOfStream = true;
            ++this.drainingAudioProcessorIndex;
        }
        if (this.outputBuffer != null) {
            this.writeBuffer(this.outputBuffer, -9223372036854775807L);
            if (this.outputBuffer != null) {
                return false;
            }
        }
        this.drainingAudioProcessorIndex = -1;
        return true;
    }

    @Override
    public boolean isEnded() {
        return !this.isAudioTrackInitialized() || this.handledEndOfStream && !this.hasPendingData();
    }

    @Override
    public boolean hasPendingData() {
        return this.isAudioTrackInitialized() && this.audioTrackPositionTracker.hasPendingData(this.getWrittenFrames());
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        playbackParameters = new PlaybackParameters(Util.constrainValue(playbackParameters.speed, 0.1f, 8.0f), Util.constrainValue(playbackParameters.pitch, 0.1f, 8.0f));
        if (this.enableAudioTrackPlaybackParams && Util.SDK_INT >= 23) {
            this.setAudioTrackPlaybackParametersV23(playbackParameters);
        } else {
            this.setAudioProcessorPlaybackParametersAndSkipSilence(playbackParameters, this.getSkipSilenceEnabled());
        }
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.enableAudioTrackPlaybackParams ? this.audioTrackPlaybackParameters : this.getAudioProcessorPlaybackParameters();
    }

    @Override
    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
        this.setAudioProcessorPlaybackParametersAndSkipSilence(this.getAudioProcessorPlaybackParameters(), skipSilenceEnabled);
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.getMediaPositionParameters().skipSilence;
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        if (this.audioAttributes.equals(audioAttributes)) {
            return;
        }
        this.audioAttributes = audioAttributes;
        if (this.tunneling) {
            return;
        }
        this.flush();
        this.audioSessionId = 0;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        if (this.audioSessionId != audioSessionId) {
            this.audioSessionId = audioSessionId;
            this.flush();
        }
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        if (this.auxEffectInfo.equals(auxEffectInfo)) {
            return;
        }
        int effectId = auxEffectInfo.effectId;
        float sendLevel = auxEffectInfo.sendLevel;
        if (this.audioTrack != null) {
            if (this.auxEffectInfo.effectId != effectId) {
                this.audioTrack.attachAuxEffect(effectId);
            }
            if (effectId != 0) {
                this.audioTrack.setAuxEffectSendLevel(sendLevel);
            }
        }
        this.auxEffectInfo = auxEffectInfo;
    }

    @Override
    public void enableTunnelingV21(int tunnelingAudioSessionId) {
        Assertions.checkState(Util.SDK_INT >= 21);
        if (!this.tunneling || this.audioSessionId != tunnelingAudioSessionId) {
            this.tunneling = true;
            this.audioSessionId = tunnelingAudioSessionId;
            this.flush();
        }
    }

    @Override
    public void disableTunneling() {
        if (this.tunneling) {
            this.tunneling = false;
            this.audioSessionId = 0;
            this.flush();
        }
    }

    @Override
    public void setVolume(float volume) {
        if (this.volume != volume) {
            this.volume = volume;
            this.setVolumeInternal();
        }
    }

    private void setVolumeInternal() {
        if (this.isAudioTrackInitialized()) {
            if (Util.SDK_INT >= 21) {
                DefaultAudioSink.setVolumeInternalV21(this.audioTrack, this.volume);
            } else {
                DefaultAudioSink.setVolumeInternalV3(this.audioTrack, this.volume);
            }
        }
    }

    @Override
    public void pause() {
        this.playing = false;
        if (this.isAudioTrackInitialized() && this.audioTrackPositionTracker.pause()) {
            this.audioTrack.pause();
        }
    }

    @Override
    public void flush() {
        if (this.isAudioTrackInitialized()) {
            this.resetSinkStateForFlush();
            if (this.audioTrackPositionTracker.isPlaying()) {
                this.audioTrack.pause();
            }
            if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
                Assertions.checkNotNull(this.offloadStreamEventCallbackV29).unregister(this.audioTrack);
            }
            final AudioTrack toRelease = this.audioTrack;
            this.audioTrack = null;
            if (this.pendingConfiguration != null) {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
            }
            this.audioTrackPositionTracker.reset();
            this.releasingConditionVariable.close();
            new Thread("ExoPlayer:AudioTrackReleaseThread"){

                @Override
                public void run() {
                    try {
                        toRelease.flush();
                        toRelease.release();
                    }
                    finally {
                        DefaultAudioSink.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    @Override
    public void experimentalFlushWithoutAudioTrackRelease() {
        if (Util.SDK_INT < 25) {
            this.flush();
            return;
        }
        if (!this.isAudioTrackInitialized()) {
            return;
        }
        this.resetSinkStateForFlush();
        if (this.audioTrackPositionTracker.isPlaying()) {
            this.audioTrack.pause();
        }
        this.audioTrack.flush();
        this.audioTrackPositionTracker.reset();
        this.audioTrackPositionTracker.setAudioTrack(this.audioTrack, this.configuration.outputMode == 2, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.startMediaTimeUsNeedsInit = true;
    }

    @Override
    public void reset() {
        this.flush();
        this.releaseKeepSessionIdAudioTrack();
        for (AudioProcessor audioProcessor : this.toIntPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        for (AudioProcessor audioProcessor : this.toFloatPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        this.audioSessionId = 0;
        this.playing = false;
        this.offloadDisabledUntilNextConfiguration = false;
    }

    private void resetSinkStateForFlush() {
        this.submittedPcmBytes = 0L;
        this.submittedEncodedFrames = 0L;
        this.writtenPcmBytes = 0L;
        this.writtenEncodedFrames = 0L;
        this.isWaitingForOffloadEndOfStreamHandled = false;
        this.framesPerEncodedSample = 0;
        this.mediaPositionParameters = new MediaPositionParameters(this.getAudioProcessorPlaybackParameters(), this.getSkipSilenceEnabled(), 0L, 0L);
        this.startMediaTimeUs = 0L;
        this.afterDrainParameters = null;
        this.mediaPositionParametersCheckpoints.clear();
        this.inputBuffer = null;
        this.inputBufferAccessUnitCount = 0;
        this.outputBuffer = null;
        this.stoppedAudioTrack = false;
        this.handledEndOfStream = false;
        this.drainingAudioProcessorIndex = -1;
        this.avSyncHeader = null;
        this.bytesUntilNextAvSync = 0;
        this.trimmingAudioProcessor.resetTrimmedFrameCount();
        this.flushAudioProcessors();
    }

    private void releaseKeepSessionIdAudioTrack() {
        if (this.keepSessionIdAudioTrack == null) {
            return;
        }
        final AudioTrack toRelease = this.keepSessionIdAudioTrack;
        this.keepSessionIdAudioTrack = null;
        new Thread(){

            @Override
            public void run() {
                toRelease.release();
            }
        }.start();
    }

    @RequiresApi(value=23)
    private void setAudioTrackPlaybackParametersV23(PlaybackParameters audioTrackPlaybackParameters) {
        if (this.isAudioTrackInitialized()) {
            PlaybackParams playbackParams = new PlaybackParams().allowDefaults().setSpeed(audioTrackPlaybackParameters.speed).setPitch(audioTrackPlaybackParameters.pitch).setAudioFallbackMode(2);
            try {
                this.audioTrack.setPlaybackParams(playbackParams);
            }
            catch (IllegalArgumentException e) {
                Log.w(TAG, "Failed to set playback params", e);
            }
            audioTrackPlaybackParameters = new PlaybackParameters(this.audioTrack.getPlaybackParams().getSpeed(), this.audioTrack.getPlaybackParams().getPitch());
            this.audioTrackPositionTracker.setAudioTrackPlaybackSpeed(audioTrackPlaybackParameters.speed);
        }
        this.audioTrackPlaybackParameters = audioTrackPlaybackParameters;
    }

    private void setAudioProcessorPlaybackParametersAndSkipSilence(PlaybackParameters playbackParameters, boolean skipSilence) {
        MediaPositionParameters currentMediaPositionParameters = this.getMediaPositionParameters();
        if (!playbackParameters.equals(currentMediaPositionParameters.playbackParameters) || skipSilence != currentMediaPositionParameters.skipSilence) {
            MediaPositionParameters mediaPositionParameters = new MediaPositionParameters(playbackParameters, skipSilence, -9223372036854775807L, -9223372036854775807L);
            if (this.isAudioTrackInitialized()) {
                this.afterDrainParameters = mediaPositionParameters;
            } else {
                this.mediaPositionParameters = mediaPositionParameters;
            }
        }
    }

    private PlaybackParameters getAudioProcessorPlaybackParameters() {
        return this.getMediaPositionParameters().playbackParameters;
    }

    private MediaPositionParameters getMediaPositionParameters() {
        return this.afterDrainParameters != null ? this.afterDrainParameters : (!this.mediaPositionParametersCheckpoints.isEmpty() ? this.mediaPositionParametersCheckpoints.getLast() : this.mediaPositionParameters);
    }

    private void applyAudioProcessorPlaybackParametersAndSkipSilence(long presentationTimeUs) {
        PlaybackParameters playbackParameters = this.configuration.canApplyPlaybackParameters ? this.audioProcessorChain.applyPlaybackParameters(this.getAudioProcessorPlaybackParameters()) : PlaybackParameters.DEFAULT;
        boolean skipSilenceEnabled = this.configuration.canApplyPlaybackParameters ? this.audioProcessorChain.applySkipSilenceEnabled(this.getSkipSilenceEnabled()) : false;
        this.mediaPositionParametersCheckpoints.add(new MediaPositionParameters(playbackParameters, skipSilenceEnabled, Math.max(0L, presentationTimeUs), this.configuration.framesToDurationUs(this.getWrittenFrames())));
        this.setupAudioProcessors();
        if (this.listener != null) {
            this.listener.onSkipSilenceEnabledChanged(skipSilenceEnabled);
        }
    }

    private long applyMediaPositionParameters(long positionUs) {
        while (!this.mediaPositionParametersCheckpoints.isEmpty() && positionUs >= this.mediaPositionParametersCheckpoints.getFirst().audioTrackPositionUs) {
            this.mediaPositionParameters = this.mediaPositionParametersCheckpoints.remove();
        }
        long playoutDurationSinceLastCheckpointUs = positionUs - this.mediaPositionParameters.audioTrackPositionUs;
        if (this.mediaPositionParameters.playbackParameters.equals(PlaybackParameters.DEFAULT)) {
            return this.mediaPositionParameters.mediaTimeUs + playoutDurationSinceLastCheckpointUs;
        }
        if (this.mediaPositionParametersCheckpoints.isEmpty()) {
            long mediaDurationSinceLastCheckpointUs = this.audioProcessorChain.getMediaDuration(playoutDurationSinceLastCheckpointUs);
            return this.mediaPositionParameters.mediaTimeUs + mediaDurationSinceLastCheckpointUs;
        }
        MediaPositionParameters nextMediaPositionParameters = this.mediaPositionParametersCheckpoints.getFirst();
        long playoutDurationUntilNextCheckpointUs = nextMediaPositionParameters.audioTrackPositionUs - positionUs;
        long mediaDurationUntilNextCheckpointUs = Util.getMediaDurationForPlayoutDuration(playoutDurationUntilNextCheckpointUs, this.mediaPositionParameters.playbackParameters.speed);
        return nextMediaPositionParameters.mediaTimeUs - mediaDurationUntilNextCheckpointUs;
    }

    private long applySkipping(long positionUs) {
        return positionUs + this.configuration.framesToDurationUs(this.audioProcessorChain.getSkippedOutputFrameCount());
    }

    private boolean isAudioTrackInitialized() {
        return this.audioTrack != null;
    }

    private long getSubmittedFrames() {
        return this.configuration.outputMode == 0 ? this.submittedPcmBytes / (long)this.configuration.inputPcmFrameSize : this.submittedEncodedFrames;
    }

    private long getWrittenFrames() {
        return this.configuration.outputMode == 0 ? this.writtenPcmBytes / (long)this.configuration.outputPcmFrameSize : this.writtenEncodedFrames;
    }

    private static boolean isPassthroughPlaybackSupported(Format format, @Nullable AudioCapabilities audioCapabilities) {
        return DefaultAudioSink.getEncodingAndChannelConfigForPassthrough(format, audioCapabilities) != null;
    }

    @Nullable
    private static Pair<Integer, Integer> getEncodingAndChannelConfigForPassthrough(Format format, @Nullable AudioCapabilities audioCapabilities) {
        int channelCount;
        boolean supportedEncoding;
        if (audioCapabilities == null) {
            return null;
        }
        int encoding = MimeTypes.getEncoding(Assertions.checkNotNull(format.sampleMimeType), format.codecs);
        boolean bl = supportedEncoding = encoding == 5 || encoding == 6 || encoding == 18 || encoding == 17 || encoding == 7 || encoding == 8 || encoding == 14;
        if (!supportedEncoding) {
            return null;
        }
        int n = channelCount = encoding == 18 ? 6 : format.channelCount;
        if (channelCount > audioCapabilities.getMaxChannelCount()) {
            return null;
        }
        int channelConfig = DefaultAudioSink.getChannelConfigForPassthrough(channelCount);
        if (channelConfig == 0) {
            return null;
        }
        if (audioCapabilities.supportsEncoding(encoding)) {
            return Pair.create((Object)encoding, (Object)channelConfig);
        }
        if (encoding == 18 && audioCapabilities.supportsEncoding(6)) {
            return Pair.create((Object)6, (Object)channelConfig);
        }
        return null;
    }

    private static int getChannelConfigForPassthrough(int channelCount) {
        if (Util.SDK_INT <= 28) {
            if (channelCount == 7) {
                channelCount = 8;
            } else if (channelCount == 3 || channelCount == 4 || channelCount == 5) {
                channelCount = 6;
            }
        }
        if (Util.SDK_INT <= 26 && "fugu".equals(Util.DEVICE) && channelCount == 1) {
            channelCount = 2;
        }
        return Util.getAudioTrackChannelConfig(channelCount);
    }

    private static boolean isOffloadedPlaybackSupported(Format format, AudioAttributes audioAttributes) {
        if (Util.SDK_INT < 29) {
            return false;
        }
        int encoding = MimeTypes.getEncoding(Assertions.checkNotNull(format.sampleMimeType), format.codecs);
        if (encoding == 0) {
            return false;
        }
        int channelConfig = Util.getAudioTrackChannelConfig(format.channelCount);
        if (channelConfig == 0) {
            return false;
        }
        AudioFormat audioFormat = DefaultAudioSink.getAudioFormat(format.sampleRate, channelConfig, encoding);
        if (!AudioManager.isOffloadedPlaybackSupported((AudioFormat)audioFormat, (android.media.AudioAttributes)audioAttributes.getAudioAttributesV21())) {
            return false;
        }
        boolean notGapless = format.encoderDelay == 0 && format.encoderPadding == 0;
        return notGapless || DefaultAudioSink.isOffloadedGaplessPlaybackSupported();
    }

    private static boolean isOffloadedPlayback(AudioTrack audioTrack) {
        return Util.SDK_INT >= 29 && audioTrack.isOffloadedPlayback();
    }

    private static boolean isOffloadedGaplessPlaybackSupported() {
        return Util.SDK_INT >= 30 && Util.MODEL.startsWith("Pixel");
    }

    private static AudioTrack initializeKeepSessionIdAudioTrack(int audioSessionId) {
        int sampleRate = 4000;
        int channelConfig = 4;
        int encoding = 2;
        int bufferSize = 2;
        return new AudioTrack(3, sampleRate, channelConfig, encoding, bufferSize, 0, audioSessionId);
    }

    private static int getMaximumEncodedRateBytesPerSecond(int encoding) {
        switch (encoding) {
            case 9: {
                return 40000;
            }
            case 10: {
                return 100000;
            }
            case 11: {
                return 16000;
            }
            case 12: {
                return 7000;
            }
            case 16: {
                return 256000;
            }
            case 15: {
                return 8000;
            }
            case 5: {
                return 80000;
            }
            case 6: 
            case 18: {
                return 768000;
            }
            case 17: {
                return 336000;
            }
            case 7: {
                return 192000;
            }
            case 8: {
                return 2250000;
            }
            case 14: {
                return 3062500;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int getFramesPerEncodedSample(int encoding, ByteBuffer buffer) {
        switch (encoding) {
            case 9: {
                int headerDataInBigEndian = Util.getBigEndianInt(buffer, buffer.position());
                int frameCount = MpegAudioUtil.parseMpegAudioFrameSampleCount(headerDataInBigEndian);
                if (frameCount == -1) {
                    throw new IllegalArgumentException();
                }
                return frameCount;
            }
            case 10: {
                return 1024;
            }
            case 11: 
            case 12: {
                return 2048;
            }
            case 16: {
                return 1024;
            }
            case 15: {
                return 512;
            }
            case 7: 
            case 8: {
                return DtsUtil.parseDtsAudioSampleCount(buffer);
            }
            case 5: 
            case 6: 
            case 18: {
                return Ac3Util.parseAc3SyncframeAudioSampleCount(buffer);
            }
            case 17: {
                return Ac4Util.parseAc4SyncframeAudioSampleCount(buffer);
            }
            case 14: {
                int syncframeOffset = Ac3Util.findTrueHdSyncframeOffset(buffer);
                return syncframeOffset == -1 ? 0 : Ac3Util.parseTrueHdSyncframeAudioSampleCount(buffer, syncframeOffset) * 16;
            }
        }
        throw new IllegalStateException("Unexpected audio encoding: " + encoding);
    }

    @RequiresApi(value=21)
    private static int writeNonBlockingV21(AudioTrack audioTrack, ByteBuffer buffer, int size) {
        return audioTrack.write(buffer, size, 1);
    }

    @RequiresApi(value=21)
    private int writeNonBlockingWithAvSyncV21(AudioTrack audioTrack, ByteBuffer buffer, int size, long presentationTimeUs) {
        int result;
        int avSyncHeaderBytesRemaining;
        if (Util.SDK_INT >= 26) {
            return audioTrack.write(buffer, size, 1, presentationTimeUs * 1000L);
        }
        if (this.avSyncHeader == null) {
            this.avSyncHeader = ByteBuffer.allocate(16);
            this.avSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.avSyncHeader.putInt(0x55550001);
        }
        if (this.bytesUntilNextAvSync == 0) {
            this.avSyncHeader.putInt(4, size);
            this.avSyncHeader.putLong(8, presentationTimeUs * 1000L);
            this.avSyncHeader.position(0);
            this.bytesUntilNextAvSync = size;
        }
        if ((avSyncHeaderBytesRemaining = this.avSyncHeader.remaining()) > 0) {
            result = audioTrack.write(this.avSyncHeader, avSyncHeaderBytesRemaining, 1);
            if (result < 0) {
                this.bytesUntilNextAvSync = 0;
                return result;
            }
            if (result < avSyncHeaderBytesRemaining) {
                return 0;
            }
        }
        if ((result = DefaultAudioSink.writeNonBlockingV21(audioTrack, buffer, size)) < 0) {
            this.bytesUntilNextAvSync = 0;
            return result;
        }
        this.bytesUntilNextAvSync -= result;
        return result;
    }

    @RequiresApi(value=21)
    private static void setVolumeInternalV21(AudioTrack audioTrack, float volume) {
        audioTrack.setVolume(volume);
    }

    private static void setVolumeInternalV3(AudioTrack audioTrack, float volume) {
        audioTrack.setStereoVolume(volume, volume);
    }

    private void playPendingData() {
        if (!this.stoppedAudioTrack) {
            this.stoppedAudioTrack = true;
            this.audioTrackPositionTracker.handleEndOfStream(this.getWrittenFrames());
            this.audioTrack.stop();
            this.bytesUntilNextAvSync = 0;
        }
    }

    @RequiresApi(value=21)
    private static AudioFormat getAudioFormat(int sampleRate, int channelConfig, int encoding) {
        return new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelConfig).setEncoding(encoding).build();
    }

    public static class DefaultAudioProcessorChain
    implements AudioProcessorChain {
        private final AudioProcessor[] audioProcessors;
        private final SilenceSkippingAudioProcessor silenceSkippingAudioProcessor;
        private final SonicAudioProcessor sonicAudioProcessor;

        public DefaultAudioProcessorChain(AudioProcessor ... audioProcessors) {
            this(audioProcessors, new SilenceSkippingAudioProcessor(), new SonicAudioProcessor());
        }

        public DefaultAudioProcessorChain(AudioProcessor[] audioProcessors, SilenceSkippingAudioProcessor silenceSkippingAudioProcessor, SonicAudioProcessor sonicAudioProcessor) {
            this.audioProcessors = new AudioProcessor[audioProcessors.length + 2];
            System.arraycopy(audioProcessors, 0, this.audioProcessors, 0, audioProcessors.length);
            this.silenceSkippingAudioProcessor = silenceSkippingAudioProcessor;
            this.sonicAudioProcessor = sonicAudioProcessor;
            this.audioProcessors[audioProcessors.length] = silenceSkippingAudioProcessor;
            this.audioProcessors[audioProcessors.length + 1] = sonicAudioProcessor;
        }

        @Override
        public AudioProcessor[] getAudioProcessors() {
            return this.audioProcessors;
        }

        @Override
        public PlaybackParameters applyPlaybackParameters(PlaybackParameters playbackParameters) {
            this.sonicAudioProcessor.setSpeed(playbackParameters.speed);
            this.sonicAudioProcessor.setPitch(playbackParameters.pitch);
            return playbackParameters;
        }

        @Override
        public boolean applySkipSilenceEnabled(boolean skipSilenceEnabled) {
            this.silenceSkippingAudioProcessor.setEnabled(skipSilenceEnabled);
            return skipSilenceEnabled;
        }

        @Override
        public long getMediaDuration(long playoutDuration) {
            return this.sonicAudioProcessor.getMediaDuration(playoutDuration);
        }

        @Override
        public long getSkippedOutputFrameCount() {
            return this.silenceSkippingAudioProcessor.getSkippedFrames();
        }
    }

    public static interface AudioProcessorChain {
        public AudioProcessor[] getAudioProcessors();

        public PlaybackParameters applyPlaybackParameters(PlaybackParameters var1);

        public boolean applySkipSilenceEnabled(boolean var1);

        public long getMediaDuration(long var1);

        public long getSkippedOutputFrameCount();
    }

    private final class PositionTrackerListener
    implements AudioTrackPositionTracker.Listener {
        private PositionTrackerListener() {
        }

        @Override
        public void onPositionFramesMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (frame position mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w(DefaultAudioSink.TAG, message);
        }

        @Override
        public void onSystemTimeUsMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (system clock mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w(DefaultAudioSink.TAG, message);
        }

        @Override
        public void onInvalidLatency(long latencyUs) {
            Log.w(DefaultAudioSink.TAG, "Ignoring impossibly large audio latency: " + latencyUs);
        }

        @Override
        public void onPositionAdvancing(long playoutStartSystemTimeMs) {
            if (DefaultAudioSink.this.listener != null) {
                DefaultAudioSink.this.listener.onPositionAdvancing(playoutStartSystemTimeMs);
            }
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs) {
            if (DefaultAudioSink.this.listener != null) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - DefaultAudioSink.this.lastFeedElapsedRealtimeMs;
                DefaultAudioSink.this.listener.onUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
    }

    private static final class MediaPositionParameters {
        public final PlaybackParameters playbackParameters;
        public final boolean skipSilence;
        public final long mediaTimeUs;
        public final long audioTrackPositionUs;

        private MediaPositionParameters(PlaybackParameters playbackParameters, boolean skipSilence, long mediaTimeUs, long audioTrackPositionUs) {
            this.playbackParameters = playbackParameters;
            this.skipSilence = skipSilence;
            this.mediaTimeUs = mediaTimeUs;
            this.audioTrackPositionUs = audioTrackPositionUs;
        }
    }

    private static final class Configuration {
        public final Format inputFormat;
        public final int inputPcmFrameSize;
        public final int outputMode;
        public final int outputPcmFrameSize;
        public final int outputSampleRate;
        public final int outputChannelConfig;
        public final int outputEncoding;
        public final int bufferSize;
        public final boolean canApplyPlaybackParameters;
        public final AudioProcessor[] availableAudioProcessors;

        public Configuration(Format inputFormat, int inputPcmFrameSize, int outputMode, int outputPcmFrameSize, int outputSampleRate, int outputChannelConfig, int outputEncoding, int specifiedBufferSize, boolean enableAudioTrackPlaybackParams, boolean canApplyPlaybackParameters, AudioProcessor[] availableAudioProcessors) {
            this.inputFormat = inputFormat;
            this.inputPcmFrameSize = inputPcmFrameSize;
            this.outputMode = outputMode;
            this.outputPcmFrameSize = outputPcmFrameSize;
            this.outputSampleRate = outputSampleRate;
            this.outputChannelConfig = outputChannelConfig;
            this.outputEncoding = outputEncoding;
            this.canApplyPlaybackParameters = canApplyPlaybackParameters;
            this.availableAudioProcessors = availableAudioProcessors;
            this.bufferSize = this.computeBufferSize(specifiedBufferSize, enableAudioTrackPlaybackParams);
        }

        public boolean canReuseAudioTrack(Configuration audioTrackConfiguration) {
            return audioTrackConfiguration.outputMode == this.outputMode && audioTrackConfiguration.outputEncoding == this.outputEncoding && audioTrackConfiguration.outputSampleRate == this.outputSampleRate && audioTrackConfiguration.outputChannelConfig == this.outputChannelConfig && audioTrackConfiguration.outputPcmFrameSize == this.outputPcmFrameSize;
        }

        public long inputFramesToDurationUs(long frameCount) {
            return frameCount * 1000000L / (long)this.inputFormat.sampleRate;
        }

        public long framesToDurationUs(long frameCount) {
            return frameCount * 1000000L / (long)this.outputSampleRate;
        }

        public long durationUsToFrames(long durationUs) {
            return durationUs * (long)this.outputSampleRate / 1000000L;
        }

        public AudioTrack buildAudioTrack(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) throws AudioSink.InitializationException {
            AudioTrack audioTrack;
            try {
                audioTrack = this.createAudioTrack(tunneling, audioAttributes, audioSessionId);
            }
            catch (UnsupportedOperationException e) {
                throw new AudioSink.InitializationException(0, this.outputSampleRate, this.outputChannelConfig, this.bufferSize);
            }
            int state = audioTrack.getState();
            if (state != 1) {
                try {
                    audioTrack.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AudioSink.InitializationException(state, this.outputSampleRate, this.outputChannelConfig, this.bufferSize);
            }
            return audioTrack;
        }

        private AudioTrack createAudioTrack(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            if (Util.SDK_INT >= 29) {
                return this.createAudioTrackV29(tunneling, audioAttributes, audioSessionId);
            }
            if (Util.SDK_INT >= 21) {
                return this.createAudioTrackV21(tunneling, audioAttributes, audioSessionId);
            }
            return this.createAudioTrackV9(audioAttributes, audioSessionId);
        }

        @RequiresApi(value=29)
        private AudioTrack createAudioTrackV29(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            AudioFormat audioFormat = DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding);
            android.media.AudioAttributes audioTrackAttributes = Configuration.getAudioTrackAttributesV21(audioAttributes, tunneling);
            return new AudioTrack.Builder().setAudioAttributes(audioTrackAttributes).setAudioFormat(audioFormat).setTransferMode(1).setBufferSizeInBytes(this.bufferSize).setSessionId(audioSessionId).setOffloadedPlayback(this.outputMode == 1).build();
        }

        @RequiresApi(value=21)
        private AudioTrack createAudioTrackV21(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            return new AudioTrack(Configuration.getAudioTrackAttributesV21(audioAttributes, tunneling), DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding), this.bufferSize, 1, audioSessionId);
        }

        private AudioTrack createAudioTrackV9(AudioAttributes audioAttributes, int audioSessionId) {
            int streamType = Util.getStreamTypeForAudioUsage(audioAttributes.usage);
            if (audioSessionId == 0) {
                return new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1);
            }
            return new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1, audioSessionId);
        }

        private int computeBufferSize(int specifiedBufferSize, boolean enableAudioTrackPlaybackParameters) {
            if (specifiedBufferSize != 0) {
                return specifiedBufferSize;
            }
            switch (this.outputMode) {
                case 0: {
                    return this.getPcmDefaultBufferSize(enableAudioTrackPlaybackParameters ? 8.0f : 1.0f);
                }
                case 1: {
                    return this.getEncodedDefaultBufferSize(50000000L);
                }
                case 2: {
                    return this.getEncodedDefaultBufferSize(250000L);
                }
            }
            throw new IllegalStateException();
        }

        private int getEncodedDefaultBufferSize(long bufferDurationUs) {
            int rate = DefaultAudioSink.getMaximumEncodedRateBytesPerSecond(this.outputEncoding);
            if (this.outputEncoding == 5) {
                rate *= 2;
            }
            return (int)(bufferDurationUs * (long)rate / 1000000L);
        }

        private int getPcmDefaultBufferSize(float maxAudioTrackPlaybackSpeed) {
            int minBufferSize = AudioTrack.getMinBufferSize((int)this.outputSampleRate, (int)this.outputChannelConfig, (int)this.outputEncoding);
            Assertions.checkState(minBufferSize != -2);
            int multipliedBufferSize = minBufferSize * 4;
            int minAppBufferSize = (int)this.durationUsToFrames(250000L) * this.outputPcmFrameSize;
            int maxAppBufferSize = Math.max(minBufferSize, (int)this.durationUsToFrames(750000L) * this.outputPcmFrameSize);
            int bufferSize = Util.constrainValue(multipliedBufferSize, minAppBufferSize, maxAppBufferSize);
            if (maxAudioTrackPlaybackSpeed != 1.0f) {
                bufferSize = Math.round((float)bufferSize * maxAudioTrackPlaybackSpeed);
            }
            return bufferSize;
        }

        @RequiresApi(value=21)
        private static android.media.AudioAttributes getAudioTrackAttributesV21(AudioAttributes audioAttributes, boolean tunneling) {
            if (tunneling) {
                return Configuration.getAudioTrackTunnelingAttributesV21();
            }
            return audioAttributes.getAudioAttributesV21();
        }

        @RequiresApi(value=21)
        private static android.media.AudioAttributes getAudioTrackTunnelingAttributesV21() {
            return new AudioAttributes.Builder().setContentType(3).setFlags(16).setUsage(1).build();
        }

        public boolean outputModeIsOffload() {
            return this.outputMode == 1;
        }
    }

    @RequiresApi(value=29)
    private final class StreamEventCallbackV29 {
        private final Handler handler = new Handler();
        private final AudioTrack.StreamEventCallback callback;

        public StreamEventCallbackV29() {
            this.callback = new AudioTrack.StreamEventCallback(){

                public void onDataRequest(AudioTrack track, int size) {
                    Assertions.checkState(track == DefaultAudioSink.this.audioTrack);
                    if (DefaultAudioSink.this.listener != null) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }

                public void onTearDown(@NonNull AudioTrack track) {
                    if (DefaultAudioSink.this.listener != null && DefaultAudioSink.this.playing) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }
            };
        }

        public void register(AudioTrack audioTrack) {
            audioTrack.registerStreamEventCallback(arg_0 -> ((Handler)this.handler).post(arg_0), this.callback);
        }

        public void unregister(AudioTrack audioTrack) {
            audioTrack.unregisterStreamEventCallback(this.callback);
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface OutputMode {
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        private InvalidAudioTrackTimestampException(String message) {
            super(message);
        }
    }
}

