/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.nielsenanalytics;

import android.content.Context;
import android.os.AsyncTask;
import com.akamai.amp.ads.AdsHelper;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.nielsenanalytics.AmpNielsenDcrAnalyticsTracker;
import com.akamai.amp.cast.OTTDevice;
import com.akamai.amp.cast.OTTDeviceEventsListener;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.GenericData;
import com.akamai.amp.config.data.NielsenAdData;
import com.akamai.amp.config.data.NielsenAppData;
import com.akamai.amp.config.data.NielsenContentData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.parser.utils.UtilsParser;
import com.akamai.amp.utils.LogManager;
import com.nielsen.app.sdk.AppSdk;
import com.nielsen.app.sdk.IAppNotifier;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class NielsenDcrEventsHandler
extends AnalyticsTracker<NielsenData>
implements AmpNielsenDcrAnalyticsTracker {
    public static final String OPT_OUT_LEGAL = "Nielsen believes that you should have a choice about whether to contribute to our research and insights. To opt out of Nielsen measurement on this device, you need only to activate the \"Limit Ad Tracking\" (for iOS devices) or \"Opt out of Ads Personalization\" (for Android devices) option in your device\u2019s settings.";
    private static final String LOG_TAG = "NielsenDcrAnalyticsAMP";
    private static final String VERSION = "9.10.7";
    private static final String NIELSEN_ACTION = "com.nielsen.app.sdk.AppSdk.";
    private static final String EXTRA_DEBUG_LOG_TAG = "NielsenAMPExtra";
    private static final String NIELSEN_NULL = "-UNKNOWN-";
    private static final String NIELSEN_URL_OPT_OUT = "nielsenappsdk://1";
    private static final String NIELSEN_URL_OPT_IN = "nielsenappsdk://0";
    private static final String DEFAULT_STRING = "?";
    private static final String NIELSEN_ID3_MARKER = "www.nielsen.com";
    private static AppSdk appSdk;
    private static ID3TagEventListener id3TagEventListener;
    private boolean isAdPlaying = false;
    private boolean isEngineStopped = true;
    private boolean prerollsOnVod = false;
    private boolean hasAdPlayed = false;
    private static boolean isOTTDeviceConnected;
    private Context owner;
    private boolean bufferSeekDelayEnabled = false;
    private int bufferSeekDelayMillis = 1500;
    private Date latestSeekEnd = Calendar.getInstance().getTime();
    private LatestPlay latestPlay = LatestPlay.CONTENT;
    private String latestContentUrl;
    private AdsInfo latestAd;
    private OTTDeviceEventsListener ottDeviceEventsListener = new OTTDeviceEventsListener(){

        public void onCastAppInit() {
        }

        public void onCastAppConnected(OTTDevice device) {
            if (!NielsenDcrEventsHandler.this.isNielsenInitialized()) {
                NielsenDcrEventsHandler.this.init();
            }
            NielsenDcrEventsHandler.this.trackDeviceConnected(device);
        }

        public void onCastAppDisconnected() {
            NielsenDcrEventsHandler.this.trackDeviceDisconnected();
        }
    };
    private final IAppNotifier nielsenAppNotifier = (timestamp, code, description) -> {
        boolean isStartup;
        String msg = ">>>>CALLBACK<<<< Timestamp(" + timestamp + ") Code(" + this.translateNielsenEventCode(code) + ") Description(" + description + ")";
        LogManager.log((String)LOG_TAG, (String)msg);
        boolean bl = isStartup = code == 2001;
        if (isStartup) {
            this.logGeneralNielsenInfo();
        }
    };

    public NielsenDcrEventsHandler(NielsenData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, VERSION);
    }

    public NielsenDcrEventsHandler(Context owner, NielsenData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, VERSION);
        this.owner = owner;
    }

    public NielsenDcrEventsHandler(VideoPlayerView videoPlayerView, NielsenData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, VERSION);
    }

    @Override
    public OTTDeviceEventsListener getOttDeviceEventsListener() {
        return this.ottDeviceEventsListener;
    }

    public void setContentLabel(String tag, String value) {
        NielsenContentData data = ((NielsenData)this.data).getContentData();
        data.addValue(tag, value);
    }

    public void setContentLabels(Map<String, String> map) {
        NielsenContentData data = ((NielsenData)this.data).getContentData();
        data.addValues(map);
    }

    public void setAdLabel(String tag, String value) {
        NielsenAdData data = ((NielsenData)this.data).getAdData();
        data.addValue(tag, value);
    }

    public void setAdLabels(Map<String, String> map) {
        NielsenAdData data = ((NielsenData)this.data).getAdData();
        data.addValues(map);
    }

    public void init() {
        LogManager.log((String)LOG_TAG, (String)"NielsenDcrEventsHandler.init()");
        this.intializeNielsenSdk();
        this.setupID3TagsHandler();
    }

    private void setupID3TagsHandler() {
        id3TagEventListener = this.initID3TagEventListener();
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.addId3TagsEventListener(id3TagEventListener);
    }

    private ID3TagEventListener initID3TagEventListener() {
        ID3TagEventListener listener = data -> {
            if (data == null || data.getText() == null) {
                LogManager.error((String)LOG_TAG, (String)"NULL ID3TagData found");
                return false;
            }
            String id3 = data.getText();
            if (id3.length() < 5) {
                LogManager.error((String)LOG_TAG, (String)("Invalid id3Tag, length: " + id3.length() + ", content: " + id3));
                return false;
            }
            this.trySendID3(id3);
            return true;
        };
        return listener;
    }

    public void trackOnDestroy() {
        this.removeFromPlayerListeners();
        AsyncTask.execute(this::closeSession);
    }

    private void closeSession() {
        this.isEngineStopped = true;
        if (appSdk != null) {
            appSdk.close();
            LogManager.log((String)LOG_TAG, (String)"com.nielsen.app.sdk.AppSdk.close()");
            appSdk = null;
        }
    }

    public String getExternalLibVersion() {
        return AppSdk.getMeterVersion();
    }

    protected NielsenData loadDataFromConfig() {
        return Config.getInstance().nielsenData;
    }

    @Override
    public boolean isNielsenInitialized() {
        if (appSdk == null) {
            return false;
        }
        boolean isValid = this.isValid(appSdk);
        return isValid;
    }

    public void resetVideoPlayerView(VideoPlayerView videoView) {
        super.resetVideoPlayerView(videoView);
    }

    @Override
    public boolean isValid(AppSdk sdk) {
        if (sdk == null) {
            LogManager.error((String)LOG_TAG, (String)"NielsenDcrEventsHandler.isValid() received a NULL com.nielsen.app.sdk.AppSdk");
            return false;
        }
        boolean result = sdk.isValid();
        if (!result) {
            String errorMsg = "AppSdk is NOT valid. Last error: <" + sdk.getLastError() + ">, last event: <" + sdk.getLastEvent() + ">";
            LogManager.error((String)LOG_TAG, (String)errorMsg);
        }
        return result;
    }

    @Override
    public String getOptOutUrl() {
        if (!this.isNielsenInitialized()) {
            return DEFAULT_STRING;
        }
        String optOutUrl = appSdk.userOptOutURLString();
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.userOptOutURLString() <" + optOutUrl + ">"));
        return optOutUrl;
    }

    @Override
    public void userOptOut(String optOut) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        if (NIELSEN_URL_OPT_OUT.equals(optOut)) {
            appSdk.userOptOut(optOut);
            LogManager.log((String)LOG_TAG, (String)("userOptOut() The user opted OUT with URL " + optOut));
        } else if (NIELSEN_URL_OPT_IN.equals(optOut)) {
            appSdk.userOptOut(optOut);
            LogManager.log((String)LOG_TAG, (String)("userOptOut() The user opted IN with URL " + optOut));
        } else {
            LogManager.error((String)LOG_TAG, (String)("ERROR: tried to call userOptOut() with unrecognized URL: " + optOut));
        }
    }

    @Override
    public void appDisableApi(boolean disable) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.appDisableApi(disable);
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.appDisableApi() " + disable));
    }

    @Override
    public String getNielsenId() {
        if (!this.isNielsenInitialized()) {
            return DEFAULT_STRING;
        }
        String nielsenId = appSdk.getNielsenId();
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.getNielsenId() " + nielsenId));
        return nielsenId;
    }

    @Override
    public String getDeviceId() {
        if (!this.isNielsenInitialized()) {
            return DEFAULT_STRING;
        }
        String deviceId = appSdk.getDeviceId();
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.getDeviceId(): " + deviceId));
        return deviceId;
    }

    @Override
    public String getAppSdkVersion() {
        return AppSdk.getMeterVersion();
    }

    public void trySendID3(String id3) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        if (this.isLive) {
            if (this.isNielsenID3(id3)) {
                appSdk.sendID3(id3);
                LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.sendID3() Valid Nielsen ID3 tag on a Live stream, sending: [" + id3 + "]"));
            } else {
                LogManager.log((String)LOG_TAG, (String)("Non Nielsen ID3 tag on a Live stream, NOT sending: [" + id3 + "]"));
            }
        } else {
            LogManager.log((String)LOG_TAG, (String)("VOD stream, NOT sending Nielsen DCR ID3 tag: [" + id3 + "]"));
        }
    }

    public long getPlayheadPositionForLive() {
        long currentUtcSeconds = System.currentTimeMillis() / 1000L;
        return currentUtcSeconds;
    }

    public void trackPositionUpdate(long playheadPosition) {
        if (!this.mEnabledReporting) {
            return;
        }
        this.setPlayheadPosition(playheadPosition, false, "content");
    }

    public void trackPlayEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackPlayEvent");
        if (!this.mEnabledReporting) {
            return;
        }
        if (this.latestPlay.wasContent()) {
            this.playContent(this.latestContentUrl, true);
        }
    }

    public void trackStopPlaying() {
        LogManager.log((String)LOG_TAG, (String)"trackStopPlaying");
        this.stop();
    }

    public void trackStartPlaying(int duration, boolean isLive, String streamUrl) {
        LogManager.log((String)LOG_TAG, (String)("trackStartPlaying: duration: " + duration + ", isLive: " + isLive + ", streamUrl: " + streamUrl));
        if (!this.mEnabledReporting) {
            return;
        }
        this.playContent(streamUrl, true);
    }

    public void trackPauseEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackPauseEvent");
        if (!this.mEnabledReporting) {
            return;
        }
        this.stop();
    }

    public void trackResumeEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackResumeEvent");
        if (!this.mEnabledReporting) {
            return;
        }
        this.restartPlayingContentOrAd();
    }

    public void trackFinish() {
        LogManager.log((String)LOG_TAG, (String)"trackFinish");
        if (!this.mEnabledReporting) {
            return;
        }
        this.stop();
        this.end();
    }

    public void trackSendToBackground() {
        LogManager.log((String)LOG_TAG, (String)"trackSendToBackground");
        this.stop();
    }

    public void trackSendToForeground() {
        LogManager.log((String)LOG_TAG, (String)"trackSendToForeground");
        this.restartPlayingContentOrAd();
    }

    public void trackError(String errorMessage) {
        LogManager.error((String)LOG_TAG, (String)("trackError: " + errorMessage));
        if (!this.mEnabledReporting) {
            return;
        }
        this.stop();
    }

    public void trackSizeChange() {
        LogManager.error((String)LOG_TAG, (String)"trackSizeChange");
        this.isEngineStopped = false;
    }

    public void trackAdsStarted(AdsInfo ad) {
        if (ad == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("onAdsStarted() " + ad));
        this.latestAd = ad;
        this.playAd(this.latestAd);
    }

    public void trackAdsPaused() {
        LogManager.log((String)LOG_TAG, (String)"onAdsPaused()");
        this.stop();
    }

    public void trackAdsResumed() {
        LogManager.log((String)LOG_TAG, (String)"onAdsResumed()");
        this.playAd(this.latestAd);
    }

    public void trackAdsEnded() {
        LogManager.log((String)LOG_TAG, (String)"onAdsEnded()");
        this.stopAds();
    }

    public void trackAdBreakEnd() {
        LogManager.log((String)LOG_TAG, (String)"onAdBreakEnded()");
        this.hasAdPlayed = true;
    }

    public void trackAdsTrackProgress(int progress) {
        LogManager.log((String)LOG_TAG, (String)("onAdsTrackProgress() " + AdsHelper.translateProgressCode((int)progress) + "%"));
    }

    public void trackAdsPlayheadUpdate(int seconds) {
        String adTag = this.getAdTag(this.latestAd);
        this.setPlayheadPosition(seconds, true, adTag);
    }

    public void trackAdsError(String reason) {
        LogManager.error((String)LOG_TAG, (String)("onAdsError: " + reason));
        this.stopAds();
    }

    public void trackPauseContentRequested() {
        LogManager.log((String)LOG_TAG, (String)"onPauseContentRequested()");
        this.stop();
    }

    public void trackResumeContentRequested() {
        boolean comingFromPreroll;
        LogManager.log((String)LOG_TAG, (String)"onResumeContentRequested()");
        this.stop();
        boolean bl = comingFromPreroll = this.latestPlay.wasAnAd() && this.latestAd.isPreroll();
        if (comingFromPreroll) {
            LogManager.log((String)LOG_TAG, (String)"Just finished a preroll and will start content, invoking loadMetadata(content) again");
            this.loadContentMetadata();
        }
    }

    public void trackDeviceConnected(OTTDevice args) {
        try {
            if (isOTTDeviceConnected) {
                return;
            }
            LogManager.log((String)LOG_TAG, (String)"trackDeviceConnected() with ottStatus 1 ");
            JSONObject jsonArgs = new JSONObject();
            jsonArgs.put("ottStatus", (Object)"1");
            if (args != null) {
                jsonArgs.put("ottType", (Object)args.type).put("ottName", (Object)args.name).put("ottDevice", (Object)args.device).put("ottDeviceManufacturer", (Object)args.manufacturer).put("ottDeviceName", (Object)args.deviceName).put("ottDeviceID", (Object)args.deviceID).put("ottDeviceModel", (Object)args.deviceModel).put("ottDeviceVersion", (Object)args.deviceVersion);
            } else {
                LogManager.log((String)LOG_TAG, (String)"trackDeviceConnected Device info is null ");
            }
            LogManager.log((String)LOG_TAG, (String)("trackDeviceConnected Device info: " + jsonArgs.toString()));
            this.trackFinish();
            this.updateOTT(jsonArgs);
            isOTTDeviceConnected = true;
        }
        catch (JSONException e) {
            isOTTDeviceConnected = false;
            LogManager.error((String)LOG_TAG, (String)("Error parsing device data -> " + e.getLocalizedMessage()));
        }
    }

    public void trackDeviceDisconnected() {
        try {
            if (!isOTTDeviceConnected) {
                return;
            }
            LogManager.log((String)LOG_TAG, (String)"trackDeviceDisconnected() with ottStatus 0 and no args");
            JSONObject jsonArgs = new JSONObject();
            jsonArgs.put("ottStatus", (Object)"0");
            this.updateOTT(jsonArgs);
            isOTTDeviceConnected = false;
        }
        catch (JSONException e) {
            LogManager.error((String)LOG_TAG, (String)("Error parsing device data -> " + e.getLocalizedMessage()));
        }
    }

    @Override
    public void loadDarTag(String darTag) {
        LogManager.log((String)LOG_TAG, (String)("loadDarTag -> " + darTag));
        LinkedHashMap<String, String> darData = new LinkedHashMap<String, String>();
        darData.put("type", "ad");
        darData.put("ocrtag", darTag);
        JSONObject jsonDarData = new JSONObject(darData);
        this.loadMetadata(jsonDarData);
    }

    @Override
    public void prerollsOnVod() {
        this.prerollsOnVod = true;
    }

    public Context getOwner() {
        Context context = super.getOwner();
        if (context == null && this.owner != null) {
            return this.owner;
        }
        return context;
    }

    @Override
    public String getDemographicId() {
        if (!this.isNielsenInitialized()) {
            return "";
        }
        return appSdk.getDemographicId();
    }

    @Override
    public String getOptOutStatus() {
        if (!this.isNielsenInitialized()) {
            return "";
        }
        return String.valueOf(appSdk.getOptOutStatus());
    }

    private void stopAds() {
        if (this.isAdPlaying) {
            this.isAdPlaying = false;
            this.stop();
        }
    }

    private String getAdTag(AdsInfo ad) {
        if (ad == null) {
            return "ad";
        }
        String position = ad.getPosition();
        return position;
    }

    private String buildConfigJson() {
        NielsenAppData appData = ((NielsenData)this.data).getAppData();
        String metaData = this.getDataJson((GenericData)appData);
        return metaData;
    }

    private void playAd(AdsInfo ad) {
        if (ad == null) {
            return;
        }
        this.isAdPlaying = true;
        this.latestPlay = LatestPlay.AD;
        this.isEngineStopped = false;
        String metadataJson = this.getAdMetadata(ad);
        this.loadMetadata(metadataJson, this.getAdTag(ad));
    }

    private String getAdMetadata(AdsInfo ad) {
        NielsenAdData adData = ((NielsenData)this.data).getAdData();
        if (ad != null) {
            adData.addValue("type", "ad");
            adData.addValue("assetid", ad.adId);
        }
        String metaData = this.getDataJson((GenericData)adData);
        return metaData;
    }

    private void playContent(String streamUrl, boolean sendPlayBeacon) {
        if (streamUrl == null || streamUrl.isEmpty()) {
            LogManager.error((String)LOG_TAG, (String)"playContent() with null or empty streamUrl");
            return;
        }
        this.latestPlay = LatestPlay.CONTENT;
        this.latestContentUrl = streamUrl;
        this.isEngineStopped = false;
        if (sendPlayBeacon) {
            String channelInfoJson = this.getContentChannelInfo(streamUrl);
            LogManager.log((String)LOG_TAG, (String)("CONTENT channelInfoJson -> " + UtilsParser.prettyPrint((String)channelInfoJson)));
            this.play(channelInfoJson);
        }
        this.loadContentMetadata();
    }

    private void loadContentMetadata() {
        if (this.isAdPlaying) {
            return;
        }
        String metadataJson = this.getContentMetadata();
        this.loadMetadata(metadataJson, "content");
    }

    private String getContentChannelInfo(String streamUrl) {
        LinkedHashMap values = new LinkedHashMap();
        String channelName = ((NielsenData)this.data).getAppData().getValue("channelName");
        if (channelName == null || channelName.isEmpty()) {
            channelName = streamUrl;
        }
        this.addValue("channelName", channelName, values);
        String channelInfo = UtilsParser.mapToJson(values);
        return channelInfo;
    }

    private String getContentMetadata() {
        NielsenContentData contentData = this.getNielsenContentData();
        String metaData = this.getDataJson((GenericData)contentData);
        return metaData;
    }

    private NielsenContentData getNielsenContentData() {
        NielsenContentData contentData = ((NielsenData)this.data).getContentData();
        if (this.isLive) {
            contentData.setLive();
        }
        return contentData;
    }

    private String getDataJson(GenericData data) {
        this.setValuesToContentData(data);
        this.checkMissingMandatoryValues(data, LOG_TAG, NIELSEN_NULL);
        String metaData = UtilsParser.mapToJson((Map)data.getValues());
        return metaData;
    }

    private void setValuesToContentData(GenericData data) {
        if (data instanceof NielsenContentData) {
            data.addValue("type", "content");
            int length = this.duration;
            data.putValue("length", length + "");
            String adloadtype = this.isLive ? "1" : "2";
            data.addValue("adloadtype", adloadtype);
        }
    }

    private boolean isNielsenID3(String id3) {
        boolean result = id3.contains(NIELSEN_ID3_MARKER);
        return result;
    }

    private String translateNielsenEventCode(int code) {
        switch (code) {
            case 2000: {
                return "EVENT_INITIATE";
            }
            case 2001: {
                return "EVENT_STARTUP";
            }
            case 2002: {
                return "EVENT_SHUTDOWN";
            }
        }
        return "UNKNOWN EVENT";
    }

    private void restartPlayingContentOrAd() {
        if (this.isAdPlaying) {
            this.playAd(this.latestAd);
        } else {
            boolean validContentUrl;
            boolean bl = validContentUrl = this.latestContentUrl != null;
            if (validContentUrl) {
                this.playContent(this.latestContentUrl, false);
            }
        }
    }

    private void logGeneralNielsenInfo() {
        LogManager.log((String)LOG_TAG, (String)("Nielsen information: NielsenId(" + this.getNielsenId() + ")"));
        LogManager.log((String)LOG_TAG, (String)("Nielsen information: DeviceId(" + this.getDeviceId() + ")"));
        LogManager.log((String)LOG_TAG, (String)("Nielsen information: SdkVersion(" + AppSdk.getMeterVersion() + ")"));
        LogManager.log((String)LOG_TAG, (String)("Nielsen information: UserOptOutUrl(" + this.getOptOutUrl() + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intializeNielsenSdk() {
        String configJson = this.buildConfigJson();
        Class<NielsenDcrEventsHandler> clazz = NielsenDcrEventsHandler.class;
        synchronized (NielsenDcrEventsHandler.class) {
            if (appSdk == null) {
                Context c = this.getOwner();
                appSdk = new AppSdk(c, configJson, this.nielsenAppNotifier);
                LogManager.log((String)LOG_TAG, (String)("Initialized Nielsen DCR's AppSdk with context: " + c));
                LogManager.log((String)LOG_TAG, (String)UtilsParser.prettyPrint((String)configJson));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!this.isNielsenInitialized()) {
                LogManager.error((String)LOG_TAG, (String)"com.nielsen.app.sdk.AppSdk is not initialized");
            } else {
                this.logGeneralNielsenInfo();
            }
            return;
        }
    }

    private void loadMetadata(String metaData, String tag) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.loadMetadata(metaData);
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.loadMetadata(String, String) for " + tag + " -> " + metaData));
    }

    private void loadMetadata(JSONObject metaData) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.loadMetadata(metaData);
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.loadMetadata(JSONObject) " + metaData));
    }

    private void play(String tag) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.play(tag);
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.play() " + tag));
    }

    private void setPlayheadPosition(long playheadPosition, boolean isAd, String tag) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        if (this.isAdPlaying != isAd) {
            LogManager.log((String)EXTRA_DEBUG_LOG_TAG, (String)("setPlayheadPosition returns, isAdPlaying " + this.isAdPlaying + " isAd " + isAd));
            return;
        }
        if (this.isEngineStopped) {
            LogManager.log((String)EXTRA_DEBUG_LOG_TAG, (String)("setPlayheadPosition returns, isEngineStopped " + this.isEngineStopped));
            return;
        }
        if (this.prerollsOnVod) {
            boolean isVod;
            boolean bl = isVod = !this.isLive;
            if (isVod && !isAd && !this.hasAdPlayed) {
                LogManager.log((String)EXTRA_DEBUG_LOG_TAG, (String)("setPlayheadPosition returns, isAd " + isAd + " hasAdPlayed " + this.hasAdPlayed));
                return;
            }
        }
        this.checkPlayheadPosition(playheadPosition, tag);
    }

    private void checkPlayheadPosition(long playheadPosition, String tag) {
        if (this.bufferSeekDelayEnabled) {
            boolean seekEndAllowsPlayhead = this.seekEndAllowsPlayhead(playheadPosition, tag);
            if (seekEndAllowsPlayhead) {
                this.executePlayheadPosition(playheadPosition, tag);
            }
        } else {
            this.executePlayheadPosition(playheadPosition, tag);
        }
    }

    private void executePlayheadPosition(long playheadPosition, String tag) {
        appSdk.setPlayheadPosition(playheadPosition);
        LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.setPlayheadPosition " + playheadPosition + " " + tag));
    }

    private boolean seekEndAllowsPlayhead(long playheadPosition, String tag) {
        Calendar now = Calendar.getInstance();
        Calendar cutoffTime = Calendar.getInstance();
        cutoffTime.setTime(this.latestSeekEnd);
        cutoffTime.add(14, this.bufferSeekDelayMillis);
        boolean result = cutoffTime.before(now);
        if (!result) {
            LogManager.log((String)LOG_TAG, (String)("com.nielsen.app.sdk.AppSdk.setPlayheadPosition !seekEndAllowsPlayhead " + playheadPosition + " " + tag + " latestSeekEnd: " + this.latestSeekEnd.getTime() + " Now: " + now.get(14) + " bufferSeekDelayMillis: " + this.bufferSeekDelayMillis));
        }
        return result;
    }

    private void stop() {
        if (this.isEngineStopped) {
            LogManager.log((String)LOG_TAG, (String)"AppSdk.stop(), appSdk.stop() already called");
            return;
        }
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.stop();
        LogManager.log((String)LOG_TAG, (String)"com.nielsen.app.sdk.AppSdk.stop()");
        this.isEngineStopped = true;
    }

    private void end() {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.end();
        LogManager.log((String)LOG_TAG, (String)"com.nielsen.app.sdk.AppSdk.end()");
        this.isEngineStopped = true;
    }

    private void updateOTT(JSONObject args) {
        if (!this.isNielsenInitialized()) {
            return;
        }
        appSdk.updateOTT(args);
        LogManager.log((String)LOG_TAG, (String)"com.nielsen.app.sdk.AppSdk.updateOTT()");
        this.isEngineStopped = true;
    }

    public void trackSeekComplete() {
        this.latestSeekEnd = Calendar.getInstance().getTime();
    }

    @Override
    public int getBufferSeekDelayMillis() {
        return this.bufferSeekDelayMillis;
    }

    @Override
    public void enableBufferSeekDelay(int bufferSeekDelayMillis) {
        this.bufferSeekDelayMillis = bufferSeekDelayMillis;
        this.bufferSeekDelayEnabled = true;
    }

    @Override
    public void enableBufferSeekDelay() {
        this.bufferSeekDelayEnabled = true;
    }

    static {
        isOTTDeviceConnected = false;
    }

    private static enum LatestPlay {
        CONTENT,
        AD;


        public boolean wasAnAd() {
            return AD == this;
        }

        public boolean wasContent() {
            return CONTENT == this;
        }
    }
}

